# jconfirm.tcl - (optional) confirmation panel
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.
# 
# 
# this procedure is required by (at least)
#     browser.tk
#     edit.tk
#     help.tk
#     more.tk
#     people.tk
#     prefs.tk
######################################################################

### TO DO

######################################################################
# global variables:
#
global J_PREFS env
if {! [info exists J_PREFS(autoposition)]} {set J_PREFS(autoposition) 0}
if {! [info exists J_PREFS(confirm)]} {set J_PREFS(confirm) 1}
#
######################################################################


######################################################################
# j:confirm ?options? - Cancel/OK dialogue box
# options include
#   -title (default "Confirm")
#   -text (default "Are you sure?")
#   -priority (default 0)
#   -yesbutton (default "OK")
#   -nobutton (default "Cancel")
# returns true (1) on OK; false (0) on Cancel
# if (priority == 0 && $J_PREFS(confirm) == 0), the dialogue box is
#   not displayed; it always returns 1
######################################################################

proc j:confirm { args } {
  j:parse_args {
    {title Confirm}
    {priority 0}
    {text "Are you sure?"}
    {yesbutton OK}
    {nobutton Cancel}
  }
  
  global confirm_result
  global J_PREFS			;# for J_PREFS(confirm)

  if { (! $J_PREFS(confirm)) && (! $priority) } {
    return 1
  }

  set old_focus [j:current_focus]	;# so we can restore original focus

  toplevel .confirm
  wm title .confirm $title
  
  message .confirm.msg -width 300 -anchor w -text $text
  j:buttonbar .confirm.b -default ok -buttons [format {
    {ok %s {set confirm_result 1; destroy .confirm}}
    {cancel %s {set confirm_result 0; destroy .confirm}}
  } $yesbutton $nobutton]
  
  pack .confirm.msg -side top -fill both -expand yes -padx 10 -pady 10
  pack [j:rule .confirm -width 200] -side top -fill x
  pack .confirm.b -side bottom -fill x
  
  j:dialogue .confirm		;# position in centre of screen

  focus .confirm
  j:default_button .confirm.b.ok .confirm
  j:cancel_button .confirm.b.cancel .confirm
  grab .confirm
  tkwait window .confirm
  focus $old_focus
  return $confirm_result
}
