### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#
# funktion to chose between two element. just like "? : " operator
#
proc pick {truth true false} {
  if {[uplevel \#0 expr \{$truth\}]} {
    return $true
  } else {
    return $false
  }
}
  

proc _tospace {str} {
  return [join [split $str "_"] " "]
}

proc spaceto_ {str} {
  return [join [split $str " "] "_"]
}

proc checkInt {widget} {
  if {![regexp {^-?[0-9]*$} [$widget get]]} {
    $widget delete [expr [$widget index insert] -1] [$widget index insert]
    error "This entry is only for integers"
  }
}

proc checkFloat {widget} {
  if {![regexp {^-?[0-9]*\.?[0-9]*$} [$widget get]]} {
    $widget delete [expr [$widget index insert] -1] [$widget index insert]
    error "This entry is only for floating points"
  }
}

#
# append to a list, if it the element doesn't exist.
#
proc uniqAppend {list value} {
  upvar $list l
  if {![info exists l]} {
    uplevel set \"$list\" [list \"$value\"]
  } elseif {[lsearch -exact $l $value] == -1} {
    uplevel lappend \"$list\" \"$value\"
  }
}

proc lremove {list value} {
  set index [lsearch -exact $list $value]
  if {$index == -1} {
    return "__error__"
  }
  return [lreplace $list $index $index]
}

proc min {x y} {
  if {$x < $y} {return $x}
  return $y
}
proc max {x y} {
  if {$x > $y} {return $x}
  return $y
}

############################################################
# This function checks wheter element can be a index in
# a widget with noOfElm number of elements.
############################################################
proc isIndex {element noOfElm} {
  if {![regexp {^[0-9]+$} $element]} {
    return 0
  }
  if {[expr $element+1] > $noOfElm} {
    return 0
  }
  return 1
}

proc TkTrue {value} {
  if {$value == "1" || $value == "true" || $value == "yes" || $value == "on"} {
    return 1
  } else {
    return 0
  }
}
