/* @(#) $Header: udpdump.c,v 1.5 91/05/09 07:39:11 deyke Exp $ */

/* UDP packet tracing
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"

#define	RIP_PORT	520

#define	UDPHDR		8

/* Dump a UDP header */
void udp_dump(unsigned char *data, int length)
{
	int hdr_length;
	int source;
	int dest;

	hdr_length = get16(data + 4);
	source     = get16(data + 0);
	dest       = get16(data + 2);

	fprintf(stdout, "UDP:");

	fprintf(stdout, " len %d", hdr_length);
	fprintf(stdout, " %d->%d", source, dest);
	
	if (hdr_length > UDPHDR)
	{
		length -= UDPHDR;
		data   += UDPHDR;
	
		switch (dest)
		{
			case RIP_PORT:
				rip_dump(data, length);
				break;
			default:
				fprintf(stdout, " Data %d\n", length);
				data_dump(data, length);
				break;
		}
	}
}

