#ifndef __VR_SCENE_H__
#define __VR_SCENE_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of a VR scene.                                                 //  
//  LAST EDIT: Wed Nov 30 08:54:52 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART/VR extension. Copying, distribution and     //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright '94 '95 Ekkehard 'Ekki' Beier                                //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>
#include "vr_comm.h"

extern const char *VRN_USER;

// to be set externally:

extern RT_Vector vr_Position;
extern double vr_Angle;
extern int vr_MaxUsers;
extern RT_String vr_Msg; 

class VR_User: public RT_GeneralListEntry {
    RT_String name; // user@host
    int uid; // user ID
    int no; // number in the area 0 to vr_MaxUsers - 1
    int xval;
  public:
    VR_User(const char *_name, int _uid, int _no ): name( _name ), uid( _uid ), no( _no ), xval( 1 ), data( 0 ) {}
    ~VR_User() { if (data) delete data; }
    int isA(const char *_c) const { return RTM_isA( _c, VRN_USER ); }
    void print(FILE *f) const { fprintf( f, "VR_USER No. %i: %s, ID: %i\n", no, (char*)name, uid); }
    int getID() const { return uid; }
    int getNumber() const { return no; }
    const RT_String &getName() const { return name; }

    // the position in WC:
    RT_Vector position;
    // the rotation around the y axis, measured from the positive z axis:
    double angle;

    int isValid() const { return xval; }
    void invalid() { xval = 0; }

    VR_UserData *data;
};

extern const char *VRN_SCENE;

typedef enum {
    VR_MESSAGE = 0,
    VR_COMMAND 
} VRE_Broadcast;

class VR_Scene: public RT_Object, private RT_GeneralList {
    static RT_ParseEntry table[];

    //##### statics for parameter parsing:
    static int loF, loV, rpF, rpV;

    RT_String xscene, cdesc;
    RT_String dumpFile;
    // name of the last created dump file
    int users;
    RT_Scene *sc; // the global scene
    int sofd; // socket file descriptor 

    void broadcast(const RT_String &, VRE_Broadcast) const;
    // send a broadcast ( message or command ) to all users

    void dump(const char *FILENAME);
    // print a dump of the system to the specified file
    // there will be dumped: primitives, lights, Tcl classes, attributes
    // but no other objects! (textures, mappings etc. )

  public:
    //#### Tcl/C++ methods:
    VR_Scene(const char *SCENE_DESC);
    const char *get_description() const { return "A scene server for the YART/VR extension."; }
    int isA(const char *n) const { return RTM_isA( n, VRN_SCENE) || RT_Object::isA( n ); } 
    const char *get_class() const { return VRN_SCENE; }
    void print( FILE *fp) const {
	// print out the state of the VR scene
	RT_GeneralList::print( fp );
    }

    VR_User *find(int ID);
    // return the user with this ID or NULL

    VR_User *find(const char *PRIM);
    // return the user with this representation or NULL

    VR_User *findInvalidUser();
    // return an invalid user or Null

    void newUser(VR_User *USER);

    void killUser(VR_User *USER);
    // kill users representation(s) and send 
    // a message around. the user must be removed already
    // from the list!

    const RT_String &getSceneName() const { return xscene; } 

    //#### external interface (to be extended in subclasses):
    // look into the parse table for description
    VR_User *login(const char * /*USER@HOST*/, const char *REPRESENTATION );
    void logout(int UID);
    void send(int UID, char *TXT);
    void command(int UID, char *CMD );
    void resetPosition(int UID);

    virtual void forward(int UID, double DISTANCE);
    virtual void upward(int UID, double DISTANCE);
    virtual void rotate(int UID, double ANGLE);
    virtual void pick(int UID, char *OBJ_NAME);
 
    //#### Tcl commands:
    int objectCMD(char *[]);

    // normally the doWithElements method should be provided
    // publically by an access declaration like
    // "RT_GeneralList::doWithElements;" 
    // But this brings heavy run time errors on AT&T
    // thus I'm using this solution:
    void iterate(RT_GeneralListFunctoid *f, void *v = 0) const {
	doWithElements( f, v );
    }

    void evalAndBroadcast(const RT_String &str) {
	// eval command an send a command broadcast 
	 Tcl_GlobalEval( rt_Ip, (char*)str);
	 broadcast( str, VR_COMMAND );
    }
};

extern VR_Scene *vr_Scene;

#endif
