////////////////////////////////////////////////////////////////////////////////
//  This is a DXF to YART 1.0 converter. Originally made by Ulf D"oring.      //  
//  LAST EDIT: Fri Aug 19 15:37:21 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////


// literature: 	AutoCAD Handbuch fuer Benutzeranpassungen (Release 12)

class RT_Vector {
  public:
    double x, y, z;
};

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define DXF_ERR_noErr         0
#define DXF_ERR_Param         1
#define DXF_ERR_fread         2
#define DXF_ERR_nogc          3
#define DXF_ERR_dxfeof	      4
#define DXF_ERR_dxfeos	      5
#define DXF_ERR_dxfsqe	      6
#define DXF_ERR_dxfgc0	      7
#define DXF_ERR_unexp_entry   8
#define DXF_ERR_unexp_gc      9
#define DXF_ERR_double_exp   10
#define DXF_ERR_number_exp   11
#define DXF_ERR_1_exp        12
#define DXF_ERR_y_exp	     13
#define DXF_ERR_unknown_vert 14
#define DXF_ERR_malloc       15


#define on      1
#define	off     0
#define false   0
#define	true    1
#define RayEps  1.0

#define DXF_MAX_strlen    256      /* [1] 277(Hinweis), 307(Kasten) */
#define DXF_MAX_vert      500

#define DXF_Check_ERR if (errcode!=DXF_ERR_noErr) return errcode
const char *DXF_father = "dxf"; 

// prototypes: 

int doit();
int find_gc( int gc, char *namestr);
int find_gc0_name( char *namestr);
int check_next_gc( int gc);
int check_next_entry( int gc, char *wertstr);
void calcNorm( int n, RT_Vector *points, RT_Vector *norm);

int check_next_entryv( int gc, double w);
int manag_LINE();
int manag_3DFACE();
int manag_POLYLINE();
int get_vertex(long *w70,double *x, double *y, double *z);
int get_vv_vertex(long *w70,long *w71,long *w72,long *w73,long *w74,double *x,double *y,double *z);
int get_point(int *gc ,double *x, double *y, double *z);
int read_gc_wert(int *gc ,char *wertstr);

FILE *DXF_fpIn;
FILE *DXF_fpOut;
unsigned long DXF_aktzeile;
unsigned char DXF_Check_EOF = on;
unsigned char DXF_Check_EOS = off;  /* End of SECTION   */
unsigned char DXF_Check_SQE = off;  /* SEQEND           */
unsigned char DXF_Check_GC0 = off;  /* Gruppencode == 0 */
unsigned char DXF_Skip_REM = on;
unsigned char DXF_gc_w_in_buff = false;
int DXF_buff_gc = 0;
unsigned long DXF_hexname = 0;

char DXF_buff_wertstr[DXF_MAX_strlen+1]	="EOF";
char DXF_akt_layer[DXF_MAX_strlen+1]	="0";

void clr_anf_str(char *s)
/*         am Anfang werden Leer- und Steuerzeichen entfernt          */
{  while ((*s)&&(*s<'\33')) { ++s;}
}

void clr_end_str(char *s)
/*        am Ende werden Leer- und Steuerzeichen entfernt          */

{    char *p=s+strlen(s);
     while ((p>s)&&
	    ('\33'>(*(p)))) p--;
     *++p='\0';
}

void zeistr(char *s)
/* am Anfang und Ende werden Leer- und Steuerzeichen entfernt */
/* Kleinbuchstaben werden in Groszbuchstaben umgewandelt       */
{
  clr_end_str(s);
  clr_anf_str(s);
 /* strupr(s);
*/
}

/*********************************************************************/

#define buffsize 2048

void fcopy(FILE *v, FILE *n) {
    char buff[buffsize];
    while((fgets(buff,buffsize,v)) != NULL) fputs(buff,n);
}

/*********************************************************************/

void main(int argc,char *argv[]) {
    int argp    = 1;
    int errcode = DXF_ERR_noErr;
    
    printf("DXF 12 to YART 1.0 converter \n");
    if (argc!=3) {
	printf("usage: dxf2yrt infile(.dxf) outfile(.yrt)\n" );
    }
    else {
	DXF_fpIn = fopen( argv[argp], "rb" );
	if (!DXF_fpIn) {
	    printf( "\nCannot open input file %s", argv[argp] );
	    errcode = DXF_ERR_Param;
	}

	/* Input file is open, try to open output file. */
	else {
	    DXF_aktzeile = 0;
	    DXF_fpOut = fopen( argv[++argp], "wb" );

	    if (!DXF_fpOut) {
		printf( "\nCannot open output file %s", argv[argp] );
		errcode = DXF_ERR_Param;
	    }
	    else {
		// both files are ok
		
		fprintf(DXF_fpOut,"# This YART code is generated from DXF file %s.\n", argv[1] );
		fprintf(DXF_fpOut,"# The common father primitive is %s.\n", DXF_father);
		fprintf(DXF_fpOut,"Top %s\n", DXF_father );
		errcode = doit();
		
		/* ready */
		if (errcode==DXF_ERR_dxfeof) errcode=DXF_ERR_noErr;
		if (errcode!=DXF_ERR_noErr) {
		    printf("\nErrnr: %d  line %d\n",errcode,DXF_aktzeile);
		}
		else printf("Ready.\n");
		fclose(DXF_fpOut);
	    }
	    fclose(DXF_fpIn);
	}/* infile ok */
	
    }
    exit( errcode );
}

int doit() {
    char   name [ DXF_MAX_strlen+1];
    int errcode;

    DXF_Check_EOF = on;

    /*********************** ENTITIES suchen *********************/
    errcode = DXF_ERR_unexp_entry;
    while (errcode==DXF_ERR_unexp_entry) {
	errcode = find_gc0_name("SECTION");
	DXF_Check_ERR;
	errcode = check_next_entry(2,"ENTITIES");
    }
    DXF_Check_ERR;
    /* nun steht Zeiger auf ersten ENTITIES-Eintrag */

    /*** Innerhalb dieser Section alle (POLY-)LINEs und 3DFACEes aufspueren ***/
    DXF_Check_EOS = on;
    while (errcode==DXF_ERR_noErr) {
	errcode = find_gc(0,name);
	if (errcode==DXF_ERR_noErr) {
	    if (!strcmp(name,"LINE"		)) errcode = manag_LINE();
	    if (!strcmp(name,"3DLINE"	)) errcode = manag_LINE();
	    if (!strcmp(name,"3DFACE"	)) errcode = manag_3DFACE();
	    if (!strcmp(name,"POLYLINE")) errcode = manag_POLYLINE();
	}
    }
    if (errcode==DXF_ERR_dxfeos) {
	errcode=DXF_ERR_noErr;
	DXF_gc_w_in_buff = true;
    }
    DXF_Check_EOS = off;
    DXF_Check_ERR;
    /*********** SECTION fertig **********/

    return errcode;
}

int manag_LINE() {
    int	errcode = DXF_ERR_noErr;
    double 	  x,y,z,x1,y1,z1,x2,y2,z2;
    int		  gc;
    unsigned char p1ok = false;
    unsigned char p2ok = false;
    

    DXF_Check_GC0 = on;

    while(errcode==DXF_ERR_noErr) {
	errcode = get_point(&gc,&x,&y,&z);
	if (gc==10) { 
	    x1=x;
	    y1=y;
	    z1=z;
	    p1ok = true;
	}
	if (gc==11) {
	    x2=x;
	    y2=y;
	    z2=z;
	    p2ok = true;
	}
	if (p1ok && p2ok) {
	    fprintf(DXF_fpOut,
		    "Polyline l%lX_%s 2 {{%f %f %f} {%f %f %f}} {} {}\n",
		    DXF_hexname, DXF_akt_layer,x1,y1,z1,x2,y2,z2);
	    fprintf(DXF_fpOut,"l%lX_%s -father %s\n\n", DXF_hexname, DXF_akt_layer, DXF_father );
	    DXF_hexname++;
	    goto weiter;
	}
    }

  weiter:
    DXF_Check_GC0 = off;
    if ((errcode==DXF_ERR_dxfgc0)||(errcode==DXF_ERR_dxfsqe)||(errcode==DXF_ERR_dxfeos)||(errcode==DXF_ERR_dxfeof)) {
	errcode=DXF_ERR_noErr;
	DXF_gc_w_in_buff = true;
    }
    return errcode;
}

int manag_3DFACE() {
    int	errcode = DXF_ERR_noErr;
    RT_Vector  p,vp[4];
    int       gc;
    unsigned char p1ok = false;
    unsigned char p2ok = false;
    unsigned char p3ok = false;
    unsigned char p4ok = false;

    DXF_Check_GC0 = on;

    while(errcode==DXF_ERR_noErr) {
	errcode = get_point(&gc,&p.x,&p.y,&p.z);
	if (gc==10) {
	    vp[0]=p;
	    p1ok = true;
	}
	if (gc==11) {
	    vp[1]=p;
	    p2ok = true;
	}
	if (gc==12) {
	    vp[3]=p;
	    p3ok = true;
	}
	if (gc==13) {
	    vp[4]=p;
	    p4ok = true;
	}
	if (p1ok && p2ok && p3ok) {
	    if  (p4ok) {
		fprintf(DXF_fpOut,
			"Polygon pg%lX_%s 4 {{%f %f %f} {%f %f %f} {%f %f %f} {%f %f %f}} {} "
			,DXF_hexname,DXF_akt_layer,vp[0].x,vp[0].y,vp[0].z,vp[1].x,vp[1].y,vp[1].z,vp[2].x,vp[2].y,vp[2].z,vp[3].x,vp[3].y,vp[3].z);
		
		calcNorm(4,vp,&p);
	    }
	    else {
		fprintf(DXF_fpOut,
			"Polygon pg%lX_%s 3 {{%f %f %f} {%f %f %f} {%f %f %f}} {} ",
			DXF_hexname,DXF_akt_layer,vp[0].x,vp[0].y,vp[0].z,vp[1].x,vp[1].y,vp[1].z,vp[2].x,vp[2].y,vp[2].z);
		
		calcNorm(3,vp,&p);
	    }
	    fprintf(DXF_fpOut,"{%f %f %f}\n",p.x,p.y,p.z);
	    fprintf(DXF_fpOut,"pg%lX_%s -father %s\n\n", DXF_hexname, DXF_akt_layer, DXF_father );
	    
	    DXF_hexname++;
	    goto weiter;
	}
    }
    
  weiter:
    DXF_Check_GC0 = off;
    if ((errcode==DXF_ERR_dxfgc0)||(errcode==DXF_ERR_dxfsqe)||(errcode==DXF_ERR_dxfeos)||(errcode==DXF_ERR_dxfeof)) {
	errcode=DXF_ERR_noErr;
	DXF_gc_w_in_buff = true;
    }
    return errcode;
}

int manag_POLYLINE() {
    int	errcode = DXF_ERR_noErr;
    int		  gc;
    char 	  wert[DXF_MAX_strlen+1];
    long 	  w70 =0;
    long	  w71 =0;
    long	  w72 =0;
    long	  vertw70=0;
    RT_Vector	  *vert0,*vertp,*vertn1;
    long	  *flae0,*flaep;
    long	  i,j;
    unsigned long panz,fanz;
    unsigned long m,n,f,p;
    unsigned long int pkte,mpkte,npkte;
    RT_Vector	  vp[4];
    RT_Vector	  norm;
    long	  w_1;
    
    /* [1] Seite 295 ff
	( 8  = Layernummer    entsprechend Datei )
	    66 = 1 ( per Def. )   -->"Reihe von Vertex El. folgt, Abschlusz SEQEND"
		10 = 0 (   "      )
       20 = 0 (   "      )
		    30 = Erhebung
		      o:70 = Polylinien-Flags
			bitwert:
    !   =  1 : geschlossene Polylinie (in M-Richtung geschl. Netz )
	( 71,72 = 0, wenn nicht vorhanden, stimmt hier nicht )
	    =  2 :
    =  4 :
    =  8 :
    !   = 16 : Netz entsprechend Typ aus 75  (0=nicht angepaszt)
	= 32 : Netz in N-Richtung geschlossen
	    !   = 64 : PNetz (--> 71=#Punkte,72=#Flaechen)
			      =128 :
			      
			    o:40 = Anfangsbreite
			    o:41 = Endbreite
			    o:71 = #M-KP  (bzw. #Punkte)
			    o:72 = #N-KP  (bzw. #Flaechen)
			    o:73 = M-Dichte
			    o:74 = N-Dichte
			    o:75 = Typ von Kurven/geglaeteter Oberfl.
			      
			      o heiszt optional, wenn nicht vorhanden wird =0 angenommen
			      ( fuer 71 und 72 wahrscheinlich falsche Aussage )
			      
			      */

			      /* 1. festgeschr. Daten abfragen */

			      errcode = find_gc(66,wert);
			      DXF_Check_ERR;
			      if (1 != sscanf(wert,"%ld",&w_1)) return DXF_ERR_number_exp;
			      if (w_1!=1) return DXF_ERR_1_exp;
			      
			      /* manche Dateien hatten eine andere Reihenfolge der Werte,
			      und da sie sowieso irrelevant sind --> nicht beachten
			      
			      errcode = check_next_entryv(10,0);
			      DXF_Check_ERR;
			      errcode = check_next_entryv(20,0);
			      DXF_Check_ERR;
			      errcode = check_next_gc(30);
			      DXF_Check_ERR;
			      
			      */
			      
			      vert0=NULL;
			      flae0=NULL;
			      DXF_Check_SQE=on;
			      
			      /* restlichen Flags.. einsammeln bis 1. Vertex */
			      while(1)
			      {
				  errcode=read_gc_wert(&gc,wert);
				  if (errcode!=DXF_ERR_noErr) goto weiter;
				  switch (gc){
				    case  0: if ( !strcmp(wert,"VERTEX")) goto vertex;
					   case 70: if ( 1!=sscanf(wert,"%d",&w70 )) goto weiter;break;
					   case 71: if ( 1!=sscanf(wert,"%d",&w71 )) goto weiter;break;
					   case 72: if ( 1!=sscanf(wert,"%d",&w72 )) goto weiter;break;
					 }
			      }
			    vertex: DXF_gc_w_in_buff = true; /* Lesen von "VERTEX" brach Schleife ab */
			      
			      
			      /* Einsammeln & Auswerten der Punkte entsprechend den Flags/Werten */
			      if (w70<16) {

				  /******************** Beginn Linie *********************/
				  
				  panz=0;
				  if (!(vert0=vertp=(RT_Vector *)(calloc(DXF_MAX_vert+1,sizeof(double)*3))))
				      { errcode = DXF_ERR_malloc;
					goto weiter;
				    }
				  while (errcode==DXF_ERR_noErr)
	{
	      errcode = find_gc(0,wert);
	      if (errcode==DXF_ERR_noErr)
	      {
		if (!strcmp(wert,"VERTEX"	))
		{   errcode = get_vertex(&vertw70,&(vertp->x),&(vertp->y),&(vertp->z));
		    if (errcode==DXF_ERR_noErr)
		    {
		       /* Auswertung der Art des VERTEX */
		       if ((vertw70==0)||(vertw70&(64+32)))
		       {
			 if (panz<DXF_MAX_vert)
			 {  panz++;
			    vertp++;
			 }
		       }
		    }
		}
		if (panz>=DXF_MAX_vert) errcode=find_gc0_name("SEQEND");
	      }
	}

	vertp=vert0;
	if (panz>0)
	{ pkte=panz;
	  if (w70&1) pkte++; /* schlieszen */
	  fprintf(DXF_fpOut,"Polyline pl%lX_%s %li {",DXF_hexname,DXF_akt_layer,pkte);

	  for(i=0;i<panz;i++)
	  {
	     fprintf(DXF_fpOut," {%f %f %f}",vertp->x,vertp->y,vertp->z);
	     vertp++;
	  }
	  if (w70&1)
	  { /* Polyline schlieszen */
	    fprintf(DXF_fpOut," {%f %f %f}",vert0->x,vert0->y,vert0->z);
	  }
	  fprintf(DXF_fpOut," } {} {}\n");

	  fprintf(DXF_fpOut,"pl%lX_%s -father %s\n\n", DXF_hexname, DXF_akt_layer, DXF_father );

	  DXF_hexname++;
	}
	/******************** Ende Linie *********************/



    }
    else
    {   /* Netz */
      if (w70 & (16+32))
	{

	 /******************** Beginn MN-Netz ************************/

	 /* "normales" Netz bzw 3D-Netz (m*n Werte)
	   Schlieszung in M- od N-Richtung moeglich
	   Werte liegen folgendermaszen im Speicher:
	      * Feld von m*n Stuetzpunkten
	      * gelesene Werte werden erst in n-Richtung eingetragen
	 */

	 panz=0;
	 if (2>(m=w71)) goto weiter;
	 if (2>(n=w72)) goto weiter;

	 if (!(vert0=vertp=(RT_Vector *)(calloc(m*n+1,sizeof(double)*3)))) {
	     errcode = DXF_ERR_malloc;
	     goto weiter;
	 }
	 while (errcode==DXF_ERR_noErr) {
	      errcode = find_gc(0,wert);
	      if (errcode==DXF_ERR_noErr)
	      {
		if (!strcmp(wert,"VERTEX"	))
		{   errcode = get_vertex(&vertw70,&(vertp->x),&(vertp->y),&(vertp->z));
		    if (errcode==DXF_ERR_noErr)
		    {
		       /* Auswertung der Art des VERTEX */
		       if ((vertw70==0)||(vertw70&(64)))
		       {
			 if (panz<m*n)
			 {  panz++;
			    vertp++;
			 }
		       }
		    }
		}
		if (panz>=m*n) errcode=find_gc0_name("SEQEND");
	      }
	 }

	 if (m*n>panz)
	 {
	     fprintf(DXF_fpOut,"\n#zuwenig passende Punkte fuer das Netz\n\n");
	 }

	 else
	 {
	   mpkte=m; if (w70&1 ) mpkte++;
	   npkte=n; if (w70&32) npkte++;
	   fprintf(DXF_fpOut,"Quadmesh qm%lX_%s %lu %lu {",DXF_hexname,DXF_akt_layer,npkte,mpkte);
	   vertp=vert0;

	   for (i=0;i<m;i++)
	   {
	     vertn1=vertp;
	     for (j=0;j<n;j++)
	     {
	       fprintf(DXF_fpOut," {%f %f %f}",vertp->x,vertp->y,vertp->z);
	       vertp++;
	     }
	     if (w70&32) /* in N-Richtung schlieszen */
	     {
	       fprintf(DXF_fpOut," {%f %f %f}",vertn1->x,vertn1->y,vertn1->z);
	     }
	   }
	   if (w70&1) /* in M-Richtung schlieszen */
	   {
	     vertp =vert0;
	     for (j=0;j<n;j++)
	     {
	       fprintf(DXF_fpOut," {%f %f %f}",vertp->x,vertp->y,vertp->z);
	       vertp++;
	     }
	     if (w70&32) /* in N-Richtung schlieszen */
	     {
	       fprintf(DXF_fpOut," {%f %f %f}",vert0->x,vert0->y,vert0->z);
	     }
	   }

	   fprintf(DXF_fpOut," } {} {");


	   /* Normalen-Berechnung */
	   /*    3   2            */
	   /*                     */
	   /*	 0   1            */

	   vertp=vert0;

	   for (i=1;i<m;i++)
	   {
	     vertn1=vertp;
	     for (j=1;j<n;j++)
	     {
	       vp[1]=vertp[n  ];
	       vp[2]=vertp[n+1];
	       vp[3]=vertp[  1];
	       vp[0]=*(vertp++);

	       calcNorm(4,vp,&norm);

	       fprintf(DXF_fpOut," {%f %f %f}",norm.x,norm.y,norm.z);
	     }
	     if (w70&32) /* in N-Richtung schlieszen */
	     {
	       vp[1]=vertp[n];
	       vp[2]=vertn1[n];
	       vp[3]=*vertn1;
	       vp[0]=*(vertp++);

	       calcNorm(4,vp,&norm);

	       fprintf(DXF_fpOut," {%f %f %f}",norm.x,norm.y,norm.z);
	     }
	     else vertp++;
	   }
	   if (w70&1) /* in M-Richtung schlieszen */
	   {
	     vertn1=vertp;
	     for (j=1;j<n;j++)
	     {
	       vp[1]=vert0[j-1];
	       vp[2]=vert0[j  ];
	       vp[3]=vertp[  1];
	       vp[0]=*(vertp++);

	       calcNorm(4,vp,&norm);

	       fprintf(DXF_fpOut," {%f %f %f}",norm.x,norm.y,norm.z);
	     }
	     if (w70&32) /* in N-Richtung schlieszen */
	     {
	       vp[1]=vert0[n-1];
	       vp[2]=*vert0;
	       vp[3]=*vertn1;
	       vp[0]=*(vertp);

	       calcNorm(4,vp,&norm);

	       fprintf(DXF_fpOut," {%f %f %f}",norm.x,norm.y,norm.z);
	     }
	   }

	   fprintf(DXF_fpOut," }\n");

	   fprintf(DXF_fpOut,"qm%lX_%s -father %s\n\n", DXF_hexname, DXF_akt_layer, DXF_father );

	   DXF_hexname++;
	 } /* Abspeichern */

	/******************** Ende MN-Netz ************************/
	}

      else { if  (w70 & 64)
	{




	 /******************** Beginn Vielflaechen-Netz *******************/

	 /* Netz fuer das Kontrollpunkte (Kennung==128) und Flaechenangaben
	    erfolgen
	    Werte liegen folgendermaszen in der Datei:
	      * w71 Stuetzpunkte                 ( Flagbitwert 64 gesetzt      )
	      * w72 Flaechenbeschreibungs-Punkte (                nicht gesetzt)
	      * [1] 296f empfiehlt gemischtes Lesen zuzulassen
	      * Anzahl der Flaechenbeschreibungspunkte ist auf 4 begrenzt
		[-1] 296
	      * Flaechenbeschreibungs-Punkt ist negativ --> Kante unsichtbar
	      *                             ist 0       --> Flaeche fertig
	 */

	 unsigned char fertig;
	 long	  vertw71,vertw72,vertw73,vertw74,p1;
	 long	  vertmax=0;
	 panz=0;
	 fanz=0;

	 if (1>(p=w71)) goto weiter;
	 if (1>(f=w72)) goto weiter;

	 if (!(vert0=vertp=(RT_Vector *)(calloc(p+1,sizeof(double)*3))))
	 /* p+1, da in get_vv_vertex Init. erfogt, wobei nach Fllen des
	    Vertexfeldes Speicher hinter dem Feld initialisiert werden wrde
	    (z.B. das Flchenfeld)
	 */
	 { errcode = DXF_ERR_malloc;
	   goto weiter;
	 }
	 if (!(flae0=flaep=(long *)(calloc(f,sizeof(long)*4))))
	 { errcode = DXF_ERR_malloc;
	   goto weiter;
	 }
	 while (errcode==DXF_ERR_noErr)
	 {
	      errcode = find_gc(0,wert);
	      if (errcode==DXF_ERR_noErr)
	      {
		if (!strcmp(wert,"VERTEX"	))
		{   errcode = get_vv_vertex(&vertw70,&vertw71,&vertw72,&vertw73,&vertw74,&(vertp->x),&(vertp->y),&(vertp->z));
		    if (errcode==DXF_ERR_noErr)
		    {
		       /* Auswertung der Art des VERTEX */
		       if (vertw70 & 128)
		       { /* ok, da VV-Netz-KP */
			 if ((vertw70 & 64))
			 { /* Stuetzpunkt */
			   if (panz<p)
			   {
			     panz++;
			     vertp++;
			   }
			 }
			 else
			 { /* Flaeche */
			   if (fanz<f)
			   {
			     fanz++;
			     /* Unsichtbarkeitsinfo ignorieren */
			     vertw71=abs(vertw71);
			     vertw72=abs(vertw72);
			     vertw73=abs(vertw73);
			     vertw74=abs(vertw74);

			     *(flaep++)=vertw71;
			     if (vertmax<vertw71) vertmax=vertw71;
			     *(flaep++)=vertw72;
			     if (vertmax<vertw72) vertmax=vertw72;
			     *(flaep++)=vertw73;
			     if (vertmax<vertw73) vertmax=vertw73;
			     *(flaep++)=vertw74;
			     if (vertmax<vertw74) vertmax=vertw74;
			   }
			 }
		       }
		    }
		}
		if ((fanz>=f)&&(panz>=p)) errcode=find_gc0_name("SEQEND");
	      }
	 }

	 if (vertmax>panz)
	 {
	     fprintf(DXF_fpOut,"\n#zuwenig passende Stuetzpunkte fuer das Polyhedron\n\n");
	     goto weiter;
	 }
	 if (fanz==0) goto weiter;


	   fprintf(DXF_fpOut,"Polyhedron ph%lX_%s %lu %lu {",DXF_hexname,DXF_akt_layer,fanz,panz);

	   /* Flaechen */
	   flaep=flae0;
	   for (i=0;i<fanz;i++)
	   {
	     fprintf(DXF_fpOut," {");
	     fertig=false;
	     for (j=0;j<4;j++)
	     {
	       p1=*(flaep++);
	       if (p1==0) fertig=true;
	       if (!fertig) fprintf(DXF_fpOut," %lu",p1-1);
	     }
	     fprintf(DXF_fpOut," }");
	   }

	   /* Punkte */
	   fprintf(DXF_fpOut," } {");

	   vertp=vert0;
	   for(i=0;i<panz;i++)
	   {
	     fprintf(DXF_fpOut," {%f %f %f}",vertp->x,vertp->y,vertp->z);
	     vertp++;
	   }
	   fprintf(DXF_fpOut," } {} {");



	   /* Normalen */
	   flaep=flae0;
	   for (i=0;i<fanz;i++)
	   {
	     fertig=false;
	     pkte=0;
	     for (j=0;j<4;j++)
	     {
	       p1=*(flaep++);
	       vp[j]=vert0[p1-1];
	       if (p1==0) fertig=true;
	       if (!fertig) pkte++;
	     }
	     calcNorm(pkte,vp,&norm);

	     fprintf(DXF_fpOut," {%f %f %f}",norm.x,norm.y,norm.z);
	   }


	   fprintf(DXF_fpOut," }\n");

	   fprintf(DXF_fpOut,"ph%lX_%s -father %s\n\n", DXF_hexname, DXF_akt_layer, DXF_father);

	   DXF_hexname++;


	 /******************** Ende Vielflaechen-Netz ************************/
	}}
    } /* Ende else Netze */

weiter:
    free(vert0);
    free(flae0);
    DXF_Check_SQE = off;
    if (errcode==DXF_ERR_dxfsqe)
    {   errcode=DXF_ERR_noErr;
	DXF_gc_w_in_buff = true;
    }

    return errcode;
}

int get_point( int *gc ,double *x, double *y, double *z )
{
    char w[DXF_MAX_strlen+1];
    int hgc=0;
    int	errcode = DXF_ERR_noErr;

    /* suche gc=10..19, wenn gefunden, dann +10, +20 */
    while ((hgc<10)||(hgc>19))
    {
	errcode=read_gc_wert(&hgc,w);
	DXF_Check_ERR;
    }
    if (1 != sscanf(w,"%lf",x)) return DXF_ERR_double_exp;
    *gc=hgc;

    errcode=read_gc_wert(&hgc,w);
    DXF_Check_ERR;
    if (hgc!=(*gc+10)) 			return DXF_ERR_y_exp;
    if (1 != sscanf(w,"%lf",y))    return DXF_ERR_double_exp;

    *z=0;
    errcode=read_gc_wert(&hgc,w);
    DXF_Check_ERR;
    if (hgc!=(*gc+20))
    {
	DXF_gc_w_in_buff=true; /* optionale z-Koord. kam nicht, Eintrag hat andere Bedeutung */
	return errcode;
    }
    if (1 != sscanf(w,"%lf",z))    return DXF_ERR_double_exp;


    return errcode;

}

int get_vertex(long *w70,double *x,double *y,double *z)
{
    char wert[DXF_MAX_strlen+1];
    int gc=0;
    int	errcode = DXF_ERR_noErr;


    DXF_Check_GC0 = on;
    *w70=*x=*y=*z=0;

    do
    {
      switch (gc){
	case 70: if ( 1!=sscanf(wert,"%d" ,w70)) goto weiter;break;
	case 10: if ( 1!=sscanf(wert,"%lf",x  )) goto weiter;break;
	case 20: if ( 1!=sscanf(wert,"%lf",y  )) goto weiter;break;
	case 30: if ( 1!=sscanf(wert,"%lf",z  )) goto weiter;break;
	}
      errcode=read_gc_wert(&gc,wert);
    } while (errcode==DXF_ERR_noErr);

weiter:
    DXF_Check_GC0 = off;
    if ((errcode==DXF_ERR_dxfgc0)||(errcode==DXF_ERR_dxfsqe)||(errcode==DXF_ERR_dxfeos)||(errcode==DXF_ERR_dxfeof))
    {   errcode=DXF_ERR_noErr;
	DXF_gc_w_in_buff = true;
    }


    return errcode;

}
int get_vv_vertex(long *w70,long *w71,long *w72,long *w73,long *w74,double *x,double *y,double *z)
{
    char wert[DXF_MAX_strlen+1];
    int gc=0;
    int	errcode = DXF_ERR_noErr;


    DXF_Check_GC0 = on;
    *w70=*w71=*w72=*w73=*w74=*x=*y=*z=0;

    do
    {
      switch (gc){
	case 70: if ( 1!=sscanf(wert,"%d" ,w70)) goto weiter;break;
	case 71: if ( 1!=sscanf(wert,"%d" ,w71)) goto weiter;break;
	case 72: if ( 1!=sscanf(wert,"%d" ,w72)) goto weiter;break;
	case 73: if ( 1!=sscanf(wert,"%d" ,w73)) goto weiter;break;
	case 74: if ( 1!=sscanf(wert,"%d" ,w74)) goto weiter;break;
	case 10: if ( 1!=sscanf(wert,"%lf",x  )) goto weiter;break;
	case 20: if ( 1!=sscanf(wert,"%lf",y  )) goto weiter;break;
	case 30: if ( 1!=sscanf(wert,"%lf",z  )) goto weiter;break;
	}
      errcode=read_gc_wert(&gc,wert);
    } while (errcode==DXF_ERR_noErr);

weiter:
    DXF_Check_GC0 = off;
    if ((errcode==DXF_ERR_dxfgc0)||(errcode==DXF_ERR_dxfsqe)||(errcode==DXF_ERR_dxfeos)||(errcode==DXF_ERR_dxfeof))
    {   errcode=DXF_ERR_noErr;
	DXF_gc_w_in_buff = true;
    }


    return errcode;

}

int find_gc(int gc, char *namestr)
{
    int 	errcode = DXF_ERR_noErr;
    int 	rgc;

    while(1)
    {
       errcode=read_gc_wert(&rgc,namestr);
       if (errcode!=DXF_ERR_noErr)
	  return errcode;
       else
       {
	  if (gc==rgc) return DXF_ERR_noErr;
       }
    }

}
int find_gc0_name( char *namestr)
{
    int 	errcode = DXF_ERR_noErr;
    int 	gc;
    char        wert     [DXF_MAX_strlen+1];

    while(1)
    {
       errcode=read_gc_wert(&gc,wert);
       if (errcode!=DXF_ERR_noErr)
	  return errcode;
       else
       {
	  if ((!gc)&&(!strcmp(wert,namestr))) return DXF_ERR_noErr;
       }
    }

}

int check_next_gc( int gc )
{
    int  errcode = DXF_ERR_noErr;
    int  rgc;
    char rwert[DXF_MAX_strlen+1];

    errcode = read_gc_wert(&rgc,rwert);
    DXF_Check_ERR;
    if (gc==rgc) return errcode;
    return DXF_ERR_unexp_gc;
}

int check_next_entry( int gc, char *wertstr)
{
    int  errcode = DXF_ERR_noErr;
    int  rgc;
    char rwert[DXF_MAX_strlen+1];

    errcode = read_gc_wert(&rgc,rwert);
    DXF_Check_ERR;
    if ((gc==rgc)&&(!strcmp(wertstr,rwert))) return errcode;
    return DXF_ERR_unexp_entry;
}

int check_next_entryv( int gc, double w)
{
    int  errcode = DXF_ERR_noErr;
    int  rgc;
    char rwert[DXF_MAX_strlen+1];
    double rw;

    errcode = read_gc_wert(&rgc,rwert);
    DXF_Check_ERR;
    if (1 != sscanf(rwert,"%lf",&rw)) return DXF_ERR_number_exp;

    if ((gc==rgc)&&(w==rw)) return errcode;
    return DXF_ERR_unexp_entry;
}


int read_gc_wert( int *gc ,char *wertstr)
{
    int errcode 	= DXF_ERR_noErr;
    char gstring	  [DXF_MAX_strlen+1];

    if (DXF_gc_w_in_buff)
       { *gc      = DXF_buff_gc;
	 strcpy(wertstr,DXF_buff_wertstr);
	 goto read_checks;
       }

newread:
    errcode = DXF_ERR_noErr;
    DXF_aktzeile++;

    if (fgets(gstring,DXF_MAX_strlen+1,DXF_fpIn))
       {
       if (1 == sscanf(gstring,"%d",gc))
	  {
	  /* gc ok */
	  DXF_aktzeile++;
	  if (fgets(wertstr,DXF_MAX_strlen+1,DXF_fpIn))
	     {
	     /* Anfangs- & Endeleerzeichen sowie Steuerzeichen weg */
	     /* alle Buchstaben grosz */
	     zeistr(wertstr);


	     /* REM-Ueberspringen */
read_checks :if ((DXF_Skip_REM)&&(*gc==999)) goto newread;

	     /* Pruefungen entsprechend Prioritaeten */
	     /* alles ok, nun ( Gruppencode == 0 )-Pruefung */
	     if (DXF_Check_GC0 && (*gc==0) )
	       errcode=DXF_ERR_dxfgc0;

	     /*           nun Fileendekennungs-Pruefung     */
	     if (DXF_Check_EOF && (*gc==0) && (!strcmp(wertstr,"EOF")))
	       errcode=DXF_ERR_dxfeof;

	     /*           nun Segmentsendekennungs-Pruefung */
	     if (DXF_Check_EOS && (*gc==0) && (!strcmp(wertstr,"ENDSEC")))
	       errcode=DXF_ERR_dxfeos;

	     /*           nun SEQEND-Pruefung               */
	     if (DXF_Check_SQE && (*gc==0) && (!strcmp(wertstr,"SEQEND")))
	       errcode=DXF_ERR_dxfsqe;

	     DXF_buff_gc       = *gc;
	     strcpy(DXF_buff_wertstr,wertstr);

	     }
	  else /* Fehler oder Dateiende erreicht */
	     errcode=DXF_ERR_fread;
	  }
       else /* kein Integer (fehlerhafter Gruppencode) */
	  errcode=DXF_ERR_nogc;
       }
    else /* Fehler oder Dateiende erreicht */
       errcode=DXF_ERR_fread;

    DXF_gc_w_in_buff = false;
    if (*gc==8) strcpy(DXF_akt_layer,DXF_buff_wertstr);
    return errcode;

}

float max(float a,float b) {
    if (a>b) return a;
    else     return b;
}

void calcNorm( int n, RT_Vector *points, RT_Vector *norm ) {
    double xu, yu, zu, ru, xv, yv, zv, rv, xn, yn, zn, rn;
    double deltax, deltay, deltaz;
    int arete, aretex, aremix, aremiy, aremiz;
    RT_Vector pta, ptb, ptc;
    float xmin, xmax, ymin, ymax, zmin, zmax;
    int i;

    xmin = ymin = zmin = 99999. ;
    xmax = ymax = zmax = -99999. ;
    for ( i = 0; i < n; i++ ) {
	if ( points[i].x < xmin ) {
	    aremix = i;
	    xmin = points[i].x;
	}
	if ( points[i].y < ymin ) {
	    aremiy = i;
	    ymin = points[i].y;
	}
	if ( points[i].z < zmin ) {
	    aremiz = i;
	    zmin = points[i].z;
	}
	xmax = max( (float)points[i].x,xmax );
	ymax = max( (float)points[i].y,ymax );
	zmax = max( (float)points[i].z,zmax );
    }

    deltax = xmax - xmin;
    deltay = ymax - ymin;
    deltaz = zmax - zmin;
    if ( deltax >= deltay && deltay >= deltaz ) aretex = aremix;
    else if ( deltax >= deltaz && deltaz >= deltay ) aretex = aremix;
    else if ( deltay >= deltax && deltax >= deltaz ) aretex = aremiy;
    else if ( deltay >= deltaz && deltaz >= deltax ) aretex = aremiy;
    else if ( deltaz >= deltax && deltax >= deltay ) aretex = aremiz;
    else if ( deltaz >= deltay && deltay >= deltax ) aretex = aremiz;
    pta = points[aretex];
    arete = aretex + 1;
    if (arete >= n) arete = 0;
    ptb = points[arete];

    xu = ptb.x - pta.x; yu = ptb.y - pta.y; zu = ptb.z - pta.z;
    ru = sqrt( xu*xu + yu*yu + zu*zu );
    if (fabs( ru) > RayEps) {xu /= ru; yu /= ru; zu/= ru; }
    do {
	arete++; if ( arete >= n ) arete = 0;
	ptc = points[arete];
	xv = ptc.x - ptb.x;
	yv = ptc.y - ptb.y;
	zv = ptc.z - ptb.z;
	rv = sqrt(xv*xv + yv*yv + zv*zv);
	if (fabs( rv) > RayEps) { xv /= rv; yv /= rv; zv/= rv; }
	xn = yu*zv - zu*yv;
	yn = zu*xv - xu*zv;
	zn = xu*yv - yu*xv;
	rn = sqrt(xn*xn + yn*yn + zn*zn);
	if (fabs( rn) > RayEps) { xn /= rn; yn /= rn; zn/= rn;}
    }
    while ( rn < 0.01 && (xu*xv + yu*yv + zu*zv) > 0.);

    norm[0].x = xn;
    norm[0].y = yn;
    norm[0].z = zn;




}
