////////////////////////////////////////////////////////////////////////////////
// Noise functions etc. for textures                                          //  
// LAST EDIT: Tue Aug 16 10:23:44 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "texture.h"

int ***RT_Texture3D::noiseTable;

RT_Matrix RT_Texture3D::matV;
int RT_Texture3D::matF, RT_Texture3D::matG;

RT_ParseEntry RT_Texture3D::table[] = {
    { "-matrix", RTP_MATRIX, (char*)&matV, &matF, "Overload the modelling {ARG 1 Matrix} of the texture.", RTPS_MATRIX },
    { "-get_matrix", RTP_NONE, 0, &matG, "Return the modeling matrix of the texture.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

void RT_Texture3D::initNoise() {
    noiseTable = new int**[ RTD_MAXNOISE ];
    assert( noiseTable );

    for( int x = 0; x < RTD_MAXNOISE; x++ ) {
	noiseTable[x] = new int*[ RTD_MAXNOISE ];
	assert( noiseTable[x] );
    }
    for( x = 0; x < RTD_MAXNOISE; x++ ) {
	for( int y = 0; y < RTD_MAXNOISE; y++ ) {
	    noiseTable[x][y] = new int[ RTD_MAXNOISE ];
	    assert( noiseTable[x][y] );
	}
    }
    
    srand(1);
    int xx,yy,zz;
    for( x = 0; x < RTD_MAXNOISE; x++ )
	for( int y = 0; y < RTD_MAXNOISE; y++ )
   	    for( int z = 0; z < RTD_MAXNOISE; z++ ) {
		noiseTable[x][y][z] = rand() % 10000;
		xx = (x == (RTD_MAXNOISE-1)) ? 0 : x;
		yy = (y == (RTD_MAXNOISE-1)) ? 0 : y;
		zz = (z == (RTD_MAXNOISE-1)) ? 0 : z;
		noiseTable[x][y][z] = noiseTable[xx][yy][zz];
	    }
}

double frac( double r ) {
    r -= (int)r; 
    return (r<0) ? r+1 : r;
}

double RT_Texture3D::getNoise( const RT_Vector &p ) const {
    int nx, ny, nz;                  // pointers to noiseTable
    double n0, n1, n00, n01, n10, n11;  // dummies for interpolation
    int n;
    double a, b, c;

    a = frac(p.x) * (RTD_MAXNOISE - 1); 
    b = frac(p.y) * (RTD_MAXNOISE - 1); 
    c = frac(p.z) * (RTD_MAXNOISE - 1); 

    nx = (int)a;
    ny = (int)b;
    nz = (int)c;

    a = frac(a);
    b = frac(b);
    c = frac(c);
    
    a = a*a*(3-2*a);
    b = b*b*(3-2*b);
    c = c*c*(3-2*c);

    n   = noiseTable[nx][ny][nz];
    n00 = n + a * ( noiseTable[nx+1][ny][nz] - n );
    n   = noiseTable[nx][ny][nz+1];
    n01 = n + a * ( noiseTable[nx+1][ny][nz+1] - n );
    n   = noiseTable[nx][ny+1][nz];
    n10 = n + a * ( noiseTable[nx+1][ny+1][nz] - n );
    n   = noiseTable[nx][ny+1][nz+1];
    n11 = n + a * ( noiseTable[nx+1][ny+1][nz+1] - n );
    
    n0  = n00 + b * ( n10 - n00 );
    n1  = n01 + b * ( n11 - n01 );
    
    return (n0 + c * ( n1 - n0 ) ) / 10000;
}

RT_Color RT_Texture3D::getRGBNoise( const RT_Vector &p, double range ) const {
    double n = range * ( 1 - 2*getNoise(p) );  
    return RT_Color( n, n, n );
}

double RT_Texture3D::getTurbulence( const RT_Vector &p, int iter ) const {
    int i;
    double pow = 2;
    double sum = 0;
    
    for (i=0; i<iter; i++, pow *= 2)
	sum += fabs( getNoise( p * pow ) ) / pow;
    return sum;
}

int RT_Texture3D::objectCMD(char *argv[]) {
    RT_parseTable( argv, table );
    if (matF) matrix( matV );
    if (matG) {
	char tmp[360];
	RT_matrix2string( get_matrix(), tmp );
	RT_Object::result( tmp );
    }
    return matF + matG;
}
