////////////////////////////////////////////////////////////////////////////////
//  A simple shell for interactive editing of YART objects or for executing   //  
//  of YART files.                                                            //  
//  LAST EDIT: Tue Mar  7 19:35:12 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

int fileF;
char *fileV;

RT_ParseEntry ParameterTable[] = {
    { "-file", RTP_STRING, (char*)&fileV, &fileF, "Specify a {ARG 1 File} for loading.", RTPS_FILE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

#ifndef RTM_init

#define RTM_init() \
if ( RT_init() != TCL_OK) {\
    fprintf(stderr, "Initialization failed: %s\n", rt_Ip->result);\
	exit( 1 );\
	}

#endif

int main(int, char *argv[]) {
    RTM_init();
    
    RT_parseTable( argv, ParameterTable );

    if (fileF && (Tcl_EvalFile ( rt_Ip, fileV ) == TCL_ERROR )) {
	rt_Output->errorVar( "Load Error! ", rt_Ip->result, 0 );
	exit( 1 );
    }

    RT_FileDevice *console = (RT_FileDevice *)RT_Object::getObject( "console" );
    if (!console) console = new RT_FileDevice( "console", 0, 1 ); 
    console->addCB( new RT_ConsoleInputCB );
    
    rt_InputServer->loop();
}


