////////////////////////////////////////////////////////////////////////////////
//  Implementation of Manipulator.                                            //  
//  LAST EDIT: Thu Feb  9 15:55:40 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "mdevice.h"
#include "../camera.h"
#include "../predattr.h"

const char *RTN_MANIPULATOR = "Manipulator";

int RT_Manipulator::modeF, RT_Manipulator::modeV, RT_Manipulator::modeG;
int RT_Manipulator::boxF, RT_Manipulator::boxV, RT_Manipulator::boxG;
int RT_Manipulator::axisF, RT_Manipulator::axisG, RT_Manipulator::axisV;
int RT_Manipulator::drawStyleF, RT_Manipulator::drawStyleG, RT_Manipulator::drawStyleV;
int RT_Manipulator::transV, RT_Manipulator::transF, RT_Manipulator::transG;
int RT_Manipulator::rayF, RT_Manipulator::resetMatrixF;
int RT_Manipulator::autoUpdateF, RT_Manipulator::autoUpdateV, RT_Manipulator::autoUpdateG;
int RT_Manipulator::curObjF, RT_Manipulator::curObjG;
int RT_Manipulator::sensF, RT_Manipulator::sensG;
double RT_Manipulator::sensV;
char *RT_Manipulator::curObjV;
int RT_Manipulator::mtF, RT_Manipulator::mtG;
RT_Matrix RT_Manipulator::mtV;

RT_ParseEntry RT_Manipulator::table[] = {
    { "-mode", RTP_INTEGER, (char *) &modeV, &modeF, "Set a {ARG 1 Manipulatormode}. The values are {ENUM 1 \"Object Cursor Camera\"}", RTPS_INTEGER },
    { "-get_mode", RTP_NONE, 0, &modeG, "Get the current mode of the manipualtor.", RTPS_NONE },

    { "-box", RTP_INTEGER, (char *) &boxV, &boxF, "Set the {ARG 1 Boxmode}. The values are {ENUM 1 \"None Object Hierarchy Solid SolidHierarchy\"}.", RTPS_INTEGER },
    { "-get_box", RTP_NONE, 0, &boxG, "Get the current boxmode of the manipulator.", RTPS_NONE },

    { "-transformation", RTP_INTEGER,(char *) &transV, &transF, "Set the {ARG 1 Transformationtype}. The values are {ENUM 1 \"Scale Rotate Translate RotAndTrans\"}.", RTPS_INTEGER },
    { "-get_transformation", RTP_NONE, 0, &transG, "Get the current transformation mode of the manipualtor.", RTPS_NONE },

    { "-axis", RTP_INTEGER, (char *) &axisV, &axisF, "Set the {ARG 1 Axis} of the manipulator. The values are {ENUM 1 \"zero x y xy z  xz yz xyz\" }.", RTPS_INTEGER },
    { "-get_axis", RTP_NONE, 0, &axisG, "Get the current axis of the manipulator.", RTPS_NONE },

    { "-drawStyle", RTP_INTEGER, (char *) &drawStyleV, &drawStyleF, "Set the {ARG 1 Drawstyle} of the current Object. The values are {ENUM 1 \"Solid Wire Invisible\"}.", RTPS_INTEGER },
    { "-get_drawStyle", RTP_NONE, 0, &drawStyleG, "Get the drawStyle of the current object.", RTPS_NONE },

    { "-sensibility", RTP_DOUBLE,(char *) &sensV, &sensF, "Set the {ARG 1 Sensibility} of the manipulator. The default value is 1.0.", RTPS_DOUBLE },
    { "-get_sensibility", RTP_NONE, 0, &sensG, "Get the current sensibility of the manipualtor.", RTPS_NONE },

    { "-raytrace", RTP_NONE,0,&rayF,"Call the rendering method of the current camera in ray-tracing mode, to update the camera view.",RTPS_NONE },

    { "-resetMatrix", RTP_NONE,0,&resetMatrixF,"Set the matrix of the current object to the identity matrix.",RTPS_NONE },

    { "-autoUpdate", RTP_INTEGER, (char *) &autoUpdateV, &autoUpdateF, "Set the {ARG 1 Autoupdatemode} of the manipulator. The values are {ENUM 1 \"Off On\" }.", RTPS_INTEGER },
    { "-get_autoUpdate", RTP_NONE, 0, &autoUpdateG, "Get the current auto update mode of the manipualtor.", RTPS_NONE },

    { "-matrix", RTP_MATRIX, (char*)&mtV, &mtF, "Set the modelling {ARG 1 Matrix} for the cursor object.", RTPS_MATRIX },
    { "-get_matrix", RTP_NONE, 0, &mtG, "Return the modelling matrix of the cursor.", RTPS_NONE },

    { "-currentObject", RTP_STRING, (char *) &curObjV, &curObjF, "Set the current object to the  {ARG 1 Primitive}.", RTPS_STRING },
    { "-get_currentObject", RTP_NONE, 0, &curObjG, "Get the current object from manipulator.", RTPS_NONE },

    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_Manipulator::objectCMD(char *argv[]) { 
    int ret = RT_InputDevice::objectCMD( argv );

    RT_parseTable( argv, table );
    static char resultString[30];

    if (rayF) { raytrace(); ret++; }

    if (resetMatrixF) { resetMatrix(); ret++; }

    if (autoUpdateF) { autoUpdate(autoUpdateV); ret++; }

    if (autoUpdateG ) {
	RT_int2string(xautoUpdate,resultString);
	RT_Object::result( resultString ); ret++;
    }

    if (modeF) { 
	if ( modeV >= RTE_OBJECT_MODE && modeV <= RTE_CAMERA_MODE ) {
	    mode((RT_ManipulatorMode) modeV) ;	
	    ret++;
	}
	else rt_Output->errorVar(get_name(), ": Bad manipulator mode.", 0 );
    }
    if (modeG) {
	RT_int2string( get_mode(), resultString);
	RT_Object::result( resultString ); 
	ret++;
    }

    if (sensF) { sensibility(sensV); ret++;}

    if (sensG ) {
	RT_double2string(get_sensibility(),resultString);
	RT_Object::result( resultString ); 
	ret++;
    }

    if (boxF) { 
	if ( boxV >= RTE_NO_BOX && boxV <= RTE_FILLED_HIERARCHICAL_BOX ) {
	    box( (RT_BoxMode)boxV ) ;
	    ret++;
	}
	else rt_Output->errorVar( get_name(), ": Bad box mode.", 0 );
    }
    if (boxG ) {
	RT_int2string( get_box(),resultString );
	RT_Object::result( resultString ); 
	ret++;
    }

    if (axisF) {
	if (axisV >= RTE_NO_AXIS && axisV <= RTE_XYZ_AXIS ) {
	    axis((RT_ManipulatorAxis)axisV);
	    ret++;
	}
	else rt_Output->errorVar( get_name(), ": Bad axis mode.", 0 );
    }	    
    if (axisG ) {
	RT_int2string(get_axis(),resultString);
	RT_Object::result( resultString ); 
	ret++;
    }

    if (transF) {
	if (transV >= RTE_SCALE && transV <= RTE_ROT_TRANS) {
	    transformation((RT_ManipulatorXform)transV );
	    ret++;
	}
	else rt_Output->errorVar(get_name(), ": Bad mode for transformation.", 0 );
    }
    if (transG ) {
	RT_int2string(xtransformation,resultString);
	RT_Object::result( resultString ); 
	ret++;
    }

    if (mtF) { matrix( mtV ); ret++; }

    if (mtG) {
	static char tmp[360];
	RT_matrix2string( get_matrix(), tmp );
	RT_Object::result( tmp );
	ret++;
    }

    if (curObjF) {
	if (!strcmp( curObjV, "" )) { currentObject( 0 ); ret++; }
	else {
	    RT_Object *obj = RT_Object::getObject( curObjV );
	    if (!obj || !(obj->isA( RTN_PRIMITIVE ))) 
		rt_Output->errorVar( get_name(), ": No such primitive: ", curObjV, "!", 0 );
	    else { currentObject( (RT_Primitive*)obj ); ret++; }
	}
    }

    if (curObjG) {
	RT_Object::result( get_currentObject() ?  get_currentObject()->get_name() : "" );
	ret++;
    }

    if (drawStyleF) {
	if (drawStyleV >= RTE_SOLID && drawStyleV <= RTE_INVISIBLE ) {
	    drawStyle((RT_ManipulatorStyle) drawStyleV);
	    ret++;
	}
	else rt_Output->error("Bad value for drawStyle.");
    }	    

    if (drawStyleG ) {
	RT_int2string(xdrawStyle,resultString);
	RT_Object::result( resultString ); 
	ret++;
    }

    return ret;
}

int RT_Manipulator::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a {ARG 1 Manipulator} object. The Manipulator device has to be coupled to a camera object.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 2) {
	    Tcl_AppendResult( ip, argv[0], ": Need exactly one argument.", 0 );
	    return TCL_ERROR;
	}
	new RT_Manipulator( argv[1] ); 
	RTM_classReturn;
    }
    return res; 
}

void RT_Manipulator::father(RT_Object *o) {
    // remove feedback from old camera:
    RT_Object *f = get_father();
    if ( f && f->isA( RTN_CAMERA )) {
	((RT_Camera*)f)->feedback->remove( xcursor );
	((RT_Camera*)f)->refresh();
    }
    
    RT_InputDevice::father( o );

    // set feedback to new camera:
    f = get_father();
    if ( f && f->isA( RTN_CAMERA )) ((RT_Camera*)f)->feedback->insert( xcursor );
    makeAutoUpdate();
    
    changed(1);
}
  
void RT_Manipulator::checkAxis(RT_Vector &v, double x, double y, double z, RT_ManipulatorAxis axis) {
    if (!(axis & RTD_MANIPULATOR_AXIS_X_MASK)) v.x = 0.0; else v.x = x;
    if (!(axis & RTD_MANIPULATOR_AXIS_Y_MASK)) v.y = 0.0; else v.y = y;
    if (!(axis & RTD_MANIPULATOR_AXIS_Z_MASK)) v.z = 0.0; else v.z = z;
}

void RT_Manipulator::event(RT_Event *ev) {
    if (ev && get_camera()) {
	if (ev->isA( RTN_SPACEBALL_EVENT )) {
	    xtime = ev->getTime();
	    RT_SpaceballEvent &sev = *(RT_SpaceballEvent*)ev;
	    switch (xmode) {
	      case RTE_OBJECT_MODE:
		if( get_currentObject() && 
		   xtransformation & RTD_MANIPULATOR_TRANSFORMATION_ROTATION_MASK ) {
		    RT_Vector v,p;
		    checkAxis( v,sev.twistX,-sev.twistY,-sev.twistZ,get_axis());
		    v = v * RTD_MANIPULATOR_SP_ROT_SENS*get_sensibility()*(-1);
		    
		    p = (xcursor->get_matrix())*p;
		    
		    // check the class of the camera

		    if( get_camera()->isA( RTN_LOOKAT_CAMERA )) 
			RT_fixedPointRot( get_currentObject(),p,v, (RT_LookatCamera *)get_camera());
		    updateFeedback();
		}
		if (get_currentObject() && xtransformation & RTD_MANIPULATOR_TRANSFORMATION_TRANSLATION_MASK ) {
		    RT_Vector v;
		    checkAxis( v,sev.transX,sev.transY,-sev.transZ,get_axis());
		    v = v * RTD_MANIPULATOR_SP_TRANS_SENS * get_sensibility();
		    RT_fixedCoordTrans(get_currentObject(),v);
		    updateFeedback();
		}
		if ( get_currentObject() && xtransformation == RTE_SCALE ) {
		    RT_Vector v,v1(1,1,1);
		    checkAxis( v,-sev.twistY,-sev.twistY,-sev.twistY,get_axis());
		    v = v * RTD_MANIPULATOR_SP_SCALE_SENS * get_sensibility();
		    v = v + v1;
		    RT_fixedCoordScale(get_currentObject(),v);
		    updateFeedback();
		}
		break;
	      case RTE_CURSOR_MODE: 
		{
		    RT_Vector v,p;
		    checkAxis( v,sev.transX,sev.transY,-sev.transZ,get_axis());
		    v = v * RTD_MANIPULATOR_SP_TRANS_SENS * get_sensibility();
		    RT_fixedCoordTrans(xcursor,v);
		    makeAutoUpdate();
		}
	      case RTE_CAMERA_MODE:
		/*		
		    if(get_transformation() & RTD_MANIPULATOR_TRANSFORMATION_ROTATION_MASK ) {
			if (get_axis() & RTD_MANIPULATOR_AXIS_X_MASK) {
			    double angle = RTD_MANIPULATOR_SP_ROT_SENS * sev.twistX*get_sensibility();
			    RT_Vector vp = get_camera()->get_viewpoint();
			}
			if (get_axis() & RTD_MANIPULATOR_AXIS_Y_MASK)
			    if (get_axis() & RTD_MANIPULATOR_AXIS_Z_MASK)
				makeAutoUpdate();
		    }
		if (get_transformation() & RTD_MANIPULATOR_TRANSFORMATION_TRANSLATION_MASK ) {
		    RT_Vector v;
		    if (get_axis() & RTD_MANIPULATOR_AXIS_X_MASK);
		    if (get_axis() & RTD_MANIPULATOR_AXIS_Y_MASK);
		    if (get_axis() & RTD_MANIPULATOR_AXIS_Z_MASK);
		    makeAutoUpdate();
		} 
		*/
		break;
	    }
	    
	    // check the button events of the spaceball
	    if (sev.b1) {
		if (get_transformation() < RTE_ROT_TRANS) {
		    int i = get_transformation(); i++;
		    transformation( ((RT_ManipulatorXform) i ) ); 
		}
		else transformation( RTE_SCALE );
	    }
	    if (sev.b2) {
		if (get_axis() < RTE_XYZ_AXIS) {
		    int i = get_axis(); i++;
		    axis((RT_ManipulatorAxis)i);
		}
		else axis( RTE_X_AXIS );
	    }
	    if (sev.b5) sensibility(get_sensibility()/1.2);
	    if (sev.b6) sensibility(get_sensibility()*1.2);
	    if (sev.b7 && get_currentObject()) resetMatrix();
	    
	    if (sev.b8 && get_currentObject()) {
		RT_ManipulatorStyle dS = get_drawStyle();
		if (dS < RTE_INVISIBLE ) {
		    // AT&T doen't allow incrementing an enum
		    int fuck = (int)dS; fuck++;
		    dS = (RT_ManipulatorStyle)fuck;
		}
		else dS = RTE_SOLID;
		drawStyle(dS);
		makeAutoUpdate();
	    }
	    
	    if (sev.pick) {
		RT_ManipulatorMode m = get_mode();
		if ( m < RTE_CAMERA_MODE ) {
		    // AT&T doesn't allow incrementing an enum
		    int fuck = (int)m; fuck++;
		    m = (RT_ManipulatorMode)fuck;
		}
		else m = RTE_OBJECT_MODE;
		mode(m);
		makeAutoUpdate();
	    }
	}
	
	if (ev->isA( RTN_BUTTON_EVENT )) {
	    xtime = ev->getTime();
	    RT_ButtonEvent &bev = *(RT_ButtonEvent*)ev;
	    oldx =  bev.x/((double) bev.w);
	    oldy =  bev.y/((double) bev.h);
	    if (bev.left && !bev.shift ) {
		RT_Ray r;
		RT_Primitive *prim;
		get_camera()->buildRay(oldx, oldy, r);
		prim = get_camera()->getPrimitive( r );
		if (prim && prim->get_pickmode() != RTE_NOT_PICKABLE ) {
		    while ( prim->get_pickmode() == RTE_PICK_FATHER && prim->get_father() )
			prim = prim->get_father();
		    currentObject( prim );
		}
		mode( RTE_OBJECT_MODE );
	    }
	} 

	if (ev->isA( RTN_MOTION_EVENT )) {
	    xtime = ev->getTime();
	    RT_MotionEvent &mev = *(RT_MotionEvent*)ev;
	    double dx,dy,x,y;
	    x = mev.x/((double) mev.w );
	    y = mev.y/((double) mev.h );
	    dx = (oldx-x);
	    dy = (oldy-y);
	    oldx = x;
	    oldy = y;
	    switch (xmode) {
	      case RTE_OBJECT_MODE: 
		if (get_currentObject() && mev.middle && !mev.shift) {
		    RT_Vector v,p;
		    checkAxis( v,dy,dx,0.0,get_axis());
		    v = v * RTD_MANIPULATOR_M_ROT_SENS*get_sensibility()*(-1);
		    p = xcursor->get_matrix() * p;
			
		    // check the class of the camera
		    if ( get_camera()->isA( RTN_LOOKAT_CAMERA)) 
			RT_fixedPointRot(get_currentObject(),p,v,
					 (RT_LookatCamera *)get_camera());
		    
		    updateFeedback();
		}
		
		if (get_currentObject() && mev.middle && mev.shift) {
		    double tdx,tdy;
		    tdx = (y>0.5)?dx:-dx; 
		    tdy = (x<0.5)?dy:-dy; 
		    RT_Vector v,p;
		    checkAxis( v,0.0,0.0,(tdx+tdy)/2,get_axis());
		    v = v * RTD_MANIPULATOR_M_ROT_SENS * get_sensibility()*(-1);
		    p = xcursor->get_matrix()*p;
		    
		    // check the class of the camera
		    if ( get_camera()->isA( RTN_LOOKAT_CAMERA )) 
			RT_fixedPointRot(get_currentObject(),p,v,
					 (RT_LookatCamera *)get_camera());
		    updateFeedback();
		}
		
		if ( get_currentObject() && mev.right && !mev.shift) {
		    RT_Vector v;
		    checkAxis( v,-dx,-dy,0.0,get_axis());
		    v = v * RTD_MANIPULATOR_M_TRANS_SENS*get_sensibility();
		    RT_fixedCoordTrans(get_currentObject(),v);
		    updateFeedback();
		}
		
		if (get_currentObject() && mev.right && mev.shift) {
		    RT_Vector v;
		    checkAxis( v,0.0,0.0,dy,get_axis());
		    v = v * RTD_MANIPULATOR_M_TRANS_SENS*get_sensibility();
		    RT_fixedCoordTrans(get_currentObject(),v);
		    updateFeedback();
		}

		// Scale with the mouse
		if (get_currentObject() && mev.left && mev.shift ) {
		    RT_Vector v,v1(1,1,1);
		    checkAxis( v,dy,dy,dy,get_axis());
		    v = v * RTD_MANIPULATOR_M_SCALE_SENS*get_sensibility();
		    v = v + v1;
		    RT_fixedCoordScale(get_currentObject(),v);
		    updateFeedback();
		}
		break;

	      case RTE_CURSOR_MODE: {
		  if ((mev.right || mev.middle) && !mev.shift) {
		      RT_Vector v;
		      checkAxis( v,-dx,-dy,0.0,get_axis());
		      v = v * RTD_MANIPULATOR_M_TRANS_SENS*get_sensibility();
		      RT_fixedCoordTrans(xcursor,v);
		      makeAutoUpdate();
		  }
		  
		  if ((mev.right || mev.middle) && mev.shift) {
		      RT_Vector v;
		      checkAxis( v,0.0,0.0,dy,get_axis());
		      v = v * RTD_MANIPULATOR_M_TRANS_SENS*get_sensibility();
		      RT_fixedCoordTrans(xcursor,v);
		      makeAutoUpdate();
		  }
		  break;
	      }
	    }
	}
	
	if (get_changed()) {
	    callCBs();
	    changed(0);
	}
    }
}

// set the manipulator object and set a axes object as children:
void RT_Manipulator::currentObject(RT_Primitive *p) {
    if (p == xcurrentObject) return;
    RT_Primitive *oldCurrentObject = xcurrentObject;

    if (p == (RT_Primitive *)-1) p = 0;
    else if (oldCurrentObject) oldCurrentObject->removeRelatedObject( this );
    
    // set the new current object:
    xcurrentObject = p;
    
    // reset cursor offset:
    xcursor->matrix( RT_IDENTITY );

    if (p) {
	p->addRelatedObject( this );

	// set the box to the manipulator box mode
	p->box(get_box());

	// delete the box of the old currentObject
	// if the box are not solid
	if (oldCurrentObject) oldCurrentObject->box( RTE_NO_BOX );
	
	// set the styles of the manipulator to the current object
	if (!p->get_visible()) xdrawStyle = RTE_INVISIBLE;
	else {
	    const RT_FillstyleAttribute &r= (const RT_FillstyleAttribute &) p->get_attribute(RTN_FILLSTYLE_ATTR);
	    if (r.get_fillstyle()) xdrawStyle = RTE_SOLID;
	    else xdrawStyle = RTE_WIREFRAME;
	}

    } else {
	// set the defaults for the internal values
	xbox  = RTE_OBJECT_BOX;
	xdrawStyle = RTE_SOLID;
    }
    changed(1);
    updateFeedback();
}

void RT_Manipulator::drawStyle(RT_ManipulatorStyle s) {
    xdrawStyle = s;
    if (get_currentObject())
    switch (s) {
      case RTE_SOLID: {
	  get_currentObject()->attribute( RT_FillstyleAttribute( 1 ) );
	  get_currentObject()->visible(); 
      }
		      break;
      case RTE_WIREFRAME: {
	  get_currentObject()->attribute( RT_FillstyleAttribute( 0 ) );
	  get_currentObject()->visible(); 
      }
		      break;
      case RTE_INVISIBLE:
		      get_currentObject()->invisible();
		      break;
		  }
    makeAutoUpdate();
    changed(1);
};

void RT_Manipulator::box(RT_BoxMode s) {
    xbox = s;
    if (get_currentObject()) get_currentObject()->box(s);
    makeAutoUpdate();
    changed(1);
};

RT_Manipulator::RT_Manipulator(char *_name): RT_InputDevice(_name) { 
    xcurrentObject = 0;
    oldCurrentObject = 0;
    oldx = oldy = 0;

    // create feedback object:
    xcursor = new RT_Axes(0);
    xcursor->update( 1 );

    // set defaults:
    autoUpdate( 1 );
    drawStyle( RTE_SOLID );
    axis( RTE_XYZ_AXIS );
    transformation( RTE_ROT_TRANS );
    mode( RTE_OBJECT_MODE );
    box( RTE_OBJECT_BOX );
    sensibility( 1.0 );
}
    
void RT_Manipulator::updateFeedback() {
    if (get_currentObject()) {
	xcursor->changedFatherModelling( get_currentObject()->getModel() );
	xcursor->matrixChanged();
    }
    else {
	xcursor->changedFatherModelling( (RT_Modelling*)&rt_Modelling );
	xcursor->matrix( RT_IDENTITY );
    }
    makeAutoUpdate();
}

void RT_Manipulator::print(FILE *f) const {
    RT_InputDevice::print( f );
    fprintf( f, "%s -mode %i -box %i -autoUpdate %i -axis %i -drawStyle %i -transformation %i -sensibility %lf", get_name(), get_mode(), get_box(), get_autoUpdate(), get_axis(), get_drawStyle(), get_transformation(), get_sensibility() );

    if (get_currentObject()) fprintf( f, " -currentObject %s\n", get_currentObject()->get_name() );
    else fprintf( f, "\n" );
}

void RT_Manipulator::mode( RT_ManipulatorMode m) {
    xmode = m;
    // change feedback color:
    switch (xmode) {
      case RTE_OBJECT_MODE:
	xcursor->diffuse( RT_Color( 1, 1, 1 ));
	break;
      case RTE_CURSOR_MODE:
	xcursor->diffuse( RT_Color( 0, 1, 0 ));
	break;
      case RTE_CAMERA_MODE:
	xcursor->diffuse( RT_Color( 1, 0, 0 ));
	break;
    }
    makeAutoUpdate();
    changed( 1 );
} 
