////////////////////////////////////////////////////////////////////////////////
//  definition of parametric curves                                           //  
//  LAST EDIT: Tue Mar  7 19:49:18 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __CURVES_H__
#define __CURVES_H__

#include "poly.h"
#include "predattr.h"
#include "bspline.h"

extern const char *RTN_CURVE;

class RT_Curve: public RT_Polyvertex, public RT_ResolutionAttrImpl {
    // a references to attribute classes, which will be inherited to all derived classes:
    RT_ResolutionAttribute *xsolution;
    
    // statics for parameter parsing:
    static RT_ParseEntry table[];
    static int polygF;    
  protected:
    // reference to line:
    RT_Polyline *xline, *xpolygon;

    // draw the leading polygon or do not:
    int drawPolygon;
    
    // reset and set the references to polyline:
    void newGeometry();
    void drawLeadingPolygon();
  public:
    //#### the Tcl/C++ methods:
    RT_Curve( char *a, int b, RT_Vector *c, RT_Surface *d, RT_Vector *e ) : RT_Polyvertex( a, b, c, d, e ) {
	xsolution = 0;
	xline = 0;
	xpolygon = 0;
	drawPolygon = 0;
    }
    
    ~RT_Curve() {
	if( xline ) delete xline; xline = 0; 
	if( xpolygon ) delete xpolygon; xpolygon = 0;
    }

    // Attributes interface
    void checkAttributes();
    void createReferences(const RT_AttributeList &);
    
    void resolution(double);
    double get_resolution() const;
    
    int copy(RT_Primitive *) const;

    // Ray-tracer interface:
    int intersect( const RT_Ray &ray, RT_InterSectionList &inter ) { 
	return( xline->intersect( ray, inter ) ); 
    }
    void normal( const RT_Vector &wc, RT_Vector &n ) { xline->normal( wc, n ); }
    
    // Tcl interface:
    const char *get_description() const { return "An editable parametric curve."; }
    const char *get_class() const { return RTN_CURVE; }
    int isA(const char * _c) const {  return RT_Polyvertex::isA( _c ) || RTM_isA(_c, RTN_CURVE ); }
    
    int objectCMD(char *argv[]);
};

extern const char *RTN_BSPLINE;

class RT_BSpline: public RT_Curve {
  private:
    // create a b-spline!
    void create() { createSpline(); }
    
    // statics for parameter parsing:
    static RT_ParseEntry table[];
    static int ordF, ordV, getOrdF, cfF, cfV, getModeF;
    
  protected:
    _bspline *xspline;
    void  createSpline();
  public:
    RT_BSpline(char*, int, RT_Vector*, RT_Surface*, RT_Vector*);
    ~RT_BSpline() { 
	if (xspline) delete xspline;
    }

    const char *get_description() const { return "An editable b-spline, of order = degree-1."; }
    const char *get_class() const { return RTN_BSPLINE; }
    int isA(const char * _c) const {  return RT_Curve::isA( _c ) || RTM_isA(_c, RTN_BSPLINE ); }
    
    void print( FILE *f ) const {
	RT_Curve::print( f );
	fprintf( f, "%s -order %d ", get_name(), xspline->getOrd() );
	fprintf( f, "-mode %d ", xspline->getMod() );
	fprintf( f, "\n" );
    }
    
    // RAY-tracer interface:
    int intersect( const RT_Ray &ray, RT_InterSectionList &inter ) {
	return xline->intersect( ray, inter );
    }
    void normal( const RT_Vector &wc, RT_Vector &n ) {
	xline->normal( wc, n );
    }

    // Tcl interface:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
    int objectCMD(char *[]);
};

extern const char *RTN_BEZIER;

class RT_Bezier: public RT_BSpline {
  private:
    // create a bezier curve
    void create();
  public:
    RT_Bezier( char *, int, RT_Vector*, RT_Surface*, RT_Vector*);

    const char *get_description() const { return "An editable bezier curve."; }
    const char *get_class() const { return RTN_BEZIER; }
    int isA(const char * _c) const {  return RT_BSpline::isA( _c ) || RTM_isA(_c, RTN_BEZIER ); }

    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
    int objectCMD(char *argv[]) { int ret = RT_BSpline::objectCMD( argv ); return ret++; }
};

#endif



