/* Glue code to run with bsd curses.
   Copyright (C) 1994 Miguel de Icaza
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   KNOWN PROBLEMS:

   In the code we use derwin in order to have boxes, we should remove
   that code, now that we have the dialog manager running and the nice
   box function.

   Find won't work without the wscrl, change that.
   


   */

#include <ncurses.h>

int has_colors (void)
{
    return 0;
}

int init_pair (int pair, int fore, int back)
{
    return 0;
}

int start_color (void)
{
    return 0;
}

static int ungetched_char = 0;

int x_getch (void)
{
    if (ungetched_char){
	int t = ungetched_char;
	ungetched_char = 0;
	return t;
    }
    return getch ();
}

#ifndef SUNOS_CURSES
void ungetch (int c)
{
    ungetched_char = c;
}

void whline (WINDOW *w, int character, int len)
{
    int i;

    for (i = 0; i < len; i++)
	 waddch (w, character);
}

void wvline (WINDOW *w, int x, int y)
{
}
#endif

