/* If using a subshell for evaluating commands this is true */
extern int use_subshell;

/* Used to distinguish between a normal MC termination and */
/* one caused by typing `exit' or `logout' in the subshell */
#define SUBSHELL_EXIT 127


#ifdef HAVE_SUBSHELL_SUPPORT

/* File descriptor of the pseudoterminal used by the subshell */
extern int subshell_pty;

/* The key to switch back to MC from the subshell */
extern char subshell_switch_key;

/* State of the subshell; see subshell.c for an explanation */
enum subshell_state_enum {INACTIVE, ACTIVE, RUNNING_COMMAND};
extern enum subshell_state_enum subshell_state;

/* Holds the latest prompt captured from the subshell */
extern char *subshell_prompt;

/* For the `how' argument to various functions */
enum {QUIETLY, VISIBLY};

/* Exported functions */
void init_subshell (void);
int invoke_subshell (const char *command, int how, char **new_dir);
void read_subshell_prompt (int how);
void resize_subshell (void);
void exit_subshell (void);
void sigchld_handler (int sig);
void subshell_get_console_attributes ();

#endif /* HAVE_SUBSHELL_SUPPORT */
