
typedef struct
{
   int x, y, dx, dy;		       /* top left corner (x, y), width, height */
} SLwin_Rect_Type;

typedef struct
{
   unsigned int keysym;
   unsigned char mask;
}
SLwin_Kbd_Event_Type;

typedef int SLwin_Msg_Event_Type;

#ifdef HAS_MOUSE
typedef struct
{
   int x, y;
   unsigned char mask;
}
SLwin_Mouse_Event_Type;
#endif

typedef struct
{
   unsigned int type;
#define SLWIN_MOUSE_EVENT 1
#define SLWIN_KBD_EVENT 2
#define SLWIN_MSG_EVENT 3
   union 
     {
#ifdef HAS_MOUSE
	SLwin_Mouse_Event_Type mouse;
#endif
	SLwin_Kbd_Event_Type kbd;
	SLwin_Msg_Event_Type msg;
     }
   event;
} 
SLwin_Event_Type;


typedef struct SLwin_Base_Window_Type
{
   int type;			       
#define SLWIN_GROUP_TYPE 1
#define SLWIN_LABEL_TYPE 2

   struct SLwin_Base_Window_Type *znext;/* next one with same parent */
   struct SLwin_Base_Window_Type *zprev;/* prev one with same parent */
   struct SLwin_Base_Window_Type *child;/* children in Z order.  This field
					 * is non-NULL for only GROUP type
					 * windows.
					 */
   struct SLwin_Base_Window_Type *parent;/* parent is a group window */
   
   SLwin_Rect_Type rect;
   int xabs, yabs;		       /* screen coords of rectangle */
   
   unsigned int style_flags;
#define SLWIN_BORDER 0x0001
#define SLWIN_FILLED 0x0002
#define SLWIN_TITLED 0x0004
   int color;			       /* color object used to paint window */
   
   char *text;			       /* used for labels, titles */
#define SLWIN_STATIC 0x0001
   unsigned long flags;
   
   unsigned long event_mask;
   void (*destroy) _PROTO((struct SLwin_Base_Window_Type *));
   void (*draw) _PROTO((struct SLwin_Base_Window_Type *));
   void (*windproc)_PROTO((struct SLwin_Base_Window_Type *, SLwin_Event_Type *));
}
SLwin_Base_Window_Type;

