#include <gpm.h>

/* This is the interface to the GPM mouse under Linux */

#define MOD_SHIFT 1
#define MOD_CTRL 4

static int Mouse_Showing;
static int MouseX, MouseY;

static void draw_mouse (void)
{
   Gpm_Event event;
   int ok = 1;
   
   if (MouseX <= 0)
     {
	ok = 0; MouseX = 0; 
     }
   else if (MouseX > *tt_Screen_Cols)
     {
	ok = 0; MouseX = *tt_Screen_Cols + 1;
     }
   
   if (MouseY <= 0)
     {
	ok = 0; MouseY = 0;
     }
   else if (MouseY > *tt_Screen_Rows)
     {
	ok = 0; MouseY = *tt_Screen_Rows + 1;
     }
   
   if (ok)
     {
	event.x = MouseX;
	event.y = MouseY;
	
	GPM_DRAWPOINTER(&event);
	Mouse_Showing = 1;
     }
   /* else turn off the pointer.  However, there seems to be no mechanism 
    * for this!!!
    */
}


static int mouse_handler_2 (void)
{
   int b = 0, nbuttons;
   Gpm_Event event;
   unsigned char buf[6];
   
   if (Gpm_GetEvent (&event) <= 0) return -1;
   if (Suspend_Mouse_Events) 
     {
	if (Suspend_Mouse_Events == -1) 
	  Suspend_Mouse_Events = 0;
	return -1;
     }
   
   MouseX += event.dx;
   MouseY += event.dy;
   
   draw_mouse ();
   
   if (event.type & GPM_MOVE) return 0;
   
   nbuttons = 0;
   if (event.buttons & GPM_B_LEFT)
     {
	b = 'l';
	JMouse.button = 1;
	nbuttons++;
     }
   if (event.buttons & GPM_B_MIDDLE)
     {
	b = 'm';
	JMouse.button = 2;
	nbuttons++;
     }
   if (event.buttons & GPM_B_RIGHT)
     {
	JMouse.button = 3;
	b = 'r';
	nbuttons++;
     }
   
   if (nbuttons != 1) return 0;
   
   buf[0] = 27; buf[1] = 0;
   
   if (event.type & GPM_DRAG) buf[2] = 0;
   else if (event.type & GPM_DOWN) buf[2] = 'D';
   else if (event.type & GPM_UP) buf[2] = 'U';
   else return 0;
   
   if (event.modifiers & MOD_SHIFT)
     {
	b = b - 'a' + 'A';
     }
   else if (event.modifiers & MOD_CTRL)
     {
	b = b - 'a' + 1;
     }
   
   buf[3] = b;
   ungetkey_string (buf, 4);
   JMouse.x = MouseX;
   JMouse.y = MouseY;
   return 1;
}


static int Warp_Pending;
static void close_update (void)
{
   if (Warp_Pending || Mouse_Showing)
     {
	if (Warp_Pending)
	  {
	     JMouse.x = MouseX = Screen_Col;
	     JMouse.y = MouseY = Screen_Row;
	  }
	else
	  {
	     MouseX = JMouse.x;
	     MouseY = JMouse.y;
	  }
	draw_mouse ();
	Warp_Pending = 0;
     }
   else Mouse_Showing = 0;
}

static void warp_pointer (void)
{
   Warp_Pending = 1;
}

static char *CutBuffer;
static int CutBuffer_Len;

static int insert_cutbuffer (void)
{
   CHECK_READ_ONLY
   if (CutBuffer == NULL) return 0;
   if (CutBuffer_Len) ins_chars ((unsigned char *) CutBuffer, CutBuffer_Len);
   return CutBuffer_Len;
}

static void region_to_cutbuffer (void)
{
   int nbytes;
   
   if (CutBuffer != NULL)
     {
	SLFREE (CutBuffer);
     }
   
   CutBuffer = make_buffer_substring(&nbytes);
   CutBuffer_Len = nbytes;
}

static SLang_Name_Type gpm_mouse_table[] =
{
   MAKE_INTRINSIC(".x_warp_pointer", warp_pointer, VOID_TYPE, 0),
   MAKE_INTRINSIC(".x_insert_cutbuffer", insert_cutbuffer, INT_TYPE, 0),
   /* Prototype: Integer x_insert_cut_buffer ();
    * Inserts cutbuffer into the current buffer and returns the number
    * of characters inserted.
    */
   MAKE_INTRINSIC(".x_copy_region_to_cutbuffer", region_to_cutbuffer, VOID_TYPE, 0),
   /* Prototype: Void x_copy_region_to_cutbuffer();
    */
   SLANG_END_TABLE
};

static void hide_mouse (int show)
{
   Mouse_Showing = show;
}

static int open_mouse (void)
{
   static int not_first_time;
   Gpm_Connect conn;
   
   conn.eventMask = ~0;
   conn.defaultMask = 0;
   conn.maxMod = MOD_CTRL | MOD_SHIFT;
   conn.minMod = 0;

   Mouse_Showing = 0;
   Suspend_Mouse_Events = -1;
   MouseX = *tt_Screen_Cols / 2;
   MouseY = *tt_Screen_Rows / 2;
   if (-1 == Gpm_Open (&conn, 0)) return -1;
   
   if (not_first_time == 0)
     {
	if (!SLang_add_table(gpm_mouse_table, "Mouse")
	    || !SLdefine_for_ifdef("MOUSE")) return -1;
	
	not_first_time = 1;
     }
   
   JMouse_Event_Hook = mouse_handler_2;
   X_Update_Close_Hook = close_update;
   JMouse_Hide_Mouse_Hook = hide_mouse;
   return gpm_fd;
}

static void close_mouse (void)
{
   X_Update_Close_Hook = NULL;
   if (JMouse_Event_Hook == NULL) return;
   JMouse_Event_Hook = NULL;
   Gpm_Close ();
}


   
int (*X_Open_Mouse_Hook)(void) = open_mouse;
void (*X_Close_Mouse_Hook)(void) = close_mouse;

   
