dnl local autoconf macros
dnl Bruno Haible 30.12.1994
dnl Marcus Daniels 31.10.1994
dnl
dnl without AC_MSG_...:   with AC_MSG_... and caching:
dnl   AC_TRY_CPP          CL_CPP_CHECK
dnl   AC_TRY_COMPILE      CL_COMPILE_CHECK
dnl   AC_TRY_LINK         CL_LINK_CHECK
dnl   AC_TRY_RUN          CL_RUN_CHECK - would require cross-compiling support
dnl Usage:
dnl AC_TRY_CPP(INCLUDES,
dnl            ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND])
dnl CL_CPP_CHECK(ECHO-TEXT, CACHE-ID,
dnl              INCLUDES,
dnl              ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND])
dnl AC_TRY_xxx(INCLUDES, FUNCTION-BODY,
dnl            ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND])
dnl CL_xxx_CHECK(ECHO-TEXT, CACHE-ID,
dnl              INCLUDES, FUNCTION-BODY,
dnl              ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND])
define(CL_CPP_CHECK,
[AC_MSG_CHECKING(for $1)
AC_CACHE_VAL($2,[
AC_TRY_CPP([$3], $2=yes, $2=no)
])
AC_MSG_RESULT([$]$2)
if test [$]$2 = yes; then
  ifelse([$4], , :, [$4])
ifelse([$5], , , [else
  $5
])dnl
fi
])dnl
dnl
define(CL_COMPILE_CHECK,
[AC_MSG_CHECKING(for $1)
AC_CACHE_VAL($2,[
AC_TRY_COMPILE([$3],[$4], $2=yes, $2=no)
])
AC_MSG_RESULT([$]$2)
if test [$]$2 = yes; then
  ifelse([$5], , :, [$5])
ifelse([$6], , , [else
  $6
])dnl
fi
])dnl
dnl
define(CL_LINK_CHECK,
[AC_MSG_CHECKING(for $1)
AC_CACHE_VAL($2,[
AC_TRY_LINK([$3],[$4], $2=yes, $2=no)
])
AC_MSG_RESULT([$]$2)
if test [$]$2 = yes; then
  ifelse([$5], , :, [$5])
ifelse([$6], , , [else
  $6
])dnl
fi
])dnl
dnl
dnl CL_PROTO(IDENTIFIER, ACTION-IF-NOT-FOUND, FINAL-PROTOTYPE)
define(CL_PROTO,
[AC_MSG_CHECKING([for $1 declaration])
AC_CACHE_VAL(cl_cv_proto_[$1], $2[
cl_cv_proto_$1="$3"])
cl_cv_proto_$1=`echo "[$]cl_cv_proto_$1" | tr -s ' ' | sed -e 's/( /(/'`
AC_MSG_RESULTPROTO([$]cl_cv_proto_$1)
])dnl
dnl
dnl CL_PROTO_RET(INCLUDES, DECL, CACHE-ID, TYPE-IF-OK, TYPE-IF-FAILS)
define(CL_PROTO_RET,
[AC_TRY_COMPILE([$1]
AC_LANG_EXTERN[$2
], [], $3="$4", $3="$5")
])dnl
dnl
dnl CL_PROTO_TRY(INCLUDES, ANSI-DECL, TRAD-DECL, ACTION-IF-OK, ACTION-IF-FAILS)
define(CL_PROTO_TRY,
[AC_TRY_COMPILE([$1]
AC_LANG_EXTERN
[#ifdef __STDC__
$2
#else
$3
#endif
], [], $4, $5)
])dnl
dnl
dnl CL_PROTO_CONST(INCLUDES, ANSI-DECL, TRAD-DECL, CACHE-ID)
define(CL_PROTO_CONST,
[CL_PROTO_TRY([$1], [$2], [$3], $4="", $4="const")]
)dnl
dnl
dnl CL_SILENT(ACTION)
dnl performs ACTION, with AC_MSG_CHECKING and AC_MSG_RESULT being defined away.
define(CL_SILENT,
[pushdef([AC_MSG_CHECKING],[:])dnl
pushdef([AC_CHECKING],[:])dnl
pushdef([AC_MSG_RESULT],[:])dnl
pushdef([AC_MSG_RESULTPROTO],[:])dnl
$1[]dnl
popdef([AC_MSG_RESULTPROTO])dnl
popdef([AC_MSG_RESULT])dnl
popdef([AC_CHECKING])dnl
popdef([AC_MSG_CHECKING])dnl
])dnl
dnl
AC_DEFUN(CL_CC_GCC,
[AC_REQUIRE([AC_PROG_CPP])
AC_MSG_CHECKING(whether using GNU C)
AC_CACHE_VAL(cl_cv_prog_cc_gcc,[
AC_EGREP_CPP(yes,[#ifdef __GNUC__
  yes
#endif
], cl_cv_prog_cc_gcc=yes, cl_cv_prog_cc_gcc=no)
])
AC_MSG_RESULT($cl_cv_prog_cc_gcc)
if test $cl_cv_prog_cc_gcc = yes; then
  CC_GCC=true
else
  CC_GCC=false
fi
AC_SUBST(CC_GCC)dnl
])dnl
dnl
AC_DEFUN(CL_CC_ANSI,
[AC_REQUIRE([AC_PROG_CPP])
AC_MSG_CHECKING(whether using ANSI C)
AC_CACHE_VAL(cl_cv_prog_cc_ansi,[
AC_EGREP_CPP(yes,[#ifdef __STDC__
  yes
#endif
], cl_cv_prog_cc_ansi=yes, cl_cv_prog_cc_ansi=no)
])
AC_MSG_RESULT($cl_cv_prog_cc_ansi)
if test $cl_cv_prog_cc_ansi = yes; then
  CC_ANSI=true
else
  CC_ANSI=false
fi
AC_SUBST(CC_ANSI)dnl
])dnl
dnl
AC_DEFUN(CL_CC_NEED_CCPAUX,
[AC_REQUIRE([AC_PROG_CPP])
AC_MSG_CHECKING(whether CPP likes indented directives)
AC_CACHE_VAL(cl_cv_prog_cc_indented,[
AC_EGREP_CPP([#.*foo],[ #define foo],
cl_cv_prog_cc_indented=no, cl_cv_prog_cc_indented=yes)
])
AC_MSG_RESULT($cl_cv_prog_cc_indented)
if test $cl_cv_prog_cc_indented = yes; then
  CC_NEED_CCPAUX=false
else
  CC_NEED_CCPAUX=true
fi
AC_SUBST(CC_NEED_CCPAUX)dnl
])dnl
dnl
AC_DEFUN(CL_CC_NEED_DEELIF,
[AC_REQUIRE([AC_PROG_CPP])
dnl Bug in autoconf-2.1: If we put the # literally there, AC_FD_MSG doesn't get expanded.
sharp='#elif'
AC_MSG_CHECKING([whether CPP understands $sharp])
AC_CACHE_VAL(cl_cv_prog_cc_elif,[
AC_TRY_CPP([#if 0
#elif 1
#else
#endif],
cl_cv_prog_cc_elif=yes, cl_cv_prog_cc_elif=no)
])
AC_MSG_RESULT($cl_cv_prog_cc_elif)
if test $cl_cv_prog_cc_elif = yes; then
  CC_NEED_DEELIF=false
else
  CC_NEED_DEELIF=true
fi
AC_SUBST(CC_NEED_DEELIF)dnl
])dnl
dnl
AC_DEFUN(CL_CC_NEED_DEERROR,
[AC_REQUIRE([AC_PROG_CPP])
dnl Bug in autoconf-2.1: If we put the # literally there, AC_FD_MSG doesn't get expanded.
sharp='#error'
AC_MSG_CHECKING([whether CPP understands $sharp])
AC_CACHE_VAL(cl_cv_prog_cc_error,[
AC_TRY_CPP([#if 0
#error "bla"
#endif],
cl_cv_prog_cc_error=yes, cl_cv_prog_cc_error=no)
])
AC_MSG_RESULT($cl_cv_prog_cc_error)
if test $cl_cv_prog_cc_error = yes; then
  CC_NEED_DEERROR=false
else
  CC_NEED_DEERROR=true
fi
AC_SUBST(CC_NEED_DEERROR)dnl
])dnl
dnl
AC_DEFUN(CL_CC_NEED_DEEMA,
[AC_REQUIRE([AC_PROG_CPP])
AC_MSG_CHECKING(whether CPP likes empty macro arguments)
AC_CACHE_VAL(cl_cv_prog_cc_ema,[
AC_TRY_CPP([#define divide(x,y,q_zuw,r_zuw) (r_zuw(x)-(q_zuw(x)/(y))*(y))
foo(x,y) int x,y; { int q; divide(x,y,q=,); return q; }],
cl_cv_prog_cc_ema=yes, cl_cv_prog_cc_ema=no)
])
AC_MSG_RESULT($cl_cv_prog_cc_ema)
if test $cl_cv_prog_cc_ema = yes; then
  CC_NEED_DEEMA=false
else
  CC_NEED_DEEMA=true
fi
AC_SUBST(CC_NEED_DEEMA)dnl
])dnl
dnl
AC_DEFUN(CL_CC_NEED_MERGESTRINGS,
[AC_REQUIRE([AC_PROG_CPP])
AC_MSG_CHECKING(whether CC merges adjacent strings)
AC_CACHE_VAL(cl_cv_prog_cc_mergestrings,[
AC_TRY_COMPILE([], [char* foo = "abc" "def";],
cl_cv_prog_cc_mergestrings=yes, cl_cv_prog_cc_mergestrings=no)
rm -f conftest*
])
AC_MSG_RESULT($cl_cv_prog_cc_mergestrings)
if test $cl_cv_prog_cc_mergestrings = yes; then
  CC_NEED_MERGESTRINGS=false
else
  CC_NEED_MERGESTRINGS=true
fi
AC_SUBST(CC_NEED_MERGESTRINGS)dnl
])dnl
dnl
AC_DEFUN(CL_AS_UNDERSCORE,
[AC_MSG_CHECKING(for underscore in external names)
AC_CACHE_VAL(cl_cv_prog_as_underscore,[
cat > conftest.c <<EOF
int foo() { return 0; }
EOF
${CC-cc} -c conftest.c >/dev/null 2>&1
# check whether nm exists
if (nm conftest.o) >/dev/null 2>&1 ; then
  # use nm to see the assembly language name
  if nm conftest.o | grep _foo >/dev/null 2>&1 ; then
    cl_cv_prog_as_underscore=yes
  else
    cl_cv_prog_as_underscore=no
  fi
else
  # look for the assembly language name in the .s file
  ${CC-cc} -S conftest.c >/dev/null 2>&1
  if grep _foo conftest.s >/dev/null ; then
    cl_cv_prog_as_underscore=yes
  else
    cl_cv_prog_as_underscore=no
  fi
fi
rm -f conftest*
])
AC_MSG_RESULT($cl_cv_prog_as_underscore)
if test $cl_cv_prog_as_underscore = yes; then
  AS_UNDERSCORE=true
else
  AS_UNDERSCORE=false
fi
AC_SUBST(AS_UNDERSCORE)dnl
])dnl
dnl
AC_DEFUN(CL_PROG_RANLIB, [AC_CHECK_PROG(RANLIB, ranlib, ranlib, true)])dnl
dnl
AC_DEFUN(CL_PROG_INSTALL,
[dnl This is mostly copied from AC_PROG_INSTALL.
# Find a good install program.  We prefer a C program (faster),
# so one script is as good as another.  But avoid the broken or
# incompatible versions:
# SysV /etc/install, /usr/sbin/install
# SunOS /usr/etc/install
# IRIX /sbin/install
# AIX /bin/install
# AFS /usr/afsws/bin/install, which mishandles nonexistent args
# SVR4 /usr/ucb/install, which tries to use the nonexistent group "staff"
# ./install, which can be erroneously created by make from ./install.sh.
AC_MSG_CHECKING(for a BSD compatible install)
if test -z "$INSTALL"; then
AC_CACHE_VAL(cl_cv_path_install,
[  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  for ac_dir in $PATH; do
    case "$ac_dir" in
    ''|.|/etc|/usr/sbin|/usr/etc|/sbin|/usr/afsws/bin|/usr/ucb) ;;
    *)
      # OSF1 and SCO ODT 3.0 have their own names for install.
      for ac_prog in ginstall installbsd scoinst install; do
        if test -f $ac_dir/$ac_prog; then
	  if test $ac_prog = install &&
            grep dspmsg $ac_dir/$ac_prog >/dev/null 2>&1; then
	    # AIX install.  It has an incompatible calling convention.
	    # OSF/1 installbsd also uses dspmsg, but is usable.
	    :
	  else
	    cl_cv_path_install="$ac_dir/$ac_prog -c"
	    break 2
	  fi
	fi
      done
      ;;
    esac
  done
  IFS="$ac_save_ifs"
  # As a last resort, use cp.
  test -z "$cl_cv_path_install" && cl_cv_path_install="cp"
])dnl
  INSTALL="$cl_cv_path_install"
fi
dnl We do special magic for INSTALL instead of AC_SUBST, to get
dnl relative paths right. 
AC_MSG_RESULT($INSTALL)
AC_SUBST(INSTALL)dnl
# Use test -z because SunOS4 sh mishandles braces in ${var-val}.
# It thinks the first close brace ends the variable substitution.
test -z "$INSTALL_PROGRAM" && INSTALL_PROGRAM='$(INSTALL)'
AC_SUBST(INSTALL_PROGRAM)dnl
if test -z "$INSTALL_DATA"; then
  case "$INSTALL" in
    cp | */cp ) INSTALL_DATA='$(INSTALL)' ;;
    * )         INSTALL_DATA='$(INSTALL) -m 644' ;;
  esac
fi
AC_SUBST(INSTALL_DATA)dnl
])dnl
dnl
AC_DEFUN(CL_CP,
[AC_MSG_CHECKING(how to copy files)
AC_CACHE_VAL(cl_cv_prog_cp,[
echo "blabla" > conftest.x
err=`/bin/sh -c "cp -p conftest.x conftest.y 2>&1"`
if test -z "$err"; then
  cl_cv_prog_cp='cp -p'
else
  cl_cv_prog_cp='cp'
fi
rm -f conftest*
])
AC_MSG_RESULT($cl_cv_prog_cp)
CP="$cl_cv_prog_cp"
AC_SUBST(CP)dnl
])dnl
dnl
AC_DEFUN(CL_FIND_X,
[echo checking for X11
X_INCLUDES=''
X_LIBS=''
dnl First check for xmkmf.
AC_CHECK_PROG(HAVE_XMKMF, xmkmf, yes)dnl
if test "$HAVE_XMKMF" = yes; then
  have_x11=1
  AC_DEFINE(HAVE_X11)
  X_LIBS='-lX11'
  AC_PATH_X()dnl
  if test -n "$x_includes" -a "$x_includes" != NONE; then
    # Adding -I/usr/include may override gcc's private include hierarchy.
    if test "$x_includes" != "/usr/include"; then
      X_INCLUDES="-I$x_includes"
    fi
  fi
  if test -n "$x_libraries" -a "$x_libraries" != NONE; then
    X_LIBS="-L$x_libraries "$X_LIBS
  fi
else
  dnl From John Ousterhout <ouster@allspice.berkeley.edu>
  dnl There are some X11 installations around that don't have xmkmf.
  AC_MSG_CHECKING(for X11 header files)
  AC_TRY_CPP([#include <X11/Intrinsic.h>], have_x_includes=1)
  if test -z "$have_x_includes"; then
    for dir in /usr/X11/include /usr/openwin/include /usr/include/X11R5 /usr/X11R5/include /usr/include/X11R4 /usr/X386/include /usr/x386/include /usr/local/include /usr/unsupported/include; do
      if test -z "$have_x_includes"; then
        if test -r $dir/X11/Intrinsic.h; then
          x_includes="$dir"
          have_x_includes=1
        fi
      fi
    done
  fi
  if test -n "$x_includes" -a "$x_includes" != NONE; then
    X_INCLUDES="-I$x_includes"
  fi
  AC_MSG_RESULT($X_INCLUDES)
  AC_MSG_CHECKING(for X11 library)
  CL_SILENT([
  AC_CHECK_LIB(X11,main, have_x_libraries=1)dnl
  if test -z "$have_x_libraries"; then
    for dir in /usr/X11/lib /usr/openwin/lib /usr/lib/X11R5 /usr/X11R5/lib /usr/lib/X11R4 /usr/X386/lib /usr/x386/lib /usr/local/lib /usr/unsupported/lib; do
      if test -z "$have_x_libraries"; then
        if test -r $dir/libX11.a; then
          x_libraries="$dir"
          have_x_libraries=1
        fi
      fi
    done
  fi
  if test -n "$have_x_libraries"; then
    X_LIBS='-lX11'
    if test -n "$x_libraries" -a "$x_libraries" != NONE; then
      X_LIBS="-L$x_libraries "$X_LIBS
    fi
  else
    AC_CHECK_LIB(Xwindow,main, X_LIBS='-lXwindow' have_x_libraries=1)dnl
  fi
  ])
  AC_MSG_RESULT($X_LIBS)
  dnl Don't use X if either the header files or the libraries were not found.
  if test -n "$have_x_includes" -a -n "$have_x_libraries"; then
    have_x11=1
    AC_DEFINE(HAVE_X11)
  else
    X_INCLUDES=''
    X_LIBS=''
  fi
fi
AC_SUBST(X_INCLUDES)dnl
AC_SUBST(X_LIBS)dnl
])dnl
dnl
AC_DEFUN(CL_IRIX_SUN,
[AC_CHECK_FUNC(getpwnam, have_getpwnam=1)
if test -z "$have_getpwnam"; then
  AC_CHECK_LIB(sun,getpwnam)
fi
])dnl
dnl
AC_DEFUN(CL_DYNIX_SEQ,
[AC_MSG_CHECKING(for DYNIX/ptx libseq or libsocket)
AC_CACHE_VAL(cl_cv_lib_sequent,[
AC_EGREP_CPP(yes,
[#if defined(_SEQUENT_)
  yes
#endif
], cl_cv_lib_sequent=yes, cl_cv_lib_sequent=no)
])
AC_MSG_RESULT($cl_cv_lib_sequent)
if test $cl_cv_lib_sequent = yes; then
AC_CHECK_LIB(seq,main,LIBS="$LIBS -lseq")
dnl libsocket is needed for select()
AC_CHECK_LIB(socket,main,LIBS="$LIBS -lsocket")
fi
])dnl
dnl
AC_DEFUN(CL_SOCKET,
[dnl check whether -lsocket is needed for the functions gethostbyname(),
dnl connect(), socket(), inet_addr(), setsockopt().
AC_MSG_CHECKING(whether gethostbyname requires -lsocket)
AC_CACHE_VAL(cl_cv_lib_socket,[
cl_cv_lib_socket=no
AC_TRY_LINK(AC_LANG_EXTERN[char gethostbyname();], [gethostbyname();],
have_gethostbyname=1)
if test -z "$have_gethostbyname"; then
cl_save_LIBS="$LIBS"
LIBS="$LIBS -lsocket"
AC_TRY_LINK(AC_LANG_EXTERN[char gethostbyname();], [gethostbyname();],
cl_cv_lib_socket=yes)
LIBS="$cl_save_LIBS"
fi
])
AC_MSG_RESULT($cl_cv_lib_socket)
if test $cl_cv_lib_socket = yes; then
  LIBS="$LIBS -lsocket"
fi
])dnl
dnl
AC_DEFUN(CL_CC_WORKS,
[AC_MSG_CHECKING(whether CC works at all)
AC_CACHE_VAL(cl_cv_prog_cc_works,[
AC_TRY_RUN([main() { exit(0); }],
cl_cv_prog_cc_works=yes, cl_cv_prog_cc_works=no,
cl_cv_prog_cc_works="guessing yes")
])
AC_MSG_RESULT($cl_cv_prog_cc_works)
case "$cl_cv_prog_cc_works" in
  *no) echo "Installation or configuration problem: C compiler cannot create executables."; exit 1;;
  *yes) ;;
esac
])dnl
dnl
AC_DEFUN(CL_SHELLARGS,
[AC_REQUIRE([AC_C_CROSS])dnl
AC_MSG_CHECKING([for broken HP/UX, A/UX, OSF/1 and NeXTstep shell])
AC_CACHE_VAL(cl_cv_prog_sh_broken,[
if test $cross_compiling = no; then
# A program that outputs its argument count:
cat > conftest.c <<EOF
#include "confdefs.h"
#include <stdio.h>
#ifdef __STDC__
main (int argc, char** argv)
#else
main (argc,argv) int argc; char** argv;
#endif
{ printf("%d\n",argc); exit(0); }
EOF
eval $ac_link
# How can a shell script forward its arguments to another program?
#                                    $ * "$ *" "$ @"
# conftest.sh                         1    2     1 (*)
# conftest.sh foo                     2    2     2
# conftest.sh foo bar                 3    2     3
# conftest.sh "foo bar"               3    2     2
# (*): 2 with HP-UX /bin/sh. We must use /bin/ksh instead.
#      2 as well with NeXTstep /bin/sh. No /bin/ksh. Examine $# first.
psubs='"$''@"'
cat > conftest.sh <<EOF
#!/bin/sh
exec ./conftest $psubs
EOF
chmod a+x conftest.sh
if test `./conftest.sh` = "1"; then
  cl_cv_prog_sh_broken=no
  cl_cv_prog_sh_good='/bin/sh'
else
  cl_cv_prog_sh_broken=yes
  if test -x /bin/ksh; then
    cl_cv_prog_sh_good='/bin/ksh'
  else
    cl_cv_prog_sh_good=''
  fi
fi
else
cl_cv_prog_sh_broken="guessing no"
cl_cv_prog_sh_good='/bin/sh'
fi
rm -f conftest*
])
AC_MSG_RESULT($cl_cv_prog_sh_broken)
GOOD_SH="$cl_cv_prog_sh_good"
if test "$GOOD_SH" = '/bin/ksh'; then
  AC_DEFINE(UNIX_USE_KSH)
fi
if test "$GOOD_SH" = ''; then
  AC_DEFINE(UNIX_BROKEN_SH)
fi
AC_SUBST(GOOD_SH)dnl
])dnl
dnl
AC_DEFUN(CL_NOWARN,
[AC_REQUIRE([AC_PROG_CC])
if test $ac_cv_prog_gcc = yes; then
CL_COMPILE_CHECK([__nowarn__], cl_cv_c_nowarn,
[int x;], [__nowarn__ x;],
have_nowarn=1)
fi
if test -z "$have_nowarn"; then
AC_DEFINE(__nowarn__,)
fi
])dnl
dnl
AC_DEFUN(RL_VOID,
[CL_COMPILE_CHECK([working void], rl_cv_c_void, ,
[void f();
typedef void x; x g();
typedef void* y; y a;
], , AC_DEFINE(void,char))dnl
])dnl
dnl
AC_DEFUN(CL_VOID,
[CL_COMPILE_CHECK([working void], cl_cv_c_void, ,
[void f();
typedef void x; x g();
typedef void* y; y a;
], have_void=1, AC_DEFINE(void,char))dnl
if test -n "$have_void"; then
CL_COMPILE_CHECK([working \"return void\"], cl_cv_c_return_void,
[void f() {} typedef void x; x g() { return f(); }], [],
AC_DEFINE(return_void,[return]))dnl
fi
])dnl
dnl
AC_DEFUN(CL_LONGLONG,
[AC_MSG_CHECKING(for long long type)
AC_CACHE_VAL(cl_cv_c_longlong,[
AC_TRY_RUN([main()
{ long x = 944938507; long y = 737962842; long z = 162359677;
  exit(!(((long long) x)*((long long) y)>>32 == z)); }],
cl_cv_c_longlong=yes, cl_cv_c_longlong=no,
dnl When cross-compiling, don't assume anything.
cl_cv_c_longlong="guessing no")
])
AC_MSG_RESULT($cl_cv_c_longlong)
case "$cl_cv_c_longlong" in
  *yes) AC_DEFINE(HAVE_LONGLONG) ;;
  *no) ;;
esac
])dnl
dnl
AC_DEFUN(CL_STDC_HEADERS,
dnl This is AC_STDC_HEADERS from Autoconf 1.2. The AC_STDC_HEADERS from
dnl Autoconf 1.3 fails on 386BSD because it checks for correct ANSI ctype
dnl macros and 386BSD (as well as SGI's /bin/cc from Irix-4.0.5) doesn't
dnl have them. But we don't need them!
dnl The same holds for the mem* functions in <string.h> and SunOS.
[CL_CPP_CHECK([ANSI C header files], cl_cv_header_stdc,
[#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <float.h>
#include <limits.h>], AC_DEFINE(STDC_HEADERS))
])dnl
dnl
AC_DEFUN(CL_STDLIB_H,
[AC_CHECK_HEADERS(stdlib.h)]
)dnl
dnl
AC_DEFUN(CL_UNISTD_H,
[AC_CHECK_HEADERS(unistd.h)]
)dnl
dnl
AC_DEFUN(CL_OPENFLAGS,
dnl BSD systems require #include <sys/file.h> for O_RDWR etc. being defined.
[AC_BEFORE([$0], [CL_MMAP])
AC_CHECK_HEADERS(sys/file.h)
if test $ac_cv_header_sys_file_h = yes; then
openflags_decl='#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#include <fcntl.h>
'
openflags_prog='int x = O_RDWR | O_RDONLY | O_WRONLY | O_CREAT | O_TRUNC;'
CL_COMPILE_CHECK([O_RDWR in fcntl.h], cl_cv_decl_O_RDWR_fcntl_h,
$openflags_decl, $openflags_prog, openflags_ok=1)dnl
if test -z "$openflags_ok"; then
dnl CL_COMPILE_CHECK([O_RDWR in sys/file.h], cl_cv_decl_O_RDWR_sys_file_h,
$openflags_decl[#include <sys/file.h>], $openflags_prog,
AC_DEFINE(NEED_SYS_FILE_H)
dnl openflags_ok=1)dnl
fi
fi
])dnl
dnl
AC_DEFUN(CL_DIR_HEADER,
[dnl This is mostly copied from AC_DIR_HEADER, AC_HEADER_DIRENT, AC_FUNC_CLOSEDIR_VOID
dnl but not from AC_CHECK_HEADERS_DIRENT.
ac_header_dirent=no
for ac_hdr in dirent.h sys/ndir.h sys/dir.h ndir.h; do
  AC_CHECK_HEADER_DIRENT($ac_hdr, [ac_header_dirent=$ac_hdr; break])
done
case "$ac_header_dirent" in
dirent.h) AC_DEFINE(DIRENT) ;;
sys/ndir.h) AC_DEFINE(SYSNDIR) ;;
sys/dir.h) AC_DEFINE(SYSDIR) ;;
ndir.h) AC_DEFINE(NDIR) ;;
esac
# Two versions of opendir et al. are in -ldir and -lx on SCO Xenix.
if test $ac_header_dirent = dirent.h; then
AC_CHECK_LIB(dir, opendir, LIBS="$LIBS -ldir")
else
AC_CHECK_LIB(x, opendir, LIBS="$LIBS -lx")
fi
AC_MSG_CHECKING(for closedir return value)
AC_CACHE_VAL(ac_cv_func_closedir_void,[
AC_TRY_RUN([#include <sys/types.h>
#include <$ac_header_dirent>
int closedir(); main() { exit(closedir(opendir(".")) != 0); }],
ac_cv_func_closedir_void=no, ac_cv_func_closedir_void=yes,
# When cross-compiling, don't assume a return value.
ac_cv_func_closedir_void=yes
echo $ac_n "guessing $ac_c" 1>&AC_FD_MSG)])dnl
if test $ac_cv_func_closedir_void = yes; then
  AC_MSG_RESULT(void)
  AC_DEFINE(VOID_CLOSEDIR)
else
  AC_MSG_RESULT(int)
fi
])dnl
dnl
AC_DEFUN(CL_UTSNAME,
[CL_COMPILE_CHECK([sys/utsname.h and struct utsname], cl_cv_struct_utsname,
[#include <sys/utsname.h>],
[struct utsname u;], AC_DEFINE(HAVE_SYS_UTSNAME_H))dnl
])dnl
dnl
AC_DEFUN(CL_NETDB,
[AC_BEFORE([$0], [CL_GETHOSTBYNAME])
AC_CHECK_HEADERS(netdb.h)]
)dnl
dnl
AC_DEFUN(CL_SHM,
[AC_BEFORE([$0], [CL_SHMGET])dnl
AC_BEFORE([$0], [CL_SHMAT])dnl
AC_BEFORE([$0], [CL_SHMCTL])dnl
AC_BEFORE([$0], [CL_SHM_RMID])dnl
AC_CHECK_HEADERS(sys/shm.h)
if test $ac_cv_header_sys_shm_h = yes; then
AC_CHECK_HEADERS(sys/ipc.h)
if test $ac_cv_header_sys_ipc_h = yes; then
# This test is from Marcus Daniels
AC_MSG_CHECKING(for working shared memory)
AC_CACHE_VAL(cl_cv_sys_shm_works,[
AC_TRY_RUN([#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
/* try attaching a single segment to multiple addresses */
#define segsize 0x10000
#define attaches 128
#define base_addr 0x01000000
main ()
{ int shmid, i; char* addr; char* result;
  if ((shmid = shmget(IPC_PRIVATE,segsize,0400)) < 0) exit(1);
  for (i=0, addr = (char*)0x01000000; i<attaches; i++, addr += segsize)
    { if ((result = shmat(shmid,addr,SHM_RDONLY)) == (char*)(-1)) break; }
  for (i=0, addr = (char*)0x01000000; i<attaches; i++, addr += segsize)
    shmdt(addr);
  shmctl(shmid,IPC_RMID,0);
  exit(result == (char*)(-1));
}], cl_cv_sys_shm_works=yes, cl_cv_sys_shm_works=no,
dnl When cross-compiling, don't assume anything.
cl_cv_sys_shm_works="guessing no")
])
AC_MSG_RESULT($cl_cv_sys_shm_works)
fi
fi
case "$cl_cv_sys_shm_works" in
  *yes) have_shm=1
        AC_DEFINE(HAVE_SHM)
        AC_CHECK_HEADERS(sys/sysmacros.h)
        ;;
  *) ;;
esac
])dnl
dnl
AC_DEFUN(RL_TERM,
[AC_CHECK_HEADERS(termios.h termio.h sys/termio.h sgtty.h)dnl
if test $ac_cv_header_termios_h = yes; then
  dnl HAVE_TERMIOS_H defined
  AC_CHECK_FUNCS(tcgetattr tcflow)dnl
fi
AC_CHECK_HEADERS(sys/stream.h sys/ptem.h)dnl
ioctl_decl='#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#if defined(HAVE_TERMIOS_H) && defined(HAVE_TCGETATTR) && defined(HAVE_TCFLOW)
#include <termios.h>
#else
#if defined(HAVE_TERMIO_H) || defined(HAVE_SYS_TERMIO_H)
#ifdef HAVE_SYS_TERMIO_H
#include <sys/termio.h>
#else
#include <termio.h>
#endif
#else
#include <sgtty.h>
#include <sys/ioctl.h>
#endif
#endif
#ifdef HAVE_SYS_STREAM_H
#include <sys/stream.h>
#endif
#ifdef HAVE_SYS_PTEM_H
#include <sys/ptem.h>
#endif
'
ioctl_prog='int x = FIONREAD;'
CL_COMPILE_CHECK([FIONREAD], cl_cv_decl_FIONREAD_termio_h,
$ioctl_decl, $ioctl_prog, ioctl_ok=1)dnl
if test -z "$ioctl_ok"; then
CL_COMPILE_CHECK([FIONREAD in sys/filio.h], cl_cv_decl_FIONREAD_sys_filio_h,
$ioctl_decl[#include <sys/filio.h>], $ioctl_prog,
AC_DEFINE(NEED_SYS_FILIO_H)
ioctl_ok=1)dnl
fi
if test -z "$ioctl_ok"; then
CL_COMPILE_CHECK([FIONREAD in sys/ioctl.h], cl_cv_decl_FIONREAD_sys_ioctl_h,
$ioctl_decl[#include <sys/ioctl.h>], $ioctl_prog,
AC_DEFINE(NEED_SYS_IOCTL_H)
ioctl_ok=1)dnl
fi
])dnl
dnl
AC_DEFUN(CL_TERM,
[AC_BEFORE([$0], [CL_IOCTL])
AC_CHECK_HEADERS(termios.h termio.h sys/termio.h sgtty.h)dnl
if test $ac_cv_header_termios_h = yes; then
dnl HAVE_TERMIOS_H defined
dnl A/UX has <termios.h> but is lacking tcgetattr etc.
CL_LINK_CHECK([tcgetattr], cl_cv_func_tcgetattr,
[#include <termios.h>], [struct termios t; tcgetattr(0,&t);],
AC_DEFINE(HAVE_TCGETATTR))dnl
CL_LINK_CHECK([TCSAFLUSH in termios.h], cl_cv_decl_TCSAFLUSH,
[#include <termios.h>], [int x = TCSAFLUSH;],
AC_DEFINE(HAVE_TCSAFLUSH))dnl
fi
])dnl
dnl
AC_DEFUN(CL_CADDR_T,
[AC_MSG_CHECKING(for caddr_t in sys/types.h)
AC_CACHE_VAL(cl_cv_type_caddr_t,[
AC_EGREP_HEADER(caddr_t, sys/types.h,
cl_cv_type_caddr_t=yes, cl_cv_type_caddr_t=no)
])
AC_MSG_RESULT($cl_cv_type_caddr_t)
if test $cl_cv_type_caddr_t = yes; then
  AC_DEFINE(CADDR_T, caddr_t)
else
  AC_DEFINE(CADDR_T, void*)
fi
]
)dnl
dnl
AC_DEFUN(CL_CLOCK_T,
[AC_MSG_CHECKING(for clock_t in sys/types.h etc.)
AC_CACHE_VAL(cl_cv_type_clock_t,[
AC_EGREP_HEADER(clock_t, sys/types.h, have_clock=1)dnl
if test -z "$have_clock"; then
AC_EGREP_HEADER(clock_t, sys/times.h, have_clock=1)dnl
fi
if test -z "$have_clock"; then
AC_EGREP_HEADER(clock_t, time.h, have_clock=1)dnl
fi
if test -z "$have_clock"; then
  cl_cv_type_clock_t=no
else
  cl_cv_type_clock_t=yes
fi
])
AC_MSG_RESULT($cl_cv_type_clock_t)
if test $cl_cv_type_clock_t = yes; then
  AC_DEFINE(CLOCK_T, clock_t)
else
  AC_DEFINE(CLOCK_T, int)
fi
])dnl
dnl
AC_DEFUN(CL_DIRENT_WITHOUT_NAMLEN,
[CL_COMPILE_CHECK([d_namlen in struct dirent], cl_cv_struct_dirent_d_namlen,
[#include <dirent.h>], [struct dirent d; d.d_namlen;],
 , AC_DEFINE(DIRENT_WITHOUT_NAMLEN))]
)dnl
dnl
AC_DEFUN(CL_STRUCT_TM,
[AC_PROVIDE([$0])dnl
CL_COMPILE_CHECK([struct tm in sys/time.h], cl_cv_struct_tm_sys_time_h,
[#include <sys/types.h>
#include <sys/time.h>],
[struct tm *tp; tp->tm_sec;], AC_DEFINE(TM_IN_SYS_TIME))])dnl
dnl
AC_DEFUN(CL_STRLEN,
[
# This is a bit tricky since strlen is a gcc2 built-in function, and
# gcc's criterion when to reject a prototype for it is extremely mysterious.
#   extern int strlen (char * s); extern unsigned int strlen (char * s);
# produces an error, while
#   extern unsigned int strlen (char * s); extern int strlen (char * s);
# compiles well.
if test -z "$cl_cv_proto_strlen_macro"; then
AC_EGREP_CPP([is a macro], [#include <string.h>
#ifdef strlen
is a macro
#endif
], cl_cv_proto_strlen_macro=yes, cl_cv_proto_strlen_macro=no)
fi
if test $cl_cv_proto_strlen_macro = no; then
CL_PROTO([strlen], [
CL_PROTO_RET([#define strlen foo
#include <string.h>
], [int strlen();], cl_cv_proto_strlen_ret, int, size_t)
CL_PROTO_CONST([#define strlen foo
#include <string.h>
], [$cl_cv_proto_strlen_ret strlen (char* s);],
[$cl_cv_proto_strlen_ret strlen();], cl_cv_proto_strlen_arg1)],
[extern $cl_cv_proto_strlen_ret strlen ($cl_cv_proto_strlen_arg1 char*);])
AC_DEFINE_UNQUOTED(RETSTRLENTYPE,$cl_cv_proto_strlen_ret)
AC_DEFINE_UNQUOTED(STRLEN_CONST,$cl_cv_proto_strlen_arg1)
fi
])dnl
dnl
AC_DEFUN(CL_MEMSET,
[AC_CHECK_FUNCS(memset)])dnl
dnl
AC_DEFUN(CL_GMALLOC,
[dnl Invented by Franois Pinard <pinard@iro.umontreal.ca>
AC_MSG_CHECKING(for broken HP/UX and SunOS malloc)
AC_CACHE_VAL(cl_cv_func_malloc_broken,[
if test $cross_compiling = no; then
# Note that HP-UX has two different malloc() implementations.
# Both are broken. When used with CLISP, the one in the default libc.a
# leads to a SIGSEGV, the one in libmalloc.a leads to a SIGBUS.
# The SunOS 4.1.1 malloc() breaks when used by CLISP's generational GC.
os_name=`(uname -s) 2> /dev/null`
if test "$os_name" = HP-UX -o "$os_name" = SunOS ; then
cl_cv_func_malloc_broken=yes
else
cl_cv_func_malloc_broken=no
fi
else
cl_cv_func_malloc_broken="guessing no"
fi
])
AC_MSG_RESULT($cl_cv_func_malloc_broken)
case "$cl_cv_func_malloc_broken" in
  *yes) # Remedy: Use GNU malloc.
        GMALLOC=gmalloc ;;
  *no)  GMALLOC='' ;;
esac
AC_SUBST(GMALLOC)
])dnl
dnl
AC_DEFUN(CL_MALLOC,
[CL_PROTO([malloc], [
AC_EGREP_HEADER([void.*\*.*malloc], stdlib.h, malloc_void=1)dnl
if test -z "$malloc_void"; then
AC_TRY_COMPILE([
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
]AC_LANG_EXTERN[void* malloc();], [],
malloc_void=1)
fi
if test -n "$malloc_void"; then
cl_cv_proto_malloc_ret="void*"
else
cl_cv_proto_malloc_ret="char*"
fi
CL_PROTO_TRY([
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [$cl_cv_proto_malloc_ret malloc (unsigned int size);],
[$cl_cv_proto_malloc_ret malloc();],
cl_cv_proto_malloc_arg1="unsigned int", cl_cv_proto_malloc_arg1="size_t")
], [extern $cl_cv_proto_malloc_ret malloc ($cl_cv_proto_malloc_arg1);])
AC_DEFINE_UNQUOTED(RETMALLOCTYPE,$cl_cv_proto_malloc_ret)
AC_DEFINE_UNQUOTED(MALLOC_SIZE_T,$cl_cv_proto_malloc_arg1)
])dnl
dnl
AC_DEFUN(CL_FREE,
[CL_PROTO([free], [
CL_PROTO_RET([
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [int free();], cl_cv_proto_free_ret, int, void)],
[extern $cl_cv_proto_free_ret free ($cl_cv_proto_malloc_ret);])
AC_DEFINE_UNQUOTED(RETFREETYPE,$cl_cv_proto_free_ret)
])dnl
dnl
AC_DEFUN(CL_ALLOCA,
[# The Ultrix 4.2 mips builtin alloca declared by alloca.h only works
# for constant arguments.  Useless!
CL_LINK_CHECK(working alloca.h, cl_cv_header_alloca_h,
[#include <alloca.h>], [char *p = alloca(2 * sizeof(int));],
AC_DEFINE(HAVE_ALLOCA_H))dnl
decl="#ifdef __GNUC__
#define alloca __builtin_alloca
#else
#ifdef HAVE_ALLOCA_H
#include <alloca.h>
#else
#ifdef _AIX
 #pragma alloca
#else
char *alloca ();
#endif
#endif
#endif
"
CL_LINK_CHECK([alloca], cl_cv_func_alloca,
$decl, [char *p = (char *) alloca(1);],
 , [alloca_missing=1])dnl
if test -n "$alloca_missing"; then
  # The SVR3 libPW and SVR4 libucb both contain incompatible functions
  # that cause trouble.  Some versions do not even contain alloca or
  # contain a buggy version.  If you still want to use their alloca,
  # use ar to extract alloca.o from them instead of compiling alloca.c.
  ALLOCA=alloca.o
  AC_DEFINE(NO_ALLOCA)
fi
AC_SUBST(ALLOCA)dnl
])dnl
dnl
AC_DEFUN(CL_SETJMP,
[AC_CHECK_FUNC(_setjmp, , no__jmp=1)dnl
if test -z "$no__jmp"; then
AC_CHECK_FUNC(_longjmp, , no__jmp=1)dnl
fi
if test -z "$no__jmp"; then
AC_DEFINE(HAVE__JMP)
fi
AC_EGREP_HEADER([void.* longjmp], setjmp.h, , AC_DEFINE(LONGJMP_RETURNS))
])dnl
dnl
AC_DEFUN(RL_RETSIGTYPE,
[AC_MSG_CHECKING(return type of signal handlers)
CL_PROTO_RET(
[#include <sys/types.h>
#include <signal.h>
#ifdef signal
#undef signal
#endif
], [int (*signal ()) ();], cl_cv_proto_signal_ret, int, void)
AC_MSG_RESULT($cl_cv_proto_signal_ret)
AC_DEFINE_UNQUOTED(RETSIGTYPE,$cl_cv_proto_signal_ret)
if test $cl_cv_proto_signal_ret = void; then
  AC_DEFINE(RETSIGTYPE_VOID)
fi
])dnl
dnl
AC_DEFUN(CL_SIGNAL_REINSTALL,
[AC_MSG_CHECKING(whether signal handlers need to be reinstalled)
AC_CACHE_VAL(cl_cv_func_signal_reinstall,[
AC_TRY_RUN([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <signal.h>
/* volatile */ int gotsig=0;
RETSIGTYPE sigalrm_handler() { gotsig=1; }
int got_sig () { return gotsig; }
typedef RETSIGTYPE (*signal_handler) ();
main() { /* returns 0 if they need not to be reinstalled */
  signal(SIGALRM,(signal_handler)sigalrm_handler); alarm(1); while (!got_sig());
  exit(!( (signal_handler)signal(SIGALRM,(signal_handler)sigalrm_handler)
          == (signal_handler)sigalrm_handler
      ) );
}], cl_cv_func_signal_reinstall=no, cl_cv_func_signal_reinstall=yes,
dnl When cross-compiling, don't assume anything.
cl_cv_func_signal_reinstall="guessing yes")
])
AC_MSG_RESULT($cl_cv_func_signal_reinstall)
case "$cl_cv_func_signal_reinstall" in
  *yes) AC_DEFINE(SIGNAL_NEED_REINSTALL) ;;
  *no) ;;
esac
])dnl
dnl
AC_DEFUN(CL_SIGNALBLOCK,
[AC_BEFORE([$0], [CL_SIGNAL_UNBLOCK])AC_BEFORE([$0], [CL_SIGPROCMASK])dnl
signalblocks=""
AC_CHECK_FUNC(sighold, AC_DEFINE(SIGNALBLOCK_SYSV)
signalblocks="$signalblocks SystemV", )dnl
AC_EGREP_HEADER(sigset_t, signal.h, , signals_not_posix=1)dnl
if test -z "$signals_not_posix"; then
AC_CHECK_FUNC(sigprocmask, AC_DEFINE(SIGNALBLOCK_POSIX)
signalblocks="$signalblocks POSIX", )dnl
fi
AC_CHECK_FUNC(sigblock, AC_DEFINE(SIGNALBLOCK_BSD)
signalblocks="$signalblocks BSD", )dnl
AC_MSG_CHECKING(for signal blocking interfaces)
AC_CACHE_VAL(cl_cv_func_signalblocks, [
if test -z "$signalblocks"; then
  cl_cv_func_signalblocks="none"
else
  cl_cv_func_signalblocks=`echo $signalblocks`
fi
])
AC_MSG_RESULT($cl_cv_func_signalblocks)
])dnl
dnl
AC_DEFUN(CL_SIGNAL_UNBLOCK,
[AC_REQUIRE([CL_SIGNALBLOCK])dnl
case "$signalblocks" in
  *BSD*)
AC_MSG_CHECKING(whether signals are blocked when signal handlers are entered)
AC_CACHE_VAL(cl_cv_func_signal_blocked,[
AC_TRY_RUN([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <signal.h>
int gotsig=0;
int wasblocked=0;
typedef RETSIGTYPE (*signal_handler) ();
RETSIGTYPE sigalrm_handler()
{ gotsig=1;
#ifdef SIGNAL_NEED_REINSTALL
  signal(SIGALRM,(signal_handler)sigalrm_handler);
#endif
#ifdef SIGNALBLOCK_POSIX
  { sigset_t blocked;
    sigprocmask(SIG_BLOCK, (sigset_t *) 0, &blocked);
    wasblocked = sigismember(&blocked,SIGALRM) ? 1 : 0;
  }
#else
  wasblocked = ((sigblock(0) & sigmask(SIGALRM)) != 0);
#endif
}
int got_sig () { return gotsig; }
main() { /* returns 0 if they need not to be unblocked */
  signal(SIGALRM,(signal_handler)sigalrm_handler); alarm(1); while (!got_sig());
  exit(wasblocked);
}], cl_cv_func_signal_blocked=no, cl_cv_func_signal_blocked=yes,
dnl When cross-compiling, assume the worst case.
cl_cv_func_signal_blocked="guessing yes")
])
AC_MSG_RESULT($cl_cv_func_signal_blocked)
case "$cl_cv_func_signal_blocked" in
  *yes) AC_DEFINE(SIGNAL_NEED_UNBLOCK) ;;
  *no) ;;
esac
  ;;
  *) ;;
esac
])dnl
dnl
AC_DEFUN(CL_SIGPROCMASK,
[AC_REQUIRE([CL_SIGNALBLOCK])dnl
case "$signalblocks" in
  *POSIX*)
CL_PROTO([sigprocmask], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <signal.h>
], [int sigprocmask (int how, sigset_t* set, sigset_t* oset);],
[int sigprocmask();],
cl_cv_proto_sigprocmask_arg2)],
[extern int sigprocmask (int, $cl_cv_proto_sigprocmask_arg2 sigset_t*, sigset_t*);])
AC_DEFINE_UNQUOTED(SIGPROCMASK_CONST,$cl_cv_proto_sigprocmask_arg2)
  ;;
  *) ;;
esac
])dnl
dnl
AC_DEFUN(CL_SIGACTION,
[AC_BEFORE([$0], [CL_SIGINTERRUPT])
AC_CHECK_FUNC(sigaction, AC_DEFINE(HAVE_SIGACTION)
have_sigaction=1)])dnl
dnl
AC_DEFUN(CL_SIGINTERRUPT,
[AC_REQUIRE([CL_SIGACTION])dnl
AC_CHECK_FUNC(siginterrupt, AC_DEFINE(HAVE_SIGINTERRUPT)
have_siginterrupt=1)dnl
if test -z "$have_siginterrupt" -a -z "$have_sigaction"; then
AC_CHECK_FUNCS(sigvec)dnl
fi
])dnl
dnl
AC_DEFUN(CL_ABORT,
[CL_PROTO([abort], [
CL_PROTO_RET([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [int abort();], cl_cv_proto_abort_ret, int, void)
CL_PROTO_RET([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [$cl_cv_proto_abort_ret abort();], cl_cv_proto_abort_vol, [], [__volatile__])
], [extern $cl_cv_proto_abort_vol $cl_cv_proto_abort_ret abort (void);])
AC_DEFINE_UNQUOTED(RETABORTTYPE,$cl_cv_proto_abort_ret)
AC_DEFINE_UNQUOTED(ABORT_VOLATILE,$cl_cv_proto_abort_vol)
])dnl
dnl
AC_DEFUN(CL_SYS_ERRLIST,
[changequote(,)dnl
brackets='[]'
changequote([,])dnl
CL_PROTO([sys_errlist], [
AC_TRY_COMPILE([
/* Most systems declare sys_errlist in <errno.h>, NetBSD 1.0 in <stdio.h>. */
#include <stdio.h>
#include <errno.h>
extern char* sys_errlist $brackets ;
], [], cl_cv_proto_sys_errlist_const="", cl_cv_proto_sys_errlist_const="const")
], [extern $cl_cv_proto_sys_errlist_const char* $cl_cv_proto_sys_errlist_const sys_errlist$brackets;])
AC_DEFINE_UNQUOTED(SYS_ERRLIST_CONST,$cl_cv_proto_sys_errlist_const)
])dnl
dnl
AC_DEFUN(CL_GETENV,
[CL_PROTO([getenv], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [char* getenv (char* name);], [char* getenv();], cl_cv_proto_getenv_arg1)
], [extern char* getenv ($cl_cv_proto_getenv_arg1 char*);])
AC_DEFINE_UNQUOTED(GETENV_CONST,$cl_cv_proto_getenv_arg1)
])dnl
dnl
AC_DEFUN(CL_VFORK,
[CL_PROTO([vfork], [
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif
], [pid_t vfork (void);], [pid_t vfork();],
cl_cv_proto_vfork_ret="pid_t", cl_cv_proto_vfork_ret="int")
], [extern $cl_cv_proto_vfork_ret vfork (void);])
AC_DEFINE_UNQUOTED(RETVFORKTYPE,$cl_cv_proto_vfork_ret)
])dnl
dnl
AC_DEFUN(CL_SETSID,
[AC_CHECK_FUNCS(setsid setpgid)])dnl
dnl
AC_DEFUN(CL_EXECV,
[changequote(,)dnl
brackets='[]'
changequote([,])dnl
CL_PROTO([execv], [
for z in '' 'const'; do
for y in '' 'const'; do
for x in '' 'const'; do
if test -z "$have_execv"; then
AC_TRY_COMPILE([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
]AC_LANG_EXTERN[
#ifdef __STDC__
int execv ($x char* path, $y char* $z argv$brackets);
#else
int execv();
#endif
], [],
cl_cv_proto_execv_arg1="$x"
cl_cv_proto_execv_arg2a="$y"
cl_cv_proto_execv_arg2b="$z"
have_execv=1)
fi
done
done
done
], [extern int execv ($cl_cv_proto_execv_arg1 char*, $cl_cv_proto_execv_arg2a char* $cl_cv_proto_execv_arg2b$brackets);])
AC_DEFINE_UNQUOTED(EXECV_CONST,$cl_cv_proto_execv_arg1)
AC_DEFINE_UNQUOTED(EXECV1_CONST,$cl_cv_proto_execv_arg2a)
AC_DEFINE_UNQUOTED(EXECV2_CONST,$cl_cv_proto_execv_arg2b)
])dnl
dnl
AC_DEFUN(CL_EXECL,
[CL_PROTO([execl], [
for x in '' 'const'; do
if test -z "$have_execl"; then
AC_TRY_COMPILE([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
]AC_LANG_EXTERN[
#ifdef __STDC__
int execl (EXECV_CONST char* path, $x char* arg, ...);
#else
int execl();
#endif
], [], [[ dnl Mysteriously, we need to quote this twice because of the commas.
cl_cv_proto_execl_arg2="$x"
cl_cv_proto_execl_dots=yes
cl_cv_proto_execl_args="$cl_cv_proto_execv_arg1 char*, $cl_cv_proto_execl_arg2 char*, ..."
have_execl=1]])
fi
done
for x in '' 'const'; do
if test -z "$have_execl"; then
AC_TRY_COMPILE([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
]AC_LANG_EXTERN[
#ifdef __STDC__
int execl (EXECV_CONST char* path, $x char* arg0, $x char* arg1, $x char* arg2, $x char* arg3);
#else
int execl();
#endif
], [], [[ dnl Mysteriously, we need to quote this twice because of the commas.
cl_cv_proto_execl_arg2="$x"
cl_cv_proto_execl_dots=no
cl_cv_proto_execl_args="$cl_cv_proto_execv_arg1 char*, $cl_cv_proto_execl_arg2 char*, $cl_cv_proto_execl_arg2 char*, $cl_cv_proto_execl_arg2 char*, $cl_cv_proto_execl_arg2 char*"
have_execl=1]])
fi
done
], [extern int execl ($cl_cv_proto_execl_args);])
AC_DEFINE_UNQUOTED(EXECL_CONST,$cl_cv_proto_execl_arg2)
if test $cl_cv_proto_execl_dots = yes; then
  AC_DEFINE(EXECL_DOTS)
fi
])dnl
dnl
AC_DEFUN(CL_WAITPID,
[AC_CHECK_FUNCS(waitpid)
if test $ac_cv_func_waitpid = yes; then
CL_PROTO([waitpid], [
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [pid_t waitpid (pid_t pid, int* statusp, int options);],
[pid_t waitpid();],
cl_cv_proto_waitpid_arg1="pid_t", cl_cv_proto_waitpid_arg1="int")
], [extern pid_t waitpid ($cl_cv_proto_waitpid_arg1, int*, int);])
AC_DEFINE_UNQUOTED(PID_T,$cl_cv_proto_waitpid_arg1)
else
AC_CHECK_HEADERS(sys/wait.h)dnl
fi
])dnl
dnl
AC_DEFUN(CL_RUSAGE,
[AC_CHECK_HEADERS(sys/resource.h sys/times.h)dnl
if test $ac_cv_header_sys_resource_h = yes; then
  dnl HAVE_SYS_RESOURCE_H defined
  CL_COMPILE_CHECK([getrusage], cl_cv_func_getrusage,
[#include <sys/types.h> /* NetBSD 1.0 needs this */
#include <sys/time.h>
#include <sys/resource.h>],
    [struct rusage x; int y = RUSAGE_SELF; getrusage(y,&x); x.ru_utime.tv_sec;],
    AC_DEFINE(HAVE_GETRUSAGE))dnl
fi
])dnl
dnl
AC_DEFUN(CL_GETWD,
[AC_BEFORE([$0], [CL_GETCWD])
CL_LINK_CHECK([getwd], cl_cv_func_getwd, , [getwd();], AC_DEFINE(HAVE_GETWD),)]
)dnl
dnl
AC_DEFUN(CL_GETCWD,
[AC_REQUIRE([CL_GETWD])dnl
if test $cl_cv_func_getwd = no; then
dnl HAVE_GETWD undefined
CL_PROTO([getcwd], [
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [char* getcwd (char* buf, int bufsize);], [char* getcwd();],
cl_cv_proto_getcwd_arg2="int", cl_cv_proto_getcwd_arg2="size_t")
], [extern char* getcwd (char*, $cl_cv_proto_getcwd_arg2);])
AC_DEFINE_UNQUOTED(GETCWD_SIZE_T,$cl_cv_proto_getcwd_arg2)
fi
])dnl
dnl
AC_DEFUN(CL_CHDIR,
[CL_PROTO([chdir], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [int chdir (char* path);], [int chdir();], cl_cv_proto_chdir_arg1)
], [extern int chdir ($cl_cv_proto_chdir_arg1 char*);])
AC_DEFINE_UNQUOTED(CHDIR_CONST,$cl_cv_proto_chdir_arg1)
])dnl
dnl
AC_DEFUN(CL_MKDIR,
[CL_PROTO([mkdir], [
AC_EGREP_HEADER(mode_t, sys/types.h,
dnl mode_t defined. check if it is really used by mkdir() :
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
], [int mkdir (char* path, mode_t mode);], [int mkdir();], mode_t_unneeded=1, )
if test -z "$mode_t_unneeded"; then
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
], [int mkdir (const char* path, mode_t mode);], [int mkdir();], mode_t_unneeded=1, )
fi)dnl
if test -n "$mode_t_unneeded"; then
cl_cv_type_mode_t="mode_t"
else
cl_cv_type_mode_t="int"
fi
dnl Now MODE_T should be correct, check for const:
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
], [int mkdir (char* path, $cl_cv_type_mode_t mode);], [int mkdir();], cl_cv_proto_mkdir_arg1)
], [extern int mkdir ($cl_cv_proto_mkdir_arg1 char*, $cl_cv_type_mode_t);])
AC_DEFINE_UNQUOTED(MODE_T,$cl_cv_type_mode_t)
AC_DEFINE_UNQUOTED(MKDIR_CONST,$cl_cv_proto_mkdir_arg1)
])dnl
dnl
AC_DEFUN(CL_RMDIR,
[CL_PROTO([rmdir], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [int rmdir (char* path);], [int rmdir();], cl_cv_proto_rmdir_arg1)
], [extern int rmdir ($cl_cv_proto_rmdir_arg1 char*);])
AC_DEFINE_UNQUOTED(RMDIR_CONST,$cl_cv_proto_rmdir_arg1)
])dnl
dnl
AC_DEFUN(CL_STAT,
[CL_PROTO([stat], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
], [int stat (char* path, struct stat * buf);], [int stat();], cl_cv_proto_stat_arg1)
], [extern int stat ($cl_cv_proto_stat_arg1 char*, struct stat *);])
AC_DEFINE_UNQUOTED(STAT_CONST,$cl_cv_proto_stat_arg1)
])dnl
dnl
AC_DEFUN(CL_LSTAT,
[AC_CHECK_FUNCS(lstat)dnl
if test $ac_cv_func_lstat = yes; then
CL_PROTO([lstat], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
], [int lstat (char* path, struct stat * buf);], [int lstat();], cl_cv_proto_lstat_arg1)
], [extern int lstat ($cl_cv_proto_lstat_arg1 char*, struct stat *);])
AC_DEFINE_UNQUOTED(LSTAT_CONST,$cl_cv_proto_lstat_arg1)
fi
])dnl
dnl
AC_DEFUN(CL_READLINK,
[AC_CHECK_FUNCS(readlink)dnl
if test $ac_cv_func_readlink = yes; then
CL_PROTO([readlink], [
for z in 'int' 'size_t'; do
for y in 'char*' 'void*'; do
for x in '' 'const'; do
if test -z "$have_readlink"; then
AC_TRY_COMPILE([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
]AC_LANG_EXTERN[
#ifdef __STDC__
int readlink ($x char* path, $y buf, $z bufsiz);
#else
int readlink();
#endif
], [],
cl_cv_proto_readlink_arg1="$x"
cl_cv_proto_readlink_arg2="$y"
cl_cv_proto_readlink_arg3="$z"
have_readlink=1)
fi
done
done
done
], [extern int readlink ($cl_cv_proto_readlink_arg1 char*, $cl_cv_proto_readlink_arg2, $cl_cv_proto_readlink_arg3);])
AC_DEFINE_UNQUOTED(READLINK_CONST,$cl_cv_proto_readlink_arg1)
AC_DEFINE_UNQUOTED(READLINK_BUF_T,$cl_cv_proto_readlink_arg2)
AC_DEFINE_UNQUOTED(READLINK_SIZE_T,$cl_cv_proto_readlink_arg3)
fi
])dnl
dnl
AC_DEFUN(CL_ELOOP,
[AC_REQUIRE([AC_C_CROSS])dnl
AC_MSG_CHECKING(for ELOOP)
AC_CACHE_VAL(cl_cv_decl_eloop,[
if test $cross_compiling = no; then
cat > conftest.c <<EOF
#include "confdefs.h"
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <errno.h>
#include <stdio.h>
#ifdef ELOOP
main () { printf("ELOOP\n"); exit(0); }
#else
extern int errno;
#define foo "conflink"
#define foobar "conflink/somefile"
main()
{ /* If a system goes into an endless loop on this, it must be really broken. */
  if (symlink(foo,foo)<0) exit(1);
  if (unlink(foobar)>=0) { unlink(foo); exit(1); }
  printf("%d\n",errno); unlink(foo); exit(0);
}
#endif
EOF
eval $ac_link
cl_cv_decl_ELOOP=`./conftest`
if test "$cl_cv_decl_ELOOP" = "ELOOP"; then
  cl_cv_decl_eloop=yes
else
  cl_cv_decl_eloop="$cl_cv_decl_ELOOP"
fi
else
AC_EGREP_CPP(yes,[
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <errno.h>
#include <stdio.h>
#ifdef ELOOP
yes
#endif
],
cl_cv_decl_eloop=yes,
cl_cv_decl_eloop=no)
cl_cv_decl_ELOOP="ELOOP"
fi
rm -f conftest*
])
AC_MSG_RESULT($cl_cv_decl_eloop)
AC_DEFINE_UNQUOTED(ELOOP_VALUE,$cl_cv_decl_ELOOP)
])dnl
dnl
AC_DEFUN(CL_OPENDIR,
[CL_PROTO([opendir], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <$ac_header_dirent>
], [DIR* opendir (char* dirname);], [DIR* opendir();], cl_cv_proto_opendir_arg1)
], [extern DIR* opendir ($cl_cv_proto_opendir_arg1 char*);])
AC_DEFINE_UNQUOTED(OPENDIR_CONST,$cl_cv_proto_opendir_arg1)
])dnl
dnl
AC_DEFUN(CL_OPEN,
[CL_PROTO([open], [
for y in 'MODE_T mode' '...'; do
for x in '' 'const'; do
if test -z "$have_open"; then
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
], [int open ($x char* path, int flags, $y);], [int open();], [
cl_cv_proto_open_arg1="$x"
if test "$y" = "..."; then
cl_cv_proto_open_dots=yes
else
cl_cv_proto_open_dots=no
fi
have_open=1])
fi
done
done
[ dnl Mysteriously, we need to quote this once more because of the commas.
if test $cl_cv_proto_open_dots = yes; then
cl_cv_proto_open_args="$cl_cv_proto_open_arg1 char*, int, ..."
else
cl_cv_proto_open_args="$cl_cv_proto_open_arg1 char*, int, $cl_cv_type_mode_t"
fi
]], [extern int open ($cl_cv_proto_open_args);])
AC_DEFINE_UNQUOTED(OPEN_CONST,$cl_cv_proto_open_arg1)
if test $cl_cv_proto_open_dots = yes; then
AC_DEFINE(OPEN_DOTS)
fi
])dnl
dnl
AC_DEFUN(CL_READ_WRITE,
[CL_PROTO([read], [
CL_PROTO_RET([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [int read();], cl_cv_proto_retrwtype, int, long)
for y in 'int' 'size_t' "unsigned $cl_cv_proto_retrwtype" 'off_t'; do
for x in 'char*' 'void*'; do
if test -z "$have_rw"; then
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [$cl_cv_proto_retrwtype read (int fd, $x buf, $y count);],
[$cl_cv_proto_retrwtype read();], [
cl_cv_proto_rw_buf_t="$x"
cl_cv_proto_rw_size_t="$y"
have_rw=1])
fi
done
done
], [extern $cl_cv_proto_retrwtype read (int, $cl_cv_proto_rw_buf_t, $cl_cv_proto_rw_size_t);])
AC_DEFINE_UNQUOTED(RETRWTYPE,$cl_cv_proto_retrwtype)
AC_DEFINE_UNQUOTED(RW_BUF_T,$cl_cv_proto_rw_buf_t)
AC_DEFINE_UNQUOTED(RW_SIZE_T,$cl_cv_proto_rw_size_t)
])dnl
dnl
AC_DEFUN(CL_WRITE,
[CL_PROTO([write], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [$cl_cv_proto_retrwtype write (int fd, $cl_cv_proto_rw_buf_t buf, $cl_cv_proto_rw_size_t count);],
[$cl_cv_proto_retrwtype write();], cl_cv_proto_write_arg2)
], [extern $cl_cv_proto_retrwtype write (int, $cl_cv_proto_write_arg2 $cl_cv_proto_rw_buf_t, $cl_cv_proto_rw_size_t);])
AC_DEFINE_UNQUOTED(WRITE_CONST,$cl_cv_proto_write_arg2)
])dnl
dnl
dnl AC_DEFUN(CL_CHMOD,
dnl [CL_PROTO([chmod], [
dnl CL_PROTO_CONST([
dnl #ifdef STDC_HEADERS
dnl #include <stdlib.h>
dnl #endif
dnl #ifdef HAVE_UNISTD_H
dnl #include <unistd.h>
dnl #endif
dnl #include <sys/types.h>
dnl #include <sys/stat.h>
dnl ], [int chmod (char* path, mode_t mode);], [int chmod();],
dnl cl_cv_proto_chmod_arg1)
dnl ], [extern int chmod ($cl_cv_proto_chmod_arg1 char*, mode_t);])
dnl AC_DEFINE_UNQUOTED(CHMOD_CONST,$cl_cv_proto_chmod_arg1)
dnl AC_CHECK_FUNCS(fchmod)
dnl ])dnl
dnl dnl
AC_DEFUN(CL_RENAME,
[AC_CHECK_FUNCS(rename)dnl
if test $ac_cv_func_rename = yes; then
CL_PROTO([rename], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdio.h>
], [int rename (char* oldpath, char* newpath);], [int rename();],
cl_cv_proto_rename_arg1)
], [extern int rename ($cl_cv_proto_rename_arg1 char*, $cl_cv_proto_rename_arg1 char*);])
AC_DEFINE_UNQUOTED(RENAME_CONST,$cl_cv_proto_rename_arg1)
fi
])dnl
dnl
AC_DEFUN(CL_UNLINK,
[CL_PROTO([unlink], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [int unlink (char* path);], [int unlink();], cl_cv_proto_unlink_arg1)
], [extern int unlink ($cl_cv_proto_unlink_arg1 char*);])
AC_DEFINE_UNQUOTED(UNLINK_CONST,$cl_cv_proto_unlink_arg1)
])dnl
dnl
AC_DEFUN(CL_FSYNC,
[AC_CHECK_FUNCS(fsync)]
)dnl
dnl
AC_DEFUN(CL_IOCTL,
[AC_REQUIRE([CL_TERM])dnl
CL_PROTO([ioctl], [
ioctl_decl1='#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#ifndef HAVE_TCSAFLUSH
#undef HAVE_TERMIOS_H
#endif
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#else
#ifdef HAVE_SYS_TERMIO_H
#include <sys/termio.h>
#else
#ifdef HAVE_TERMIO_H
#include <termio.h>
#else
#ifdef HAVE_SGTTY_H
#include <sgtty.h>
#include <sys/ioctl.h>
#endif
#endif
#endif
#endif
'
dnl First find out whether this set of includes declares ioctl(), or whether
dnl we shall use <sys/ioctl.h> instead.
dnl Note: we must not include <sys/ioctl.h> deliberately since it is
dnl incompatible to <termios.h> (and doesn't even declare ioctl()) on SunOS 4.
AC_TRY_COMPILE($ioctl_decl1
AC_LANG_EXTERN[char* ioctl();], [], try_sys_ioctl=1, ioctl_decl="$ioctl_decl1")
if test -n "try_sys_ioctl"; then
ioctl_decl2='#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#include <sys/ioctl.h>
'
AC_TRY_COMPILE($ioctl_decl2
AC_LANG_EXTERN[char* ioctl();], [],
ioctl_decl="$ioctl_decl1", ioctl_decl="$ioctl_decl2")
fi
dnl Then find out about the correct ioctl declaration:
for y in 'caddr_t arg' '...'; do
for x in 'int' 'unsigned long' 'long'; do
if test -z "$have_ioctl"; then
CL_PROTO_TRY($ioctl_decl[
#ifdef INCLUDE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif
], [int ioctl (int fd, $x request, $y);], [int ioctl();],
[[[ dnl Mysteriously, we need to quote this three times because of the commas.
cl_cv_proto_ioctl_arg2="$x"
if test "$y" = "..."; then
cl_cv_proto_ioctl_dots=yes
cl_cv_proto_ioctl_args="int, $cl_cv_proto_ioctl_arg2, ..."
else
cl_cv_proto_ioctl_dots=no
cl_cv_proto_ioctl_args="int, $cl_cv_proto_ioctl_arg2, caddr_t"
fi
have_ioctl=1]]])
fi
done
done
], [extern int ioctl ($cl_cv_proto_ioctl_args);])
AC_DEFINE_UNQUOTED(IOCTL_REQUEST_T,$cl_cv_proto_ioctl_arg2)
if test $cl_cv_proto_ioctl_dots = yes; then
AC_DEFINE(IOCTL_DOTS)
fi
ioctl_decl="$ioctl_decl1"
ioctl_prog='int x = FIONREAD;'
CL_COMPILE_CHECK([FIONREAD], cl_cv_decl_FIONREAD_1,
$ioctl_decl, $ioctl_prog, ioctl_ok=1)dnl
if test -z "$ioctl_ok"; then
CL_COMPILE_CHECK([FIONREAD in sys/filio.h], cl_cv_decl_FIONREAD_1_sys_filio_h,
$ioctl_decl[#include <sys/filio.h>], $ioctl_prog,
AC_DEFINE(NEED_SYS_FILIO_H)
ioctl_ok=1)dnl
fi
if test -z "$ioctl_ok"; then
CL_COMPILE_CHECK([FIONREAD in sys/ioctl.h], cl_cv_decl_FIONREAD_1_sys_ioctl_h,
$ioctl_decl[#include <sys/ioctl.h>], $ioctl_prog,
AC_DEFINE(NEED_SYS_IOCTL_H)
ioctl_ok=1)dnl
fi
if test -n "$ioctl_ok"; then
AC_DEFINE(HAVE_FIONREAD)
fi
])dnl
dnl
AC_DEFUN(CL_FCNTL,
[CL_PROTO([fcntl], [
for x in 'int arg' '...'; do
if test -z "$have_fcntl"; then
CL_PROTO_TRY([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
], [int fcntl (int fd, int cmd, $x);], [int fcntl();], [
if test "$x" = "..."; then
cl_cv_fcntl_arg3="..."
else
cl_cv_fcntl_arg3="int"
fi
have_fcntl=1])
fi
done
], [extern int fcntl (int, int, $cl_cv_fcntl_arg3);])
if test "$cl_cv_fcntl_arg3" = "..."; then
AC_DEFINE(FCNTL_DOTS)
fi
])dnl
dnl
AC_DEFUN(RL_SELECT,
[AC_CHECK_FUNCS(select)dnl
if test $ac_cv_func_select = yes; then
AC_CHECK_HEADERS(sys/select.h)dnl
fi
])dnl
dnl
AC_DEFUN(CL_SELECT,
[AC_CHECK_FUNCS(select)dnl
if test $ac_cv_func_select = yes; then
AC_CHECK_HEADERS(sys/select.h)dnl
CL_PROTO([select], [
for z in '' 'const'; do
for y in 'fd_set' 'int' 'void'; do
for x in 'int' 'size_t'; do
if test -z "$have_select"; then
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
], [int select ($x width, $y * readfds, $y * writefds, $y * exceptfds, $z struct timeval * timeout);],
[int select();], [
cl_cv_proto_select_arg1="$x"
cl_cv_proto_select_arg2="$y"
cl_cv_proto_select_arg5="$z"
have_select=1])
fi
done
done
done
], [extern int select ($cl_cv_proto_select_arg1, $cl_cv_proto_select_arg2 *, $cl_cv_proto_select_arg2 *, $cl_cv_proto_select_arg2 *, $cl_cv_proto_select_arg5 struct timeval *);])
AC_DEFINE_UNQUOTED(SELECT_WIDTH_T,$cl_cv_proto_select_arg1)
AC_DEFINE_UNQUOTED(SELECT_SET_T,$cl_cv_proto_select_arg2)
AC_DEFINE_UNQUOTED(SELECT_CONST,$cl_cv_proto_select_arg5)
else
AC_CHECK_FUNCS(poll)dnl
fi
])dnl
dnl
AC_DEFUN(CL_UALARM,
[AC_CHECK_FUNCS(ualarm)]
)dnl
dnl
AC_DEFUN(CL_SETITIMER,
[AC_CHECK_FUNCS(setitimer)dnl
if test $ac_cv_func_setitimer = yes; then
CL_PROTO([setitimer], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/time.h>
], [int setitimer (int which, struct itimerval * ivalue, struct itimerval * ovalue);],
[int setitimer();], cl_cv_proto_setitimer_arg2)
], [extern int setitimer (int, $cl_cv_proto_setitimer_arg2 struct itimerval *, struct itimerval *);])
AC_DEFINE_UNQUOTED(SETITIMER_CONST,$cl_cv_proto_setitimer_arg2)
fi
])dnl
dnl
AC_DEFUN(CL_USLEEP,
[AC_CHECK_FUNCS(usleep)]
)dnl
dnl
AC_DEFUN(CL_LOCALTIME,
[CL_PROTO([localtime], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef TM_IN_SYS_TIME
#include <sys/time.h>
#else
#include <time.h>
#endif
], [struct tm * localtime (time_t* clock);], [struct tm * localtime();],
cl_cv_proto_localtime_arg1)
], [extern struct tm * localtime ($cl_cv_proto_localtime_arg1 time_t*);])
AC_DEFINE_UNQUOTED(LOCALTIME_CONST,$cl_cv_proto_localtime_arg1)
])dnl
dnl
AC_DEFUN(CL_GETTIMEOFDAY,
[AC_BEFORE([$0], [CL_TIMES_CLOCK])
AC_CHECK_FUNCS(gettimeofday)dnl
if test $ac_cv_func_gettimeofday = yes; then
dnl HAVE_GETTIMEOFDAY is defined
CL_PROTO([gettimeofday], [
CL_PROTO_TRY([
#include <sys/types.h>
#include <sys/time.h>
], [int gettimeofday (struct timeval * tp, struct timezone * tzp);],
[int gettimeofday();],
[[[ dnl Mysteriously, we need to quote this three times because of the commas.
cl_cv_proto_gettimeofday_dots=no
cl_cv_proto_gettimeofday_args="struct timeval *, struct timezone *"]]],
[[[ dnl Mysteriously, we need to quote this three times because of the commas.
cl_cv_proto_gettimeofday_dots=yes
cl_cv_proto_gettimeofday_args="struct timeval *, ..."]]])
], [extern int gettimeofday ($cl_cv_proto_gettimeofday_args);])
if test $cl_cv_proto_gettimeofday_dots = yes; then
AC_DEFINE(GETTIMEOFDAY_DOTS)
fi
fi
])dnl
dnl
AC_DEFUN(CL_FTIME,
[AC_BEFORE([$0], [CL_TIMES_CLOCK])
AC_CHECK_FUNCS(ftime)])dnl
dnl
AC_DEFUN(CL_TIMES_CLOCK,
[AC_REQUIRE([CL_GETTIMEOFDAY])dnl
AC_REQUIRE([CL_FTIME])dnl
if test $ac_cv_func_gettimeofday = no -a $ac_cv_func_ftime = no; then
AC_CHECK_FUNC(times, , no_times=1)dnl
if test -z "$no_times"; then
AC_MSG_CHECKING(for times return value)
AC_CACHE_VAL(cl_cv_func_times_return, [
AC_TRY_RUN([
#include <sys/types.h>
#include <time.h> /* needed for CLK_TCK */
#ifndef CLK_TCK
#include <sys/time.h> /* needed for CLK_TCK on SYSV PTX */
#endif
#include <sys/times.h>
main ()
{ struct tms buffer;
  clock_t result1;
  clock_t result2;
  int ticks;
  result1 = times(&buffer);
  if ((result1 == (clock_t)0) || (result1 == (clock_t)(-1))) exit(1);
  sleep(1);
  result2 = times(&buffer);
  if ((result2 == (clock_t)0) || (result2 == (clock_t)(-1))) exit(1);
  ticks = result2 - result1;
  exit(!((ticks >= CLK_TCK/2) && (ticks <= 3*CLK_TCK/2)));
}], cl_cv_func_times_return=yes, cl_cv_func_times_return=no,
dnl When cross-compiling, don't assume anything.
cl_cv_func_times_return="guessing no")
])
case "$cl_cv_func_times_return" in
  *yes) AC_DEFINE(HAVE_TIMES_CLOCK) ;;
  *no)  ;;
esac
fi
fi
])dnl
dnl
AC_DEFUN(CL_GETPWNAM,
[CL_PROTO([getpwnam], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <pwd.h>
], [struct passwd * getpwnam (char* name);], [struct passwd * getpwnam();],
cl_cv_proto_getpwnam_arg1)
], [extern struct passwd * getpwnam ($cl_cv_proto_getpwnam_arg1 char*);])
AC_DEFINE_UNQUOTED(GETPWNAM_CONST,$cl_cv_proto_getpwnam_arg1)
])dnl
dnl
AC_DEFUN(CL_GETPWUID,
[CL_PROTO([getpwuid], [
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <pwd.h>
], [struct passwd * getpwuid (uid_t uid);], [struct passwd * getpwuid();],
cl_cv_proto_getpwuid_arg1="uid_t", cl_cv_proto_getpwuid_arg1="int")
], [extern struct passwd * getpwuid ($cl_cv_proto_getpwuid_arg1);])
AC_DEFINE_UNQUOTED(GETPWUID_UID_T,$cl_cv_proto_getpwuid_arg1)
])dnl
dnl
AC_DEFUN(CL_GETHOSTNAME,
[AC_CHECK_FUNCS(gethostname)dnl
if test $ac_cv_func_gethostname = yes; then
CL_PROTO([gethostname], [
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [int gethostname (char* name, int namelen);], [int gethostname();],
cl_cv_proto_gethostname_arg2="int", cl_cv_proto_gethostname_arg2="size_t")
], [extern int gethostname (char*, $cl_cv_proto_gethostname_arg2);])
AC_DEFINE_UNQUOTED(GETHOSTNAME_SIZE_T,$cl_cv_proto_gethostname_arg2)
fi
])dnl
dnl
AC_DEFUN(CL_GETHOSTBYNAME,
[AC_REQUIRE([CL_NETDB])dnl
if test $ac_cv_header_netdb_h = yes; then
  have_netdb=1
else
  AC_CHECK_HEADER(sun/netdb.h, have_netdb=1)
fi
if test -n "$have_netdb"; then
AC_DEFINE(HAVE_GETHOSTBYNAME)
CL_PROTO([gethostbyname], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef HAVE_NETDB_H
#include <sys/socket.h>
#include <netdb.h>
#else
#include <sun/netdb.h>
#endif
], [struct hostent * gethostbyname (char* name);],
[struct hostent * gethostbyname();],
cl_cv_proto_gethostbyname_arg1)
], [extern struct hostent * gethostbyname ($cl_cv_proto_gethostbyname_arg1 char*);])
AC_DEFINE_UNQUOTED(GETHOSTBYNAME_CONST,$cl_cv_proto_gethostbyname_arg1)
fi
])dnl
dnl
AC_DEFUN(CL_CONNECT,
[CL_PROTO([connect], [
for x in '' 'const'; do
for y in 'struct sockaddr *' 'void*'; do
if test -z "$have_connect"; then
CL_PROTO_TRY([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
], [int connect (int fd, $x $y name, int namelen);], [int connect();], [
cl_cv_proto_connect_arg2a="$x"
cl_cv_proto_connect_arg2b="$y"
have_connect=1])
fi
done
done
], [extern int connect (int, $cl_cv_proto_connect_arg2a $cl_cv_proto_connect_arg2b, int);])
AC_DEFINE_UNQUOTED(CONNECT_CONST,$cl_cv_proto_connect_arg2a)
AC_DEFINE_UNQUOTED(CONNECT_NAME_T,$cl_cv_proto_connect_arg2b)
])dnl
dnl
AC_DEFUN(CL_UNIXCONN,
[AC_CHECK_HEADERS(sys/un.h)dnl
if test $ac_cv_header_sys_un_h = yes; then
CL_COMPILE_CHECK([sun_len in struct sockaddr_un], cl_cv_struct_sockaddr_sun_len,
[#include <sys/types.h> /* NetBSD 1.0 needs this */
#include <sys/un.h>],
[struct sockaddr_un unaddr; unaddr.sun_len;], AC_DEFINE(HAVE_SOCKADDR_UN_LEN))dnl
fi
])dnl
dnl
AC_DEFUN(CL_TCPCONN,
[AC_CHECK_HEADERS(netinet/in.h arpa/inet.h)dnl
CL_PROTO([inet_addr], [
CL_PROTO_TRY([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
], [struct in_addr inet_addr();], [struct in_addr inet_addr();], [
cl_cv_proto_inet_addr_ret="struct in_addr"
have_inet_addr=1])
if test -z "$have_inet_addr"; then
CL_PROTO_TRY([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
], [unsigned long inet_addr();], [unsigned long inet_addr();],
cl_cv_proto_inet_addr_ret="unsigned long", 
cl_cv_proto_inet_addr_ret="unsigned int")
fi
CL_PROTO_CONST([
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
], [$cl_cv_proto_inet_addr_ret inet_addr (char* cp);],
[$cl_cv_proto_inet_addr_ret inet_addr();], cl_cv_proto_inet_addr_arg1)
], [extern $cl_cv_proto_inet_addr_ret inet_addr ($cl_cv_proto_inet_addr_arg1 char*);])
AC_DEFINE_UNQUOTED(RET_INET_ADDR_TYPE,$cl_cv_proto_inet_addr_ret)
AC_DEFINE_UNQUOTED(INET_ADDR_CONST,$cl_cv_proto_inet_addr_arg1)
if test "$cl_cv_proto_inet_addr_ret" = "struct in_addr"; then
AC_DEFINE(INET_ADDR_SUFFIX,[.s_addr])
else
AC_DEFINE(INET_ADDR_SUFFIX,[])
fi
AC_CHECK_HEADERS(netinet/tcp.h)dnl
])dnl
dnl
AC_DEFUN(CL_GETPAGESIZE,
[AC_BEFORE([$0], [CL_MPROTECT])
CL_LINK_CHECK([getpagesize], cl_cv_func_getpagesize, , [getpagesize();],
AC_DEFINE(HAVE_GETPAGESIZE)
have_getpagesize=1)dnl
if test -n "$have_getpagesize"; then
CL_PROTO([getpagesize], [
CL_PROTO_RET([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
], [int getpagesize();], cl_cv_proto_getpagesize_ret, int, size_t)
], [extern $cl_cv_proto_getpagesize_ret getpagesize (void);])
AC_DEFINE_UNQUOTED(RETGETPAGESIZETYPE,$cl_cv_proto_getpagesize_ret)
fi
])dnl
dnl
AC_DEFUN(CL_VADVISE,
[CL_LINK_CHECK([vadvise], cl_cv_func_vadvise,
[#include <sys/vadvise.h>], [vadvise(0);],
AC_DEFINE(HAVE_VADVISE)dnl
)])dnl
dnl
AC_DEFUN(CL_MACH_VM,
[CL_LINK_CHECK([vm_allocate], cl_cv_func_vm,
 , [vm_allocate(); task_self();],
AC_DEFINE(HAVE_MACH_VM)dnl
)])dnl
dnl
AC_DEFUN(CL_MMAP,
[AC_REQUIRE([CL_OPENFLAGS])dnl
AC_BEFORE([$0], [CL_MUNMAP])AC_BEFORE([$0], [CL_MPROTECT])
AC_CHECK_HEADER(sys/mman.h, , no_mmap=1)dnl
if test -z "$no_mmap"; then
AC_CHECK_FUNC(mmap, , no_mmap=1)dnl
if test -z "$no_mmap"; then
AC_DEFINE(HAVE_MMAP)
CL_PROTO([mmap], [
# Note: gcc2 does not consider
#   void* mmap (void*, size_t, int, int, int, off_t);
#   char* mmap();
# to be an error, if the first declaration comes from a system include file.
CL_PROTO_RET([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/mman.h>
], [void* mmap();], cl_cv_proto_mmap_ret, [void*], [caddr_t])
for y in 'int' 'size_t'; do
for x in 'void*' 'caddr_t'; do
if test -z "$have_mmap_decl"; then
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/mman.h>
], [$cl_cv_proto_mmap_ret mmap ($x addr, $y length, int prot, int flags, int fd, off_t off);],
[$cl_cv_proto_mmap_ret mmap();], [
cl_cv_proto_mmap_arg1="$x"
cl_cv_proto_mmap_arg2="$y"
have_mmap_decl=1])
fi
done
done
], [extern $cl_cv_proto_mmap_ret mmap ($cl_cv_proto_mmap_arg1, $cl_cv_proto_mmap_arg2, int, int, int, off_t);])
AC_DEFINE_UNQUOTED(RETMMAPTYPE,$cl_cv_proto_mmap_ret)
AC_DEFINE_UNQUOTED(MMAP_ADDR_T,$cl_cv_proto_mmap_arg1)
AC_DEFINE_UNQUOTED(MMAP_SIZE_T,$cl_cv_proto_mmap_arg2)
AC_MSG_CHECKING(for working mmap)
AC_CACHE_VAL(cl_cv_func_mmap_works, [
mmap_prog_1='
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
#ifdef NEED_SYS_FILE_H
#include <sys/file.h>
#endif
#include <sys/types.h>
#include <sys/mman.h>
]AC_LANG_EXTERN[
#ifdef __STDC__
RETMMAPTYPE mmap (MMAP_ADDR_T addr, MMAP_SIZE_T length, int prot, int flags, int fd, off_t off);
#else
RETMMAPTYPE mmap();
#endif
main () {
'
mmap_prog_2='
#define my_shift 24
#define my_low   1
#ifdef FOR_SUN4_29
#define my_high  31
#define my_size  32768 /* hope that 32768 is a multiple of the page size */
/* i*32 KB for i=1..31 gives a total of 15.5 MB, which is close to what we need */
#else
#define my_high  64
#define my_size  8192 /* hope that 8192 is a multiple of the page size */
/* i*8 KB for i=1..64 gives a total of 16.25 MB, which is close to what we need */
#endif
 {long i;
  for (i=my_low; i<=my_high; i++)
    { caddr_t addr = (caddr_t)(i << my_shift);
#if 0 /* Check for 16 MB. */
      long size = i*my_size;
#else /* Check for 8 MB. This is more likely to work on Solaris 2. */
      long size = ((i+1)/2)*my_size;
#endif
      if (mmap(addr,size,PROT_READ|PROT_WRITE,flags|MAP_FIXED,fd,0) == (RETMMAPTYPE)-1) exit(1);
    }
#define x(i)  *(unsigned char *) ((i<<my_shift) + (i*i))
#define y(i)  (unsigned char)((3*i-4)*(7*i+3))
  for (i=my_low; i<=my_high; i++) { x(i) = y(i); }
  for (i=my_high; i>=my_low; i--) { if (x(i) != y(i)) exit(1); }
  exit(0);
}}
'
AC_TRY_RUN([$mmap_prog_1
  int flags = MAP_ANON | MAP_PRIVATE;
  int fd = -1;
$mmap_prog_2
], have_mmap_anon=1
cl_cv_func_mmap_anon=yes, rm -f core,
: # When cross-compiling, don't assume anything.
)
AC_TRY_RUN([$mmap_prog_1
  int flags = MAP_ANONYMOUS | MAP_PRIVATE;
  int fd = -1;
$mmap_prog_2
], have_mmap_anon=1
cl_cv_func_mmap_anonymous=yes, rm -f core,
: # When cross-compiling, don't assume anything.
)
AC_TRY_RUN([$mmap_prog_1
#ifndef MAP_FILE
#define MAP_FILE 0
#endif
  int flags = MAP_FILE | MAP_PRIVATE;
  int fd = open("/dev/zero",O_RDONLY,0666);
  if (fd<0) exit(1);
$mmap_prog_2
], have_mmap_devzero=1
cl_cv_func_mmap_devzero=yes, rm -f core
retry_mmap=1,
: # When cross-compiling, don't assume anything.
)
if test -n "$retry_mmap"; then
AC_TRY_RUN([#define FOR_SUN4_29
$mmap_prog_1
#ifndef MAP_FILE
#define MAP_FILE 0
#endif
  int flags = MAP_FILE | MAP_PRIVATE;
  int fd = open("/dev/zero",O_RDONLY,0666);
  if (fd<0) exit(1);
$mmap_prog_2
], have_mmap_devzero=1
cl_cv_func_mmap_devzero_sun4_29=yes, rm -f core,
: # When cross-compiling, don't assume anything.
)
fi
if test -n "$have_mmap_anon" -o -n "$have_mmap_devzero"; then
cl_cv_func_mmap_works=yes
else
cl_cv_func_mmap_works=no
fi
])
AC_MSG_RESULT($cl_cv_func_mmap_works)
if test "$cl_cv_func_mmap_anon" = yes; then
AC_DEFINE(HAVE_MMAP_ANON)
fi
if test "$cl_cv_func_mmap_anonymous" = yes; then
AC_DEFINE(HAVE_MMAP_ANONYMOUS)
fi
if test "$cl_cv_func_mmap_devzero" = yes; then
AC_DEFINE(HAVE_MMAP_DEVZERO)
fi
if test "$cl_cv_func_mmap_devzero_sun4_29" = yes; then
AC_DEFINE(HAVE_MMAP_DEVZERO_SUN4_29)
fi
fi
fi
])dnl
dnl
AC_DEFUN(CL_MUNMAP,
[AC_REQUIRE([CL_MMAP])dnl
if test -z "$no_mmap"; then
AC_CHECK_FUNCS(munmap)dnl
fi
])dnl
dnl
AC_DEFUN(CL_MPROTECT,
[AC_REQUIRE([CL_GETPAGESIZE])dnl
AC_REQUIRE([CL_MMAP])dnl
AC_CHECK_FUNCS(mprotect)dnl
if test $ac_cv_func_mprotect = yes; then
CL_PROTO([mprotect], [
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/mman.h>
], [int mprotect (MMAP_ADDR_T addr, MMAP_SIZE_T len, int prot);],
[int mprotect();], cl_cv_proto_mprotect_arg1)
], [extern int mprotect ($cl_cv_proto_mprotect_arg1 $cl_cv_proto_mmap_arg1, $cl_cv_proto_mmap_arg2, int);])
AC_DEFINE_UNQUOTED(MPROTECT_CONST,$cl_cv_proto_mprotect_arg1)
AC_MSG_CHECKING(for working mprotect)
AC_CACHE_VAL(cl_cv_func_mprotect_works, [
mprotect_prog='
#include <sys/types.h>
/* declare malloc() */
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifndef malloc
]AC_LANG_EXTERN[
#ifdef __STDC__
RETMALLOCTYPE malloc (MALLOC_SIZE_T size);
#else
RETMALLOCTYPE malloc();
#endif
#endif
/* declare getpagesize() and mprotect() */
#include <sys/mman.h>
#ifndef HAVE_GETPAGESIZE
#include <sys/param.h>
#define getpagesize() PAGESIZE
#else
]AC_LANG_EXTERN[
#ifdef __STDC__
RETGETPAGESIZETYPE getpagesize (void);
#else
RETGETPAGESIZETYPE getpagesize();
#endif
#endif
]AC_LANG_EXTERN[
#ifdef __STDC__
int mprotect (MPROTECT_CONST MMAP_ADDR_T addr, MMAP_SIZE_T len, int prot);
#else
int mprotect();
#endif
char foo;
main () {
  unsigned long pagesize = getpagesize();
#define page_align(address)  (char*)((unsigned long)(address) & -pagesize)
'
AC_TRY_RUN([$mprotect_prog
  if ((pagesize-1) & pagesize) exit(1);
  exit(0); }], , no_mprotect=1,
# When cross-compiling, don't assume anything.
no_mprotect=1)
mprotect_prog="$mprotect_prog"'
  char* area = malloc(6*pagesize);
  char* fault_address = area + pagesize*7/2;
'
if test -z "$no_mprotect"; then
AC_TRY_RUN([$mprotect_prog
  if (mprotect(page_align(fault_address),pagesize,PROT_NONE) < 0) exit(0);
  foo = *fault_address; /* this should cause a core dump */
  exit(0); }],
  no_mprotect=1, rm -f core,
: # When cross-compiling, don't assume anything.
)
fi
if test -z "$no_mprotect"; then
AC_TRY_RUN([$mprotect_prog
  if (mprotect(page_align(fault_address),pagesize,PROT_NONE) < 0) exit(0);
  *fault_address = 'z'; /* this should cause a core dump */
  exit(0); }],
  no_mprotect=1, rm -f core,
: # When cross-compiling, don't assume anything.
)
fi
if test -z "$no_mprotect"; then
AC_TRY_RUN([$mprotect_prog
  if (mprotect(page_align(fault_address),pagesize,PROT_READ) < 0) exit(0);
  *fault_address = 'z'; /* this should cause a core dump */
  exit(0); }],
  no_mprotect=1, rm -f core,
: # When cross-compiling, don't assume anything.
)
fi
if test -z "$no_mprotect"; then
AC_TRY_RUN([$mprotect_prog
  if (mprotect(page_align(fault_address),pagesize,PROT_READ) < 0) exit(1);
  if (mprotect(page_align(fault_address),pagesize,PROT_READ|PROT_WRITE) < 0) exit(1);
  *fault_address = 'z'; /* this should not cause a core dump */
  exit(0); }], , no_mprotect=1
rm -f core,
: # When cross-compiling, don't assume anything.
)
fi
if test -z "$no_mprotect"; then
  cl_cv_func_mprotect_works=yes
else
  cl_cv_func_mprotect_works=no
fi
])
AC_MSG_RESULT($cl_cv_func_mprotect_works)
if test $cl_cv_func_mprotect_works = yes; then
  AC_DEFINE(HAVE_WORKING_MPROTECT)
fi
fi
])dnl
dnl
AC_DEFUN(CL_SHMGET,
[AC_REQUIRE([CL_SHM])dnl
if test -n "$have_shm"; then
CL_PROTO([shmget], [
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
], [int shmget (key_t key, int size, int shmflg);], [int shmget();],
cl_cv_proto_shmget_arg2="int", cl_cv_proto_shmget_arg2="size_t")
], [extern int shmget (key_t, $cl_cv_proto_shmget_arg2, int);])
AC_DEFINE_UNQUOTED(SHMGET_SIZE_T,$cl_cv_proto_shmget_arg2)
fi
])dnl
dnl
AC_DEFUN(CL_SHMAT,
[AC_REQUIRE([CL_SHM])dnl
if test -n "$have_shm"; then
CL_PROTO([shmat], [
CL_PROTO_RET([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
], [void* shmat();],
cl_cv_proto_shmat_ret, [void*], [char*])
CL_PROTO_CONST([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
], [$cl_cv_proto_shmat_ret shmat (int shmid, $cl_cv_proto_shmat_ret shmaddr, int shmflg);],
[$cl_cv_proto_shmat_ret shmat();], cl_cv_proto_shmat_arg2)
], [extern $retshmattype shmat (int, $cl_cv_proto_shmat_arg2 $cl_cv_proto_shmat_ret, int);])
AC_DEFINE_UNQUOTED(RETSHMATTYPE,$cl_cv_proto_shmat_ret)
AC_DEFINE_UNQUOTED(SHMAT_CONST,$cl_cv_proto_shmat_arg2)
fi
])dnl
dnl
AC_DEFUN(CL_SHMCTL,
[AC_REQUIRE([CL_SHM])dnl
if test -n "$have_shm"; then
CL_PROTO([shmctl], [
CL_PROTO_TRY([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
], [int shmctl (int shmid, int cmd, struct shmid_ds * buf);], [int shmctl();],
[[[ dnl Mysteriously, we need to quote this three times because of the commas.
cl_cv_proto_shmctl_dots=no
cl_cv_proto_shmctl_args="int, int, struct shmid_ds *"]]],
[[[ dnl Mysteriously, we need to quote this three times because of the commas.
cl_cv_proto_shmctl_dots=yes
cl_cv_proto_shmctl_args="int, int, ..."]]])
], [extern int shmctl ($cl_cv_proto_shmctl_args);])
if test $cl_cv_proto_shmctl_dots = yes; then
  AC_DEFINE(SHMCTL_DOTS)
fi
fi
])dnl
dnl
AC_DEFUN(CL_SHM_RMID,
[AC_REQUIRE([CL_SHM])dnl
if test -n "$have_shm"; then
AC_MSG_CHECKING(for attachability of removed shared memory)
AC_CACHE_VAL(cl_cv_func_shmctl_attachable, [
AC_TRY_RUN([
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#ifdef HAVE_SYS_SYSMACROS_H
#include <sys/sysmacros.h>
#endif
#ifdef __STDC__
]AC_LANG_EXTERN[int shmget (key_t key, SHMGET_SIZE_T size, int shmflg);
]AC_LANG_EXTERN[RETSHMATTYPE shmat (int shmid, SHMAT_CONST RETSHMATTYPE shmaddr, int shmflg);
]AC_LANG_EXTERN[
#ifdef SHMCTL_DOTS
int shmctl (int shmid, int cmd, ...);
#else
int shmctl (int shmid, int cmd, struct shmid_ds * buf);
#endif
#else
extern int shmget();
extern RETSHMATTYPE shmat();
extern int shmctl();
#endif
main ()
{ unsigned int pagesize = 8192; /* should be a multiple of SHMLBA */
  unsigned long addr = (unsigned long) malloc(2*pagesize);
  addr += pagesize-1; addr = (addr/pagesize)*pagesize;
 {unsigned long addr1 = addr + 0x10000;
  unsigned long addr2 = addr + 0x20000;
  int id = shmget(IPC_PRIVATE,pagesize,IPC_CREAT|0600);
  if (id<0)
    { exit(1); }
  if (shmat(id,(RETSHMATTYPE)addr1,0) == (RETSHMATTYPE)(-1))
    { shmctl(id,IPC_RMID,NULL); exit(1); }
  if (shmctl(id,IPC_RMID,NULL) < 0)
    { exit(1); }
  if (shmat(id,(RETSHMATTYPE)addr2,0) == (RETSHMATTYPE)(-1))
    { shmctl(id,IPC_RMID,NULL); exit(1); }
  shmctl(id,IPC_RMID,NULL);
  exit(0);
}}
], cl_cv_func_shmctl_attachable=yes, cl_cv_func_shmctl_attachable=no,
dnl When cross-compiling, don't assume anything.
cl_cv_func_shmctl_attachable="guessing no")
])
AC_MSG_RESULT($cl_cv_func_shmctl_attachable)
case "$cl_cv_func_shmctl_attachable" in
  *yes) AC_DEFINE(SHM_RMID_VALID) ;;
  *no)  ;;
esac
fi
])dnl
dnl
AC_DEFUN(CL_CHAR_UNSIGNED,
[dnl This is mostly copied from AC_C_CHAR_UNSIGNED.
AC_MSG_CHECKING(whether characters are unsigned)
AC_CACHE_VAL(ac_cv_c_char_unsigned,[
if test $ac_cv_prog_gcc = yes; then
  # GCC predefines this symbol on systems where it applies.
AC_EGREP_CPP(yes,
[#ifdef __CHAR_UNSIGNED__
  yes
#endif
], ac_cv_c_char_unsigned=yes, ac_cv_c_char_unsigned=no)
else
AC_TRY_RUN(
[/* volatile prevents gcc2 from optimizing the test away on sparcs.  */
#if !defined(__STDC__) || __STDC__ != 1
#define volatile
#endif
main() {
  volatile char c = 255; exit(c < 0);
}], ac_cv_c_char_unsigned=yes, ac_cv_c_char_unsigned=no,
ac_cv_c_char_unsigned="guessing no")
fi])dnl
AC_MSG_RESULT($ac_cv_c_char_unsigned)
if test $ac_cv_prog_gcc = no; then
  # GCC defines __CHAR_UNSIGNED__ by itself, no need to fix up.
  case "$ac_cv_c_char_unsigned" in
    *yes) AC_DEFINE(__CHAR_UNSIGNED__) ;;
    *no) ;;
  esac
fi
])
AC_DEFUN(CL_MACHINE,
[AC_REQUIRE([AC_C_CROSS])dnl
if test $cross_compiling = no; then
if test -z "$cl_cv_file_machine_h"; then
echo checking for integer types and behaviour
cat > conftest.c <<EOF
#include "confdefs.h"
EOF
cat ${srcdir}/machine.c >> conftest.c
ORIGCC="$CC"
if test $ac_cv_prog_gcc = yes; then
# gcc -O (gcc version <= 2.3.2) crashes when compiling long long shifts for
# target 80386. Strip "-O".
CC=`echo "$CC " | sed -e 's/-O //g'`
fi
eval $ac_link
CC="$ORIGCC"
if test -s conftest; then
  echo creating machine.h
  ./conftest > conftest.h
  if cmp -s machine.h conftest.h 2>/dev/null; then
    # The file exists and we would not be changing it
    rm -f conftest.h
  else
    rm -f machine.h
    mv conftest.h machine.h
  fi
  cl_cv_file_machine_h=1
else
  echo creation of machine.h failed
fi
rm -f conftest*
fi
else
echo cross-compiling - cannot create machine.h
fi
])dnl
dnl
AC_DEFUN(CL_WORDS_LITTLEENDIAN,
[AC_MSG_CHECKING(byte ordering)
AC_CHECK_VAL(cl_cv_sys_endian, [
AC_TRY_RUN([main () {
  /* Are we little or big endian?  From Harbison&Steele.  */
  union
  {
    long l;
    char c[sizeof (long)];
  } u;
  u.l = 1;
  exit (u.c[0] == 1);
}],
cl_cv_sys_endian=big,
cl_cv_sys_endian=little,
# must guess the endianness
)
if test -z "$cl_cv_sys_endian"; then
AC_EGREP_CPP(yes,[#if defined(m68k) || defined(mc68000) || defined(mc68020) || defined(sparc) || defined(MIPSEB) || defined(hppa) || defined(__hppa) || defined(m88000)
  yes
#endif
], cl_cv_sys_endian=big)
fi
if test -z "$cl_cv_sys_endian"; then
AC_EGREP_CPP(yes,[#if defined(i386) || defined(__i386) || defined(_I386) || defined(MIPSEL) || defined(__alpha)
  yes
#endif
], cl_cv_sys_endian=little)
fi
if test -z "$cl_cv_sys_endian"; then
cl_cv_sys_endian="guessing little"
fi
])
AC_MSG_RESULT([$cl_cv_sys_endian endian])
case "$cl_cv_sys_endian" in
  *little) AC_DEFINE(WORDS_LITTLEENDIAN) ;;
  *big)    ;;
esac
])dnl
dnl
