%%
%%  Miscellaneous functions
%%

%%
%%  atrim:  trims all whitespace around point
%%
. ( trim
.   eolp {
.         bolp { 1 left pop 
.                what_column trim what_column -
. 	       {1 right pop } !if
. 	     }
. 	 !if
.        }
.   !if
. ) atrim



%%
%%  A common problem:  I like 4 column tabs but my printer insists on 8
%%		       column tabs.  How do I keep 8 column tabs but make
%%		       the tab key simulate 4 column tabs?
%%  Solution:

. 8 =TAB               %% tabs set at 8 characters
. [MYTAB] 4 =MYTAB     %% a new global variable

. ( [c goal] what_column =c
.   c 1 -
.   MYTAB / 1 +
.   MYTAB * 1 + =goal
.   goal c - whitespace
  %%
  %% Now fixup any multiple spaces. Not needed but reduces file size.
  %%
.   skip_white what_column 
.   atrim
.   what_column - whitespace
.   goal goto_column
. ) my_tab_cmd      "my_tab_cmd"  "^I" setkey  %% function bound to tab key

. (
.    [ch]  "}" =ch

.    ch insert
.    indent_line
.    1 left pop del
.    0 update
.    ch int =LAST_CHAR self_ins
.    newline newline indent_line
. ) my_ket_cmd "my_ket_cmd" "}" setkey

   
%% This is something that a user on the gnu.emac.help newsgroup requested.
%% It binds the '}' such that it also generates a comment indicating 
%% what it closes.

. (  
.    "brace_ket_cmd" call   %% inserts brace
.    push_spot
.    "}" bsearch pop
.    push_spot
.    "goto_match" call
.    "\t\n a-zA-Z0-9" bskip_chars
.    1 left pop
.    ")" looking_at 
.      {
.         "goto_match" call bol skip_white
. 	push_mark eol " \t" bskip_chars bufsubstr
. 	pop_spot 1 right pop " /* " insert insert " */" insert
.      }
.      {pop_spot}
.    else
   
.    pop_spot
. ) test  "test"  "}"  setkey
