'\"
'\" Copyright 1994 by AT&T Bell Laboratories.
'\"
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\"
.so man.macros
.HS extension cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
extension \- dynamically load extensions as shared libraries
.SH SYNOPSIS
.sp
\fBextension add \fIname\fR ?\fIname\fR...?
.sp
\fBextension libs\fR
.sp
\fBextension lload \fIlibrary\fR
.sp
\fBextension linit \fIinitProc\fR
.BE
.SH DESCRIPTION
.PP
The \fBextension\fR command allows one to load extensions as shared
libraries for Tcl. 
.SH COMMAND OPTIONS
The following options are available for the \fBextension\fR command:
.TP
\fBextension add\fR ?\fIname\fR?...
Adds the extension \fIname\fR to the current process.  \fIName\fR.
must be an entry in the global associative array \fBtcl_extensions\fR.
If an entry for \fIname\fR doesn't exist or the variable \fBtcl_extensions\fR
doesn't exist, an error message is returned.
This command returns the empty string.  
.TP
\fBextension libs\fR
Lists the pathnames of the libraries currently loaded.
.TP
\fBextension linit \fIinitProc\fR
Calls the C function \fIinitProc\fR to initialize an extension.
\fIInitProc\fR must be a valid entry point in a library that
has already been loaded (see the \fBlload\fR option).
This command returns the empty string.
.TP
\fBextension lload \fIlibrary\fR 
Loads the shared library \fIlibrary\fR into the current process.
If the library has already been loaded, it will not be loaded again.
This command returns the empty string.
.SH EXTENSIONS FILE
The first time the \fBextension\fR command is run it tries to source 
the file "[tcl library]/extensions.tcl".  This file can be used to 
specify the extensions available and their respective libraries.
You can always use the low-level commands to load a library too.
.PP
This file sets two global variables which the \fBextension\fR command 
uses to find shared libraries.
.PP
The first is an associative array \fCtcl_extensions\fR.  This array
maps an extension name (such as "blt") with the proper initialization
routine and shared libraries.
.DS
\fCset tcl_extensions(blt) { Blt_Init libBLT.so.1.7 }\fR
.DE
The second variable is \fCtcl_extloadpath\fR.  This variable is a list
of directories to search for the library.  
.DS
\fCset tcl_extloadpath { 
    /usr/local/tcl/extensions/lib 
    /usr/local/lib 
}\fR
.DE
.PP
By default, the "extension" command looks for the file 
"[tcl library]/extensions.tcl".  But you can override this by 
setting the environment variable \fCTCL_EXTMAP\fR.  
.DS
\fCset env(TCL_EXTMAP) /u/mydir/my_extensions.tcl\fR
.DE
.SH SYSTEMS
The \fBextension\fR command has been tested on HP-UX, SunOS 4.x, and
SunOS 5.x.  It should work also on ISIX 5.x, OSF1.
.SH KEYWORDS
extension
