.TH Deck 3I "13 December 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Deck \- a stack of interactors on top of each other
.SH SYNOPSIS
.B #include <InterViews/deck.h>
.SH DESCRIPTION
A deck is a scene containing interactors that are conceptually stacked on
top of each other.  Only one interactor is visible at a time.  A deck
is useful to implement ``paging'' through a document, or where only one of
several similar components should be visible at a time, as in applications
using alternate tool pallets or menus with alternate entries.
.PP
A deck will try to stretch or shrink the visible interactor to fill the total
space.  The natural size of a deck is the maximum of its components.
.PP
A deck uses its \fIperspective\fP to specify which component is visible.
The components are numbered in the order in which they are inserted into the
deck, starting with one.  A scroller or other
interactor which operates on the perspective can be used to allow a user to
specify the component to view.  Either horizontal or vertical scrolling can
be used.
.SH PUBLIC OPERATIONS
.TP
.B "Deck()"
Construct a new deck.
.TP
.B "void Insert(Interactor*)"
Add an interactor to the deck.
.TP
.B "void Change(Interactor*)"
Notify the deck that an interactor's shape has changed.
If propagation is on,
the deck recomputes its own shape and notifies its parent.
.TP
.B "void Remove(Interactor*)"
Take an interactor out of a deck.
.TP
.B "void Flip(int count = 1)"
.ns
.TP
.B "void FlipTo(int position)"
.ns
.TP
.B "void Top()"
.ns
.TP
.B "void Bottom()"
Perform operations on the perspective to specify the component to view.
Flip specifies the component relative to the current component.  A positive
value of \fIcount\fP specifies a component nearer to the ``bottom'' of
the deck (the components inserted last), and a negative value specifies a
component nearer to the ``top''.  FlipTo specifies a component by its
absolute position in the deck.  A positive value of \fIposition\fP specifies
a position from the top, starting at 1.  A negative value specifies a
position from the bottom, starting at -1.  Top and Bottom are equivalent to
FlipTo(1) and FlipTo(-1) respectively.
.SH SEE ALSO
Interactor(3I), Scene(3I), Shape(3I)
