#!./wish -f

#
# Test program for the addinput and remove input commands.  Runs a shell script
# that outputs the data every minute.
#

global generateInputError
set generateInputError 0

#
# Create the list box, return the path of the listbox.
#
proc CreateListBox {} {
    wm title . "addinput test"
    wm iconname . "Addinput"
    message .msg -font -Adobe-courier-medium-r-normal--*-180* -aspect 300 \
            -text "A process has started in the background that creates output every second for 15 seconds.  Each line of output is displayed in this list box."

    frame .frame -borderwidth 10

    scrollbar .frame.scroll -relief sunken -command ".frame.list yview"
    listbox .frame.list -yscroll ".frame.scroll set" -relief sunken \
       -geometry 30x10

    pack append .frame .frame.scroll {right expand filly frame w} \
      .frame.list {left expand filly frame e}

    button .error -text "Generate Error" -command {set generateInputError 1}
    button .close -text "Permature Close (will hang for a few seconds)" \
        -command {close $inputFile}
    button .exit -text Exit -command "destroy ."
    pack append . .msg {top fill} .frame {top expand fill} \
         .exit {bottom fill} .error {bottom fill} .close {bottom fill}
    return .frame.list
}

#
# Input file callback.
#
proc FileInput {token events fileid} {
    global listBox generateInputError

    if $generateInputError {
        error "Error generated for testing purposes"
    }
    if {"$events" != "READ"} {
        error "Unexpected events: $events"
    }
    if {[gets $fileid line] < 0} {
        removeinput $fileid
        set line "That's all folks"
    }
    $listBox insert end $line
}

global listBox
set listBox [CreateListBox]
set inputFile [open "| sh addinput.sh"]

addinput $inputFile "FileInput %% %E %F"
