'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/tkwait.n,v 1.5 93/10/18 08:32:09 ouster Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS tkwait tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tkwait \- Wait for variable to change or window to be destroyed
.SH SYNOPSIS
\fBtkwait variable \fIname\fR
.br
\fBtkwait visibility \fIname\fR
.VS
.VE
.br
\fBtkwait window \fIname\fR
.BE

.SH DESCRIPTION
.PP
The \fBtkwait\fR command waits for one of several things to happen,
then it returns without taking any other actions.
The return value is always an empty string.
If the first argument is \fBvariable\fR (or any abbreviation of
it) then the second argument is the name of a global variable and the
command waits for that variable to be modified.
If the first argument is \fBvisibility\fR (or any abbreviation
.VS
of it) then the second argument is the name of a window and the
\fBtkwait\fR command waits for a change in its
visibility state (as indicated by the arrival of a VisibilityNotify
event).  This form is typically used to wait for a newly-created
window to appear on the screen before taking some action.
.VE
If the first argument is \fBwindow\fR (or any abbreviation
of it) then the second argument is the name of a window and the
\fBtkwait\fR command waits for that window to be destroyed.
This form is typically used to wait for a user to finish interacting
with a dialog box before using the result of that interaction.
.PP
While the \fBtkwait\fR command is waiting it processes events in
the normal fashion, so the application will continue to respond
to user interactions.

.SH KEYWORDS
variable, visibility, wait, window
