.TH Vertices 3U "2 February 1991" "Unidraw" "InterViews Reference Manual"
.SH NAME
Vertices \- abstract base class for graphics defined by a set of
coordinate pairs
.SH SYNOPSIS
.B #include <Unidraw/Graphic/verts.h>
.SH DESCRIPTION
Vertices is an abstract base class for graphics such as polygons and
splines whose geometry is specified by a set of coordinate pairs.  The
Vertices class supports vertex-related operations common to all such
graphical objects and also supports extent caching.
.SH PUBLIC OPERATIONS
.TP
.B "virtual ~Vertices()"
The destructor deallocates the list of coordinate pairs stored in the
graphic.
.TP
.B "virtual int GetOriginal(const Coord*& x, const Coord*& y)"
Return pointers to the arrays of Coords stored internally that define
the graphic's vertices.  GetOriginal's return value reflects the size
of the arrays.
.TP
.B "virtual boolean operator == (Vertices&)"
.ns
.TP
.B "virtual boolean operator != (Vertices&)"
Compare \fIthis\fP to the given Vertices instance and return whether
they (do not) store identical sets of vertices.
.SH PROTECTED OPERATIONS
.TP
.B "Vertices(Graphic* = nil)"
.ns
.TP
.B "Vertices(Coord* x, Coord* y, int count, Graphic* = nil)"
The constructors are protected to disallow instantiation of the
abstract class.  Subclasses can pass a set of vertices to copy into
internal storage and an optional graphic from which to obtain an
initial set of graphics state.  Vertices itself stores no additional
graphics state over that in the Graphic base class.
.TP
.B "void s_getExtent("
.ns
.TP
.B "    float&, float&, float&, float&, float&, Graphic*"
.ns
.TP
.B ")"
.ns
.TP
.B "void f_getExtent("
.ns
.TP
.B "    float&, float&, float&, float&, float&, Graphic*"
.ns
.TP
.B ")"
.br
Helper functions that return extent information based on the bounding
box that the vertices define.  s_getExtent returns an extent that
accounts for the width of a brush, as would be necessary if the
vertices defined a stroked path, while f_getExtent assumes that the
vertices define the graphic's extremities, as would be the case if the
vertices defined a filled path.  These operations cache the extent
they compute initially.
.SH SEE ALSO
Graphic(3U)
