.TH Page 3U "6 August 1990" "Unidraw" "InterViews Reference Manual"
.SH NAME
Page \- defines and displays a visual boundary for a viewer
.SH SYNOPSIS
.B #include <Unidraw/page.h>
.SH DESCRIPTION
A Page object delineates an area of interest in a viewer.  The page's
appearance guides the user to stay within a particular area, and the
page's bounding box defines the total scrollable area in the viewer.
Page displays a rectangle by default, but the boundary can be an
arbitrary graphic.  The page occludes any graphical components in the
viewer.  A typical use for a page is to define the page boundary in a
drawing editor; graphics beyond this area will not appear on the
printed page.
.SH PUBLIC OPERATIONS
.TP
.B "Page(float width, float height)"
Instantiate a rectangular page with dimensions \fIwidth\fP and
\fIheight\fP, in pixels.
.TP
.B "Page(Graphic*)"
Instantiate a page of arbitrary appearance, as defined by a graphic.
The graphic's bounding box defines the total scrollable area.
.TP
.B "virtual Graphic* GetGraphic()"
Returns the graphic defining the page's appearance.
.SH SEE ALSO
Graphic(3U), Viewer(3U)
