/*
 *	objdrag.C -- demonstration of dragging objects across the root
 *
 */

#include <OI/oi.H>

class	MyBox : public OI_box {
 protected:
	OI_d_tech	*drag ;
	int		ix;
	int		iy;
	OI_bool		moved ;
 public:
		MyBox( OI_number w, OI_number h ) : OI_box( NULL, w, h ) {}
		~MyBox();
	void	btn1pick( OI_d_tech *objp, XEvent *ep, char **, unsigned int *);
	void	btn1move( OI_d_tech *objp, XEvent *ep, char **, unsigned int *);
	void	btn1drop( OI_d_tech *objp, XEvent *ep, char **, unsigned int *);
};
MyBox::~MyBox() { }

int		nDest = 0;
OI_d_tech	**DestVector = NULL ;

/*
 *	The OI_actions_rec structure allows the user to specify
 *	either C-functions, or C++ member functions, to be called
 *	when the specified mouse event occurs.
 */
static OI_actions_rec Drag_actions[] = {
	{"btn1pick", NULL, NULL, (OI_translation_memfn*)&MyBox::btn1pick },
	{"btn1move", NULL, NULL, (OI_translation_memfn*)&MyBox::btn1move },
	{"btn1drop", NULL, NULL, (OI_translation_memfn*)&MyBox::btn1drop },
};

/*
 *	The dragMyBox character array specify the translations
 *	to be applied to the file glyphs.
 *	Please note that these translations could also be written out to
 *	a config file, and added to the application at runtime using
 *		app -config trans.cf
 *	Please see example transC.C for an example of how to use that
 *	method of applying translations to other objects.
 */
static	char *dragMyBox = "#override	\n\
		<Btn1Down>:	btn1pick()			\n\
		<Btn1Motion>:	btn1move()			\n\
		<Btn1Up>:	btn1drop()			\n\
	";


/*
 *	on ButtonPress
 *		- initialize ix and iy
 *		- if this was a ButtonPress Event,
 *			capture the actual event location and store as ix and iy.
 *		- show the dragbox over the source object
 *
 *	You MUST remember that event x,y is relative to the object
 * 
 */
void
MyBox::btn1pick( OI_d_tech *objp, XEvent *ep, char **, unsigned int *)
{
	XSetWindowAttributes	attrib ;

	ix = ep->xbutton.x_root - ep->xbutton.x ;
	iy = ep->xbutton.y_root - ep->xbutton.y ;

	drag = objp->clone();
	attrib.save_under = True;
	XChangeWindowAttributes( objp->display(), drag->outside_X_window(), CWSaveUnder, &attrib );
	drag->allow_override_redirect();
	drag->set_associated_object( drag->root(), ix, iy, OI_ACTIVE );

	objp->set_colors( objp->fg_pixel(), objp->bkg_pixel(), objp->bdr_pixel() );
	moved = OI_NO ;

	ix -= ep->xbutton.x ;	/* subtract off base, so we can just add in event for placement */
	iy -= ep->xbutton.y ;
}

/*
 *	on MotionNotify (drag event)
 *		- capture the event that caused this procedure to be called.
 *		- process all MotionNotify events in the queue (less choppy movement)
 *		- change the dragBox location from the old location to the new location
 */
void
MyBox::btn1move(OI_d_tech *, XEvent *ep, char **, unsigned int *)
{
	Display	*dsp ;
	XEvent	event;	/* used so we don't corrupt the initial event pointer */

	if (ep->type == MotionNotify) {
		event = *ep;
		dsp = drag->display();
		while (XCheckTypedEvent( dsp, MotionNotify, &event));
		drag->set_loc( ix + event.xmotion.x, iy + event.xmotion.y );
		moved = OI_YES ;
	}
}

/*
 *	on ButtonRelease
 */
void
MyBox::btn1drop(OI_d_tech *objp, XEvent *ep, char **, unsigned int *)
{
	int		x, y ;
	int		xdel, ydel ;
	Window		dmy ;
	OI_d_tech	*dtp ;

	/*
	 *	get delta
	 */
	XTranslateCoordinates(
		objp->display(), ep->xbutton.window, drag->X_window(),
		ep->xbutton.x, ep->xbutton.y, &xdel, &ydel, &dmy) ;
	drag->del();
	objp->set_colors( objp->fg_pixel(), objp->bkg_pixel(), objp->bdr_pixel() );

	/*
	 *	find where we are, and move the original object
	 */
	if (dtp = OI_find_obj( ep, nDest, DestVector )) {
		if (!dtp->is_derived_from( OI_app_window::clsp))
			dtp = dtp->app_window();
		XTranslateCoordinates(
			objp->display(), ep->xbutton.window, dtp->X_window(),
			ep->xbutton.x, ep->xbutton.y, &x, &y, &dmy) ;
		x -= xdel ;
		y -= ydel ;
		if (dtp == objp->app_window())
			objp->set_loc( x, y );
		else
			objp->set_associated_object( dtp, x, y, OI_ACTIVE );
	}
	else
		objp->app_window()->push_help_str( "Dropped on root", OI_YES );
}


/*
 *	Main
 *
 *	Main program.
 */
int main(int argc, char *argv[])
{
	int		i;
	int		j;
	MyBox		*box;

	/*
	 *	Open a connection.
	 */
	if (OI_init( &argc, argv, "Complex Directory Listing program" ))
	{
		nDest = 2 ;
		DestVector = (OI_d_tech**) malloc( nDest * sizeof( OI_d_tech * ) );
		OI_add_actions( Drag_actions, OI_count( Drag_actions ));
		DestVector[0] = oi_create_app_window( "one", 250, 250, "one" );
		for (i=0; i<5; i++) {
			for (j=0; j<5; j++) {
				box = new MyBox( 40, 40 );
				box->set_associated_object( DestVector[0], i*50, j*50, OI_ACTIVE );
				box->override_translations( dragMyBox );
			}
		}
		DestVector[0]->set_associated_object( DestVector[0]->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE );

		DestVector[1] = oi_create_app_window( "two", 250, 250, "two" );
		DestVector[1]->set_associated_object( DestVector[1]->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE );

		OI_begin_interaction();
	}

	/*
	 * Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini();
	return( 0 );
}
