#include <OI/oi.H>			/* 3DGlyph.C */
int main ( int argc, char** argv)
{

	OI_connection	*conp;
	OI_app_window	*wp;
	OI_glyph	*gp;
	OI_pic_spec_mask	**pics;
	int		num_pix;
	
	if (conp = OI_init(&argc,argv,"3DGlyph")) {
		wp = oi_create_app_window("main",1,1,"3DGlyph");
		wp->set_layout(OI_layout_column);
		num_pix = 4;
		pics = (OI_pic_spec_mask **)malloc(sizeof(OI_pic_spec_mask *) * num_pix);
		pics[0] = oi_create_pic_file_mask("../bitmaps/cube.1.bm",OI_pic_top,OI_pic_bottom);
		pics[1] = oi_create_pic_file_mask("../bitmaps/cube.2.bm",OI_pic_bg,OI_pic_down);
		pics[2] = oi_create_pic_file_mask("../bitmaps/cube.3.bm",OI_pic_bottom,OI_pic_top);
		pics[3] = oi_create_pic_file_mask("../bitmaps/cube.4.bm",OI_pic_fg,OI_pic_fg);
		gp = oi_create_glyph("3D_glyph",num_pix,pics,NULL,32,32);
		free((char*)pics);
			// reverse foreground and background colors
		gp->set_pixels(gp->fg_pixel(),gp->bkg_pixel(),gp->bdr_pixel());
		gp->layout_associated_object(wp,1,1,OI_active);
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
		OI_fini();
	}
}
