# all the global definitions for make are in this file
# if you change something here all the Makefiles will
# see the change.

# 
# compile and load related macros
#
# NOTE - C++ DEBUG and DEFINES are still passed from the
# top level make, so you can still define them on the 
# make command line. make is called as $(MAKE) $(MFLAGS)
# so you can define "MAKE=pmake" "MFLAGS=-c2" to take
# advantage of parallel versions of make (if you have one).
#
#
# ld defaults to dynamic X & OI libraries if they exist.  
# Add -Bstatic or -Bdynamic to the XLIBS and or OILIB macros
# to force one or the other.
#
# to check that a binary is using the correct shared library use
# the ldd command, also see ld(1) for info on LD_LIBRARY_PATH.
#
# Be aware ld uses LD_LIBRARY_PATH before -L paths
#
# If you have version 2.1.0 of C++ set DEFINES to -DCPLUSPLUS2100
#

#
#
.SUFFIXES: .o .C
.C.o:
	$(C++) -c $(C++FLAGS)  $*.C 

# 
# if you don't have new make (doesn't everyone?) add an explicit target
# for each PROGRAM that looks like this (without the '#' of course):
#program:	program.o
#	$(C++) -o $* $(LDFLAGS) $*.o $(LIBS) 
#
%:	%.o
	$(C++) -o $* $*.o $(LDFLAGS) $(LDLIBS) 

# 
# Change OI_INCDIR if OI includes are somewhere other than /usr/include
# Change OI_LIBDIR if OI libraries are somewhere other than /usr/lib
# DO NOT set OI_INCDIR to /usr/include - if C++ includes are somewhere
# else it will find include files in /usr/include before finding its
# include files and you'll get many error messages.
#
OI_INCDIR = .
OI_LIBDIR = .

# 
# Change HM_INCDIR and HM_LIBDIR if Hypermatrix includes are somewhere other 
# than /usr/include and /usr/lib.
# Change MOTIF_INCDIR and MOTIF_LIBDIR if Hypermatrix includes are somewhere
# other than /usr/include and /usr/lib.
# Change XT_INCDIR and XT_LIBDIR if the Xt includes are somewhere other than
# /usr/include and /usr/lib.
#
HM_INCDIR = 
HM_LIBDIR = 
MOTIF_INCDIR = 
MOTIF_LIBDIR = 
XT_INCDIR = 
XT_LIBDIR = 

C++ = g++
CC = gcc

DEBUG = -O -x c++
DEFINES = 
INCLUDES = -I$(OI_INCDIR)

C++FLAGS =  $(DEBUG) $(DEFINES) $(INCLUDES)
CFLAGS =  $(DEBUG) $(DEFINES) $(INCLUDES)

LDPATH = -L$(OI_LIBDIR)
XLIBS = -lXext -lX11
OILIB = -lOI
LDLIBS = $(LDPATH) $(OILIB) $(XLIBS) $(EXTRA_LIBS)
LDFLAGS = 

#
# library macros.  Systems without ranlib should define
# RANLIB to something harmless, such as echo. 
# $(RANLIB) libOI.a and $(RANLIB) -t libOI.a are both used.
# remove the 'l' from ARFLAGS if you want ar to use /tmp instead of '.'
#
AR = /bin/ar
ARFLAGS = lrcuv
RANLIB = /bin/ranlib

#
# depend related macros
# need to force path for C++ include files
# since C++ adds it, but depend doesn't
# you may need to change the C++INCLUDES macro 
#
DEPEND = /usr/bin/X11/makedepend
C++INCLUDES = -I/usr/include/CC
DEPINCLUDES = $(INCLUDES) $(C++INCLUDES)

# other macros 
# the Makefiles expect SHELL to be /bin/sh - if you set it to
# something else they might break.
#
RM = /bin/rm -f
SHELL = /bin/sh
LN = /bin/ln -s
MKDIR = /bin/mkdir -p
