/*
 ***************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1991, ParcPlace Systems, Inc. USA. All rights reserved.
 *
 ***************************************************************************
 *
 *	File:	util.H
 *
 *	Function(s):
 *
 *	Description:
 *		Various portability routines.
 *
 *	RCSid = "$Id: util.H,v 4.6.1.1 1993/06/01 22:57:12 mth Exp $"
 *
 ***************************************************************************
 */

#ifndef OI_util_H
#define OI_util_H

#ifdef uts
#include <OI/uts_string.H>
// UTS does not define MAXPATHLEN, period!, so fake it
#include <sys/socket.h>		/* defines fd_set */
#define MAXPATHLEN	1024
	extern "C" {
		int gethostname(char*, int);
		void bzero (void *, int);
		int select (int, fd_set*, fd_set*, fd_set*, const timeval *);
	}
#else
#include <string.h>
#endif

#ifdef	SVR4
	extern "C" {
		char	*re_comp(char *);
		int	re_exec(char *);
	}
#endif

#if	defined(NEEDS_BCOPY)
inline	void bcopy(void *s, void *d, int n)	{memmove(d, (const void*)(s), (size_t)n);}
#endif

#ifdef ultrix
#define OI_NEEDS_STRDUP
#include <sys/types.h>

	extern "C" {
		char *strdup (const char *);

#ifdef __DECCXX
		// the following prototypes are missing from the DEC ultrix C++ headers
		union wait; struct rusage;
		pid_t wait3(union wait*, int, struct rusage*);
		int gethostname(char*, int);
		void bcopy(void*, void*, int);
		void bzero(void*, int);
		struct timeval;
		int select (int, fd_set*, fd_set*, fd_set*, struct timeval*);
		int putenv(char *);
		struct timeval; struct timezone;
		int gettimeofday(struct timeval *, struct timezone *);
		u_short ntohs(u_short);
		u_short htons(u_short);
		u_long ntohl(u_long);
		u_long htonl(u_long);
		char *mktemp(char *);
		char *getwd(char *);

		// the following variables are missing from the DEC ultrix C++ headers!!!
	extern	int sys_nerr;
	extern	char *sys_errlist[];
#endif
	}
#endif

#ifdef NEEDS_GETTIMEOFDAY_PROTO
	extern "C" {
		int gettimeofday(struct timeval *, struct timezone *);
	}
#else
#include <sys/time.h>
#endif

#endif /* OI_util_H */
