/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	globals.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Global variable definitions
 *		These should not be used by an application
 *		See functs.H for functions to get at any of these which
 *		are generally user accessable.
 *
 *	RCSid = "$Id: globals.H,v 4.9.1.1 1993/06/01 22:54:38 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_globals_H
#define OI_globals_H

		extern	char		*OI_app_classp ;	/* ptr to application class name */
		extern	char		*OI_app_namp ;		/* ptr to application name */
		extern	OI_stat		OI_status ;		/* status value from OI_* procedure calls */
		extern	int		OI_fork_stat;		/* status value from OI_fork procedure calls */
		extern	Display		*OI_dpy ;		/* Don't use, use OI_display() instead! X windows display identifier */
	extern	class	OI_connection	*OI_def_conp ;		/* default connection */
	extern	class	OI_connection	*OI_conn_list ;		/* list of open connections */
		extern	OI_bool		OI_dialog_active ;	/* OI_YES if dialog has started */
		extern	Atom		OI_cutbuffer ;		/* buffer to do cut/paste into */
		extern	OI_bool		OI_debug ;		/* debug mode, OI_YES => in debug mode */
		extern	char		**OI_cmd_argv ;		/* saved argv for posting command line */
		extern	int		OI_cmd_argc ;		/* saved argc for posting command line */
		extern	char		**OI_com_argv ;		/* argv for common parts of command line */
		extern	int		OI_com_argc ;		/* argc for common parts of command line */
		extern	char		**OI_xt_argv ;		/* argv for Xt parts of command line */
		extern	int		OI_xt_argc ;		/* argc for Xt parts of command line */
		extern	OI_bool		OI_wm_client ;		/* client is a window manager */
		extern  OI_d_tech	*OI_Primary ;		/* application primary object */
		extern  int		OI_swm_version ;	/* swm version number, 100*major + minor */
	extern	class	OI_save_stack	*OI_sv_stack ;		/* resource format save stack */
	extern	class	OI_pointer_array	*OI_forward_refs ;	/* ptr to forward reference stack */
	extern	class	OI_class	*OI_class_treep ;	/* ptr to class tree for all registered classes */
		extern	long		OI_X_activity_ctr ;	/* output only counter of X event activity */
	extern	class	OI_event_loop_stack	*OI_event_loop_stkp ;	/* ptr to event loop process flag stack */

 /* Ptrs to class records for predefined layout methods */

		extern	OI_layout	OI_layout_none ;
		extern	OI_layout	OI_layout_row ;
		extern	OI_layout	OI_layout_column ;
		extern	OI_layout	OI_layout_row_aligned ;
		extern	OI_layout	OI_layout_row_column ;
		extern	OI_layout	OI_layout_titled_row_column ;
		extern	OI_layout	OI_layout_row_column_aligned ;
		extern	OI_layout	OI_layout_wrapped_row ;
		extern	OI_layout	OI_layout_wrapped_column ;
		extern	OI_layout	OI_layout_horz_tree ;
		extern	OI_layout	OI_layout_vert_tree ;

 /* error status */
		extern	OI_stat		OI_ok ;				/* success */
		extern	OI_stat		OI_file_not_found ;		/* file not found, non-fatal */
		extern	OI_stat		OI_layout_bad_state ;		/* layout_associated_object with invalid state */
		extern	OI_stat		OI_help_too_long ;		/* hypertext help contains a line which is too long */
		extern	OI_stat		OI_help_bad_link ;		/* invalid hypertext link */
		extern	OI_stat		OI_no_color ;			/* color could not be allocated */
		extern	OI_stat		OI_bad_pix_file ;		/* pximap file bad */
		extern	OI_stat		OI_bad_pix_data ;		/* pixmap data bad */
		extern	OI_stat		OI_bad_ef_def_size ;		/* default entry_field string too big */
		extern	OI_stat		OI_bad_ef_max_size ;		/* invalid entry_field max size */
		extern	OI_stat		OI_help_no_file ;		/* can't locate help file */
		extern	OI_stat		OI_help_no_topic ;		/* can't locate help topic */
		extern	OI_stat		OI_bad_font ;			/* couldn't load font */
		extern	OI_stat		OI_unknown_object ;		/* Can't create object of type %s. */
		extern	OI_stat		OI_no_layout_set ;		/* layout_associated_object called with no layout set on parent */
		extern	OI_stat		OI_convert_failed ;		/* a converter failed to convert the value */
		extern	OI_stat		OI_no_converter ;		/* a converter could not be found */
		extern	OI_stat		OI_conflicting_callback ;	/* attempt to register callback which conflicts with another of same type */
		extern	OI_stat		OI_bad_layout ;			/* Invalid layout method */
		extern	OI_stat		OI_lm_already_defined ;		/* Layout method %s already defined */
		extern	OI_stat         OI_lm_base_not_layout ;		/* Layout method %s, base class %s not a layout method */
		extern	OI_stat         OI_lm_base_undefined ;		/* Layout method %s, base class %s not registered */
		extern	OI_stat		OI_obsolete_resource;		/* resource fetched has been obsoleted */
		extern	OI_stat		OI_objsetup_failure;		/* unable to build all top level objects */
		extern	OI_stat		OI_no_font_list;		/* Internal error, font list for normal font lost */

		extern	OI_stat		OI_bad_state ;			/* invalid OI_state */
		extern	OI_stat		OI_bad_size ;			/* invalid size for argument */
		extern	OI_stat		OI_no_resize ;			/* resize not allowed for object */
		extern	OI_stat		OI_bad_object ;			/* object_id specifies an invalid object */
		extern	OI_stat		OI_bad_association ;		/* desired association between two objects is illegal */
		extern	OI_stat		OI_no_mem ;			/* insufficient memory */
		extern	OI_stat		OI_no_connect ;			/* unable to connect to X window server */
		extern	OI_stat		OI_no_move ;			/* object is not moveable */
		extern	OI_stat		OI_bad_create ;			/* unable to create object during map to X phase */
		extern	OI_stat		OI_bad_subobject ;		/* desired subobject does not exist */
		extern	OI_stat		OI_bad_location ;		/* location specified in association is invalid */
		extern	OI_stat		OI_constructor_failure ;	/* some form of constructor failure, otherwise unspecified */
		extern	OI_stat		OI_bad_cell ;			/* bad cell info, inappropriate cell type */
		extern	OI_stat		OI_no_app_window ;		/* no enclosing application window */
		extern	OI_stat		OI_no_file ;			/* file not found */
		extern	OI_stat		OI_no_line ;			/* specified line does not exist in MULTI_TEXT */
		extern	OI_stat		OI_no_char ;			/* specified char does not exist */
		extern	OI_stat		OI_bad_scroll_comb ;		/* invalid combination of slider, panner in scroll_text */
		extern	OI_stat		OI_bad_class_init ;		/* class initialization failure */
		extern	OI_stat		OI_bad_op ;			/* operation invalid for object of this type */
		extern	OI_stat		OI_bad_menu ;			/* invalid / inappropriate menu type specified */
		extern	OI_stat		OI_no_unsel ;			/* menu does not allow deselecting a cell */
		extern	OI_stat		OI_bad_resource;		/* resource name not found */
		extern	OI_stat		OI_bad_value ;			/* attempt to set object to invalid value */
		extern	OI_stat		OI_fork_failed ;		/* Fork failed - OI_fork_stat contains wait(3) status */
		extern	OI_stat		OI_bad_trigger ;		/* invalid button number given for trigger for menus */
		extern	OI_stat		OI_not_same_root ;		/* object and intended parent are not on same root window */
		extern	OI_stat		OI_no_child_close_x ;		/* X connection (socket) can't be closed by child process */
		extern	OI_stat		OI_bad_model ;			/* invalid interaction model */
		extern	OI_stat		OI_obj_inactive ;		/* object is inactive, can't be activated */
		extern	OI_stat		OI_bad_callback ;		/* invalid callback type, can't be decoded */
		extern	OI_stat		OI_bad_class ;			/* undefined class */
		extern	OI_stat		OI_bad_base_class ;		/* base class is not a registered class */
		extern	OI_stat		OI_cell_firing ;		/* menu already firing another cell */
		extern	OI_stat		OI_wl_bad_op ;			/* invalid operation for windowless object */
		extern	OI_stat		OI_expired ;			/* timeout reached on eval library */
		extern	OI_stat		OI_bad_sys_time ;		/* someone fiddled with system time */
		extern	OI_stat		OI_invalid_resource_value;	/* Resource "%s" for object %s has invalid value "%s" */
		extern	OI_stat		OI_clone_failure ;		/* clone failed */

 /* internal error status */
		extern	OI_stat		OI_win_exists ;			/* X window already exists in create() */
		extern	OI_stat		OI_children_created ;		/* X window & all children created in create() */
		extern	OI_stat		OI_out_of_bounds ;		/* location out of range of object */
		extern	OI_stat		OI_size_too_small ;		/* object created smaller than minimum size, size extended to minimum */

 /* for backward compatibility only */
#define	OI_OK			OI_ok
#define	OI_LAYOUT_BAD_STATE	OI_layout_bad_state
#define	OI_HELP_TOO_LONG	OI_help_too_long
#define	OI_HELP_BAD_LINK	OI_help_bad_link
#define	OI_NO_COLOR		OI_no_color
#define	OI_BAD_PIX_FILE		OI_bad_pix_file
#define	OI_BAD_PIX_DATA		OI_bad_pix_data
#define	OI_BAD_EF_DEF_SIZE	OI_bad_ef_def_size
#define	OI_BAD_EF_MAX_SIZE	OI_bad_ef_max_size
#define	OI_HELP_NO_FILE		OI_help_no_file
#define	OI_HELP_NO_TOPIC	OI_help_no_topic
#define	OI_BAD_FONT		OI_bad_font
#define	OI_UNKNOWN_OBJECT	OI_unknown_object
#define	OI_NO_LAYOUT_SET	OI_no_layout_set
#define	OI_CONVERT_FAILED	OI_convert_failed
#define	OI_NO_CONVERTER		OI_no_converter

#define	OI_BAD_STATE		OI_bad_state
#define	OI_BAD_SIZE		OI_bad_size
#define	OI_NO_RESIZE		OI_no_resize
#define	OI_BAD_OBJECT		OI_bad_object
#define	OI_BAD_ASSOCIATION	OI_bad_association
#define	OI_NO_MEM		OI_no_mem
#define	OI_NO_CONNECT		OI_no_connect
#define	OI_NO_MOVE		OI_no_move
#define	OI_BAD_CREATE		OI_bad_create
#define	OI_BAD_SUBOBJECT	OI_bad_subobject
#define	OI_BAD_LOCATION		OI_bad_location
#define	OI_CONSTRUCTOR_FAILURE	OI_constructor_failure
#define	OI_BAD_CELL		OI_bad_cell
#define	OI_NO_APP_WINDOW	OI_no_app_window
#define	OI_NO_LINE		OI_no_line
#define	OI_NO_CHAR		OI_no_char
#define	OI_BAD_SCROLL_COMB	OI_bad_scroll_comb
#define	OI_BAD_OP		OI_bad_op
#define	OI_BAD_MENU		OI_bad_menu
#define	OI_NO_UNSEL		OI_no_unsel
#define	OI_BAD_RESOURCE		OI_bad_resource
#define	OI_BAD_VALUE		OI_bad_value
#define	OI_FORK_FAILED		OI_fork_failed
#define	OI_BAD_TRIGGER		OI_bad_trigger
#define	OI_NOT_SAME_ROOT	OI_not_same_root
#define	OI_NO_CHILD_CLOSE_X	OI_no_child_close_x
#define	OI_BAD_MODEL		OI_bad_model
#define	OI_OBJ_INACTIVE		OI_obj_inactive
#define	OI_BAD_CALLBACK		OI_bad_callback
#define	OI_BAD_CLASS		OI_bad_class
#define	OI_BAD_BASE_CLASS	OI_bad_base_class
#define	OI_CELL_FIRING		OI_cell_firing
#define	OI_WL_BAD_OP		OI_wl_bad_op

#endif /* OI_globals_H */
