/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	seldlg.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_select_dialog_box class header
 *
 *	RCSid = "$Id: seldlg.H,v 4.3.1.1 1993/06/01 22:56:43 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef	OI_seldlg_H
#define	OI_seldlg_H

#ifndef	OI_pmptdlg_H
#include <OI/pmptdlg.H>
#endif /* OI_pmptdlg_H */

#ifndef OI_scrlmnu_H
#include <OI/scrlmnu.H>
#endif /* OI_scrlmnu_H */

	// class forward reference declarations
	class OI_mdl_select_dialog_box;
	class OI_scroll_menu;

#define	OI_SELECT_DB_MIN_VP_HT	5	/* Minimum viewport height. */

class OI_select_dialog_box : public OI_prompt_dialog_box {
			OI_mdl_select_dialog_box	*mdl_dep;		/* pointer to model dependent sel dlg box. */
	 public:
		static	OI_class		*clsp ;				/* ptr to class record */
	 private:
			void			construct(OI_number, OI_menu_cell**, const char*) ;
	 protected:
						OI_select_dialog_box(OI_class *clsp, const char *usr_namp,
							OI_number dsp_ln=OI_prompt_db_def_ef_width, const char *lblp="Selection",
							const char *defstr=NULL, OI_number mxln=-1, OI_number smnc=-1,
							OI_menu_cell**smcpp=NULL, const char *tp="Items", OI_number nc=-1,
							OI_menu_cell **cpp= NULL) ;
						OI_select_dialog_box(OI_class *clsp, const char *usr_namp, OI_number dsp_ln,
							const char *lblp, const char *defstr, OI_number mxln, OI_number smnc,
							OI_cell_spec *smcpp, const char *tp="Items", OI_number nc=-1,
							OI_cell_spec *cpp= NULL) ;
		virtual	void			new_model(OI_model_type) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_select_dialog_box(const char *, OI_number=OI_prompt_db_def_ef_width,
							const char* ="Selection", const char* =NULL, OI_number =-1, OI_number =-1,
							OI_menu_cell** =NULL, const char* ="Items", OI_number =-1,
							OI_menu_cell** = NULL);
						OI_select_dialog_box(const char *, OI_number, const char*, const char*,
							OI_number, OI_number, OI_cell_spec*, const char* ="Items", OI_number =-1,
							OI_cell_spec* = NULL);
						~OI_select_dialog_box();
			void			clone_adjust(OI_d_tech*) ;
		static	OI_bool			init(OI_connection*) ;
		static	OI_select_dialog_box	*make_minimal(const char*,OI_minimal_type) ;
			OI_scroll_menu		*menu() ;
	virtual	void				mnu_select(OI_menu *, OI_menu_cell *, void *, OI_number);
											/* display selected text in entfld*/


		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_stat			change_menu(OI_number,OI_menu_cell**,const char* =NULL) ;	/* change underlying menu */
			OI_stat			change_menu(OI_number,OI_cell_spec*,const char* =NULL) ;	/* change underlying menu */
};

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_select_dialog_box *oi_select_dialog_box(const char*, OI_number=OI_prompt_db_def_ef_width, const char* ="Selection ",
					const char* =NULL, OI_number =-1, OI_number =-1, OI_menu_cell** =NULL, const char * ="Items",
					OI_number =-1, OI_menu_cell** = NULL);

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_select_dialog_box *oi_create_select_dialog_box(const char*,OI_number=OI_prompt_db_def_ef_width, const char* ="Selection ",
					const char* =NULL, OI_number=-1, OI_number=-1, OI_cell_spec* =NULL, const char* ="Items",
					OI_number =-1, OI_cell_spec* = NULL);
	OI_select_dialog_box *oi_create_select_dialog_box(const char*, OI_number, const char*, const char*, OI_number,
					OI_number, OI_menu_cell**, const char * ="Items", OI_number =-1, OI_menu_cell** = NULL);

#endif /* OI_seldlg_H */
