
#include "window.h"
#include "trees.h"

#define NDEF_FLAG	(SELECTABLE | EXIT)
#define DEF_FLAG	(SELECTABLE | EXIT | DEFAULT)

OBJECT *tr_add(register TREE *t,int as_child,int type,int flags,int state,long spec,int x,int y,int width,int height);
OBJECT *tr_tree(TREE *t);
TEDINFO *tedinfo(char *buf,int len);

OBJECT *
str_obj(prompt, buf, buflen)
char *prompt;
char *buf;
int buflen;
{
	TREE tree = { 0, 0, 0 };
	TREE *t = &tree;
	TEDINFO *edit;
/*	int lh = wlineheight (); */
	int lh = w_ch_height;
	int cw = w_ch_width;
	int pr_width = wtextwidth (prompt, -1);
	int buf_width = buflen <= 40 ? buflen * cw : 40 * cw;
	int but_width = 17 * cw;
/*
		12 for the characters, 3 for the space around the
		buttons and 2 for the borders of the buttons
*/
	int box_width;
	int box_height = 8 * lh + 6;

	box_width = (pr_width > buf_width ?
			(pr_width > but_width ? pr_width : but_width) :
			(buf_width > but_width ? buf_width : but_width))
		+ 6 * cw + 6;

	tr_add(t, 0, G_BOX, NONE, NORMAL, BAR, 0, 0, box_width, box_height);
	tr_add(t, 1, G_BOX, NONE, NORMAL, BAR, 3, 3, box_width - 6,
							box_height - 6);
	tr_add(t, 1, G_STRING, NONE, NORMAL, (long)prompt, 3 * cw, lh, pr_width, lh);

	edit = tedinfo (buf, buflen > 40 ? 40 : buflen);

	tr_add(t, 0, G_FTEXT ,NONE, NORMAL, (long)edit, 3 * cw, 5 * lh / 2,
							buf_width, 2 * lh);
	tr_add(t, 0, G_BUTTON, DEF_FLAG, NORMAL, (long)(" Ok "), 3 * cw, 6 * lh,
								4 * cw, lh);
	tr_add(t, 0, G_BUTTON, NDEF_FLAG, NORMAL, (long)(" Cancel "),
				box_width - 15 * cw, 6 * lh, 8 * cw, lh);

	return(tr_tree(t));
}

