#include "window.h"
#include "style.h"

void    setclip () ;

extern int      vdi_handle ;

extern bool     mousedown ;

void
wchange (win, left, top, right, bottom)
        WINDOW  *win ;
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
{
        if (win == NULL)
                return ;

        if (left < win->orgh)
                left = win->orgh ;
        if (top < win->orgv)
                top = win->orgv ;
        if (right > win->orgh + win->width)
                right = win->orgh + win->width ;
        if (bottom > win->orgv + win->height)
                bottom = win->orgv + win->height ;

        if (left >= right || top >= bottom)
                return ;

        if (!win->needupdate) {
                /* No changed area; assign paramters */
                win->needupdate = TRUE ;
                win->left = left ;
                win->top = top ;
                win->right = right ;
                win->bottom = bottom ;
        }
        else {
                /* Already a changed area; calculate new rectangle */
                if (left < win->left)
                        win->left = left ;
                if (top < win->top)
                        win->top = top ;
                if (right > win->right)
                        win->right = right ;
                if (bottom > win->bottom)
                        win->bottom = bottom ;
        }
}

void
wgetchange (win, pleft, ptop, pright, pbottom)
        WINDOW  *win ;
        int     *pleft ;
        int     *ptop ;
        int     *pright ;
        int     *pbottom ;
{
        *pleft = *ptop = *pright = *pbottom = 0 ;

        if (win == NULL) {
                wdebug ("wgetchange: illegal window pointer") ;
                return ;
        }

        if (win->needupdate) {
                *pleft = win->left ;
                *ptop = win->top ;
                *pright = win->right ;
                *pbottom = win->bottom ;
        }
}

void
wupdate (win)
        WINDOW  *win ;
{
        if (win == NULL) {
                wdebug ("wupdate: illegal window pointer") ;
                return ;
        }
        if (win->needupdate) {
                int     handle ;
                int     changed[4] ;
                int     draw[4] ;

                wgetchange (win, &changed[0], &changed[1], &changed[2],
                                                                &changed[3]) ;

                handle = win->handle ;
                if (!wind_get (handle, WF_FIRSTXYWH, &draw[0], &draw[1],
                                                        &draw[2], &draw[3])) {
                        wdebug ("wupdate: wind_get") ;
                        return ;
                }
                while (draw[2] && draw[3]) {
                        SCRTODOC (win, draw[0], draw[1], draw[0], draw[1]) ;
                        draw[2] += draw[0] ;
                        draw[3] += draw[1] ;

                        if (intersect (changed, draw)) {
                                wbegindrawing (win) ;
                                setclip (win, 1, draw[0], draw[1], draw[2],
                                                                draw[3]) ;
                                werase (draw[0], draw[1], draw[2], draw[3]) ;
                                if (win->drawproc != NULL)
                                        (*win->drawproc) (win, draw[0], draw[1],
                                                        draw[2],draw[3]) ;
                                setclip (win, 0, draw[0], draw[1], draw[2],
                                                                draw[3]) ;
                                wenddrawing (win) ;
                        }
                        if (!wind_get (handle, WF_NEXTXYWH, &draw[0], &draw[1],
                                                        &draw[2], &draw[3])) {
                                wdebug ("wupdate: wind_get") ;
                                return ;
                        }
                }
                win->needupdate = FALSE ;
        }
}

void
wsetorigin (win, h, v)
        WINDOW  *win ;
        int     h ;
        int     v ;
{
        extern  bool getsrcdiff () ;
        int     l ;
        int     t ;
        int     r ;
        int     b ;
        int     dh ;
        int     dv ;
        int     src[4] ;
        int     diff[4][4] ;
        int     nr_diff ;
        int     i ;

        if (win == NULL) {
                wdebug ("wsetorigin: illegal window pointer") ;
                return ;
        }

        if (h > win->doc_width - win->width)
                h = win->doc_width - win->width ;

        if (h < 0)
                h = 0 ;

        if (v > win->doc_height - win->height)
                v = win->doc_height - win->height ;

        if (v < 0)
                v = 0 ;

        if (h == win->orgh && v == win->orgv)
                return ;

        rmcaret () ;

        l = win->orgh ;
        r = win->orgh + win->width ;
        t = win->orgv ;
        b = win->orgv + win->height ;
        dh = win->orgh - h ;
        dv = win->orgv - v ;

        if (dh > 0)
                l -= dh ;
        if (dh < 0)
                r -= dh ;
        if (dv > 0)
                t -= dv ;
        if (dv < 0)
                b -= dv ;

        if (getsrcdiff (win, l, t, r, b, dh, dv, src, diff, &nr_diff)) {
                scrollby (win, src[0], src[1], src[2], src[3], dh, dv) ;
        }

        win->orgh = h ;
        win->orgv = v ;

        for (i = 0 ; i < nr_diff ; i++) {
                wchange (win, diff[i][0], diff[i][1],
                                diff[i][2], diff[i][3]) ;
        }

        showcaret () ;

        wupdate (win) ;

        setscrollbars (win) ;
}

void
wgetwinorigin (win, ph, pv)
        WINDOW  *win ;
        int     *ph ;
        int     *pv ;
{
        *ph = win->orgh ;
        *pv = win->orgv ;
}

void
wsetdocsize (win, width, height)
        WINDOW  *win ;
        int     width ;
        int     height ;
{
        if (win == NULL) {
                wdebug ("wsetdocsize: illegal window pointer") ;
                return ;
        }
        win->doc_width = width ;
        win->doc_height = height ;

        setscrollbars (win) ;
}

void
wshow (win, left, top, right, bottom)
        WINDOW  *win ;
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
{
        int     width ;
        int     height ;
        int     orgh = win->orgh ;
        int     orgv = win->orgv ;
        int     extrah ;
        int     extrav ;

        if (mousedown)
                return ;

        wgetwinsize (win, &width, &height) ;
/*wdebug ("     lef top rig bot|rect %3d %3d %3d %3d|wind %3d %3d %3d %3d",
        left, top, right, bottom, orgh, orgv, orgh + width, orgv + height) ;
*/      if ((left >= orgh) &&
                (top >= orgv) &&
                (right <= orgh + width) &&
                (bottom <= orgv + height)) {
                return ; /* Already visible */
        }

        extrah = (width - (right - left)) / 2 ;
        if (extrah < 0)
                extrah = 0 ;

        extrav = (height - (bottom - top)) / 2 ;
        if (extrav < 0)
                extrav = 0 ;

/*      wdebug ("left %d orgh %d right %d width %d extrah %d",
                left, orgh, right, width, extrah) ;
*/      if (left < orgh)
                orgh = left - extrah ;
        else if (right > orgh + width)
                orgh = right - width + extrah ;
/*      wdebug ("orgh %d", orgh) ;

        wdebug ("top %d orgv %d bottom %d height %d extrav %d",
                top, orgv, bottom, height, extrav) ;
*/      if (top < orgv)
                orgv = top - extrav ;
        else if (bottom > orgv + height)
                orgv = bottom - height + extrav ;
/*      wdebug ("orgv %d", orgv) ;
*/
        wsetorigin (win, orgh, orgv) ;
}

void
setclip (win, flag, left, top, right, bottom)
        WINDOW  *win ;
        int     flag ;
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
{
        int     scr_rect[4] ;

        DOCTOSCR (win, left, top, scr_rect[0], scr_rect[1]) ;
        DOCTOSCR (win, right - 1, bottom - 1, scr_rect[2], scr_rect[3]) ;

        vs_clip (vdi_handle, flag, scr_rect) ;
}

int
intersect (src, dest)
        int     *src ;
        int     *dest ;
{
        if (src[0] > dest[0])
                dest[0] = src[0] ;
        if (src[1] > dest[1])
                dest[1] = src[1] ;
        if (src[2] < dest[2])
                dest[2] = src[2] ;
        if (src[3] < dest[3])
                dest[3] = src[3] ;

        if (dest[0] >= dest[2] || dest[1] >= dest[3])
                return FALSE ;
        return TRUE ;
}
