#include "stdwdefi.h"
#include "stdwin.h"

/* "Printf to a window", with (h, v) and return value like wdrawtext.
   Use only in a draw procedure or between wbegindrawing/wenddrawing. */

/* "Centered printf to a window": like wprintf but allows centered text.
   The first parameter, align, is a percentage: a value of 0 prints
   at the right of h, a value of 50 centers around h, a value of 100
   aligns the end of the text at h.
   The v coordinate always indicates the top of the text.
   Return value is the h coordinate at the right end of the text. */

#if defined(__STDC__) && defined(HAVE_STDARG_H)

#include <stdarg.h>

void
wprintf(int h, int v, char *fmt, ...)
{       va_list args;
        char buf[1000];
        int len;
        int width;

        va_start(args,fmt);
        vsprintf(buf, fmt, args);
        va_end(args);
        len = strlen(buf);
        width = wtextwidth(buf, len);
        wdrawtext(h, v, buf, len);
}

void
wcprintf(int align, int h, int v, char *fmt, ...)
{       va_list args;
        char buf[1000];
        int len;
        int width;

        va_start(args,fmt);
        vsprintf(buf, fmt, args);
        va_end(args);
        len = strlen(buf);
        width = wtextwidth(buf, len);
        wdrawtext(h - align*width/100, v, buf, len);
}

#else

#ifdef HAVE_VARARGS_H

#include <varargs.h>

void
wprintf(va_alist)
  va_dcl
{       va_list args;
        int h, v;
        char *fmt;
        char buf[1000];
        int len;
        int width;

        va_start(args);
        h = va_arg(args,int);
        v = va_arg(args,int);
        fmt = va_arg(args,char*);
        vsprintf(buf, fmt, args);
        va_end(args);
        len = strlen(buf);
        width = wtextwidth(buf, len);
        wdrawtext(h, v, buf, len);
}

void
wcprintf(va_alist)
  va_dcl
{       va_list args;
        int align;
        int h, v;
        char *fmt;
        char buf[1000];
        int len;
        int width;

        va_start(args);
        align = va_arg(args,int);
        h = va_arg(args,int);
        v = va_arg(args,int);
        fmt = va_arg(args,char*);
        vsprintf(buf, fmt, args);
        va_end(args);
        len = strlen(buf);
        width = wtextwidth(buf, len);
        wdrawtext(h - align*width/100, v, buf, len);
}

#else /* neither stdargs nor varargs */

void
wprintf(h, v, fmt, rest_of_arguments)
        int h, v;
        char *fmt;
{
        char buf[1000];
        int len;
        int width;

        vsprintf(buf, fmt, &rest_of_arguments);
        len = strlen(buf);
        width = wtextwidth(buf, len);
        wdrawtext(h, v, buf, len);
}

void
wcprintf(align, h, v, fmt, rest_of_arguments)
        int align;
        int h, v;
        char *fmt;
{
        char buf[1000];
        int len;
        int width;

        vsprintf(buf, fmt, &rest_of_arguments);
        len = strlen(buf);
        width = wtextwidth(buf, len);
        wdrawtext(h - align*width/100, v, buf, len);
}

#endif /* HAVE_VARARGS_H */

#endif /* HAVE_STDARG_H */

