macro(DebugInformationFormat_check tgt Debug_expect Release_expect MinSizeRel_expect RelWithDebInfo_expect)
  set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/${tgt}.vcxproj")
  if(NOT EXISTS "${vcProjectFile}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not exist.")
    return()
  endif()

  set(Debug_actual "")
  set(Release_actual "")
  set(MinSizeRel_actual "")
  set(RelWithDebInfo_actual "")

  file(STRINGS "${vcProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<ItemDefinitionGroup Condition=\"'\\$\\(Configuration\\)\\|\\$\\(Platform\\)'=='([^<>]+)\\|[A-Za-z0-9_]+'\">")
      set(Configuration "${CMAKE_MATCH_1}")
    endif()
    if(line MATCHES "^ *<DebugInformationFormat>([^<>]+)</DebugInformationFormat>")
      set(${Configuration}_actual "${CMAKE_MATCH_1}")
    endif()
  endforeach()

  if (NOT "${Debug_actual}" STREQUAL "${Debug_expect}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj Debug Configuration has DebugInformationFormat '${Debug_actual}', not '${Debug_expect}'.")
  endif()
  if (NOT "${Release_actual}" STREQUAL "${Release_expect}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj Release Configuration has DebugInformationFormat '${Release_actual}', not '${Release_expect}'.")
  endif()
  if (NOT "${MinSizeRel_actual}" STREQUAL "${MinSizeRel_expect}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj MinSizeRel Configuration has DebugInformationFormat '${MinSizeRel_actual}', not '${MinSizeRel_expect}'.")
  endif()
  if (NOT "${RelWithDebInfo_actual}" STREQUAL "${RelWithDebInfo_expect}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj RelWithDebInfo Configuration has DebugInformationFormat '${RelWithDebInfo_actual}', not '${RelWithDebInfo_expect}'.")
  endif()
endmacro()

DebugInformationFormat_check(default-C ProgramDatabase "" "" ProgramDatabase)
DebugInformationFormat_check(default-CXX ProgramDatabase "" "" ProgramDatabase)
DebugInformationFormat_check(empty-C "" "" "" "")
DebugInformationFormat_check(empty-CXX "" "" "" "")
DebugInformationFormat_check(Embedded-C OldStyle OldStyle OldStyle OldStyle)
DebugInformationFormat_check(Embedded-CXX OldStyle OldStyle OldStyle OldStyle)
DebugInformationFormat_check(ProgramDatabase-C ProgramDatabase ProgramDatabase ProgramDatabase ProgramDatabase)
DebugInformationFormat_check(ProgramDatabase-CXX ProgramDatabase ProgramDatabase ProgramDatabase ProgramDatabase)
DebugInformationFormat_check(EditAndContinue-C EditAndContinue EditAndContinue EditAndContinue EditAndContinue)
DebugInformationFormat_check(EditAndContinue-CXX EditAndContinue EditAndContinue EditAndContinue EditAndContinue)
