# Find GSS.framework
# This will define :
#
# GSSFRAMEWORK_FOUND
# GSSFRAMEWORK_INCLUDE_DIR
# GSSFRAMEWORK_LIBRARIES
# GSSFRAMEWORK_LDFLAGS
#

FIND_PATH(GSSFRAMEWORK_INCLUDE_DIR NAMES GSS.h)
FIND_LIBRARY(GSSFRAMEWORK_LIBRARIES NAMES GSS)
IF (GSSFRAMEWORK_INCLUDE_DIR AND GSSFRAMEWORK_LIBRARIES)
	IF (NOT CoreFoundation_FIND_QUIETLY)
		MESSAGE(STATUS "Found GSS.framework ${GSSFRAMEWORK_LIBRARIES}")
	ENDIF()
	SET(GSSFRAMEWORK_FOUND TRUE)
	SET(GSSFRAMEWORK_LDFLAGS "-framework GSS")
ENDIF ()

IF (GSS_FIND_REQUIRED AND NOT GSSFRAMEWORK_FOUND)
	MESSAGE(FATAL_ERROR "CoreFoundation not found")
ENDIF()

MARK_AS_ADVANCED(
	GSSFRAMEWORK_INCLUDE_DIR
	GSSFRAMEWORK_LIBRARIES
	GSSFRAMEWORK_LDFLAGS
)
