/*****************************************************************************\
  models.h : Models types

  Copyright (c) 1996 - 2008, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#ifndef APDK_MODELS_H
#define APDK_MODELS_H

#include "config.h"

APDK_BEGIN_NAMESPACE

// list of the basic equivalence classes
/*! Do not use PRINTER_TYPE - it is going away in the next version
\depricated
*/
typedef enum PRINTER_TYPE               // typedef'ed for C interface
{
    UNSUPPORTED=-1,
    eDJ400,
    eDJ540,
    eDJ600,
    eDJ6xx,
    eDJ6xxPhoto,
    eDJ8xx,
    eDJ850,
    eDJ890,
    eDJ9xx,
    eDJ9xxVIP,
    eDJ630,
    eAP2xxx,
    eAP21xx,
    eAP2560,
    eDJ350,
    eDJ8x5,
    ePSP100,
    ePSP470,
    eDJ3320,
    eDJGenericVIP,
    eDJ55xx,
    eOJProKx50,
    eLJMono,
    eLJColor,
    ePScript,
    eDJ3600,
    eDJ4100,
    eLJJetReady,
    eLJFastRaster,
    eLJZjsMono,
    eLJM1005,
    eLJP1XXX,
    eQuickConnect,
    MAX_PRINTER_TYPE
} PRINTER_TYPE;

// strings used in Version function and for test harness
/*! Do not use ModelName - it is going away in the next version
\depricated
*/
const char ModelName[MAX_PRINTER_TYPE][13] =
{
    "DJ400",
    "DJ540",
    "DJ600",
    "DJ6xx",
    "DJ6xxPhoto",
    "DJ8xx",
    "DJ850",
    "DJ890",
    "DJ9xx",
    "DJ9xxVIP",
    "DJ630",
    "AP2xxx",
    "AP21xx",
    "AP2560",
    "DJ350",
    "DJ8x5",
    "PS100",
    "PS470",
    "DJ3320",
    "GenericVIP",
    "DJ55xx",
    "OJProKx50",
    "Mono Laser",
    "ColorLaser",
    "PostScript",
    "DJ3600",
    "DJ4100",
    "LJJetReady",
    "LJFastRaster",
    "LJZjsMono",
    "LJM1005",
    "LJP1XXX",
    "QuickConnect"
};

APDK_END_NAMESPACE

#endif  //APDK_MODELS_H
