#!/usr/bin/env python

#/****************************************************************************
#** $Id: progress.py 322023 2004-06-19 20:33:37Z sedwards $
#**
#** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
#**
#** This file is part of an example program for Qt.  This example
#** program may be used, distributed and modified without limitation.
#**
#** Converted to PyQt3: Hans-Peter Jansen <hpj@urpla.net>
#**
#*****************************************************************************/

from qt import *
import sys
from random import random

TRUE = 1
FALSE = 0

class AnimatedThingy(QLabel):
    def __init__(self, parent, s):
        QLabel.__init__(self, parent)
        self.nqix = 40
        self.step = 0
        self.ox = []
        self.oy = []
        self.px = []
        self.py = []
        for i in range(self.nqix):
            self.ox.append(0)
            self.oy.append(0)
            self.px.append(0)
            self.py.append(0)
        self.x0, self.y0, self.x1, self.y1 = 0, 0, 0, 0
        self.dx0 = 2 + int(random() * 8)
        self.dy0 = 2 + int(random() * 8)
        self.dx1 = 2 + int(random() * 8)
        self.dy1 = 2 + int(random() * 8)
        self.label = QString(s)
        self.setEraseColor(Qt.black)
        self.label.append("\n... and wasting CPU\nwith this animation!\n")
        
    def XXXshow(self):
        if not self.isVisible():
            print "bla"
            self.startTimer(100)
        QWidget.show(self)

    def hide(self):
        QWidget.hide(self)
        self.killTimers()

    def sizeHint(self):
        return QSize(120, 100)

    def timerEvent(self, e):
        p, pn = self._painter()
        pn.setColor(self.eraseColor())
        p.setPen(pn)
        self.step = step = (self.step + 1) % self.nqix
        # erase line
        p.drawLine(self.ox[step], self.oy[step], self.px[step], self.py[step])
        # calc new line coordinates
        self.x0, self.dx0 = self._inc(self.x0, self.dx0, self.width())
        self.y0, self.dy0 = self._inc(self.y0, self.dy0, self.height())
        self.x1, self.dx1 = self._inc(self.x1, self.dx1, self.width())
        self.y1, self.dy1 = self._inc(self.y1, self.dy1, self.height())
        self.ox[step] = self.x0
        self.oy[step] = self.y0
        self.px[step] = self.x1
        self.py[step] = self.y1
        self._drawqix(p, pn, step)
        self._drawtxt(p)

    def paintEvent(self, e):
        p, pn = self._painter()
        p.setClipRect(e.rect())
        for i in range(self.nqix):
            self._drawqix(p, pn, i)
        self._drawtxt(p)

    def _painter(self):
        p = QPainter(self)
        pn = p.pen()
        pn.setWidth(2)
        p.setPen(pn)
        return p, pn

    def _drawqix(self, p, pn, step):
        c = QColor()
        # enhanced rainbow effect
        i = (step * 511)/self.nqix
        if i > 255:
            i = 511 - i
        c.setHsv(i, 255, 255)
        pn.setColor(c)
        p.setPen(pn)
        p.drawLine(self.ox[step], self.oy[step], self.px[step], self.py[step])

    def _drawtxt(self, p):
        #p.setPen(self.colorGroup().text())
        p.setPen(Qt.white)
        p.drawText(self.rect(), Qt.AlignCenter, self.label)

    def _inc(self, x, dx, b):
        x += dx
        if x < 0:
            x = 0
            dx = 2 + int(random() * 8)
        elif x >= b:
            x = b-1
            dx = -(2 + int(random() * 8))
        return x, dx


class CPUWaster(QWidget):
    def __init__(self):
        QWidget.__init__(self)
        self.first_draw_item = 1000
        self.last_draw_item = 1006
        self.rects = 0
        self.timer_driven = 0
        self.default_label = 0
        self.got_stop = 0
        self.pb = None
        menubar = QMenuBar(self, "menu")
        file = QPopupMenu()
        menubar.insertItem("&File", file)
        for i in range(self.first_draw_item, self.last_draw_item + 1):
            file.insertItem(self.drawItemText(i), i)
        self.connect(menubar, SIGNAL("activated(int)"), self.doMenuItem)
        file.insertSeparator()
        file.insertItem("Quit", qApp, SLOT("quit()"))
        options = QPopupMenu()
        menubar.insertItem("&Options", options)
        self.td_id = options.insertItem("Timer driven", self.timerDriven)
        self.ld_id = options.insertItem("Loop driven", self.loopDriven)
        options.insertSeparator()
        self.dl_id = options.insertItem("Default label", self.defaultLabel)
        self.cl_id = options.insertItem("Custom label", self.customLabel)
        options.insertSeparator()
        self.md_id = options.insertItem("No minimum duration", self.toggleMinimumDuration)
        options.setCheckable(TRUE)
        self.options = options
        self.menubar = menubar
        self.file = file
        #self.loopDriven()
        self.timerDriven()
        #self.defaultLabel()
        self.customLabel()
        self.setFixedSize(400, 300)
        self.setEraseColor(Qt.black)

    def drawItemRects(self, id):
        n = id - self.first_draw_item
        r = 100
        while n:
            n -= 1
            f = 5
            if not n % 3:
                f = 4
            r *= f
        return r

    def drawItemText(self, id):
        return QString("%d Rectangles" % self.drawItemRects(id))

    # slots
    def doMenuItem(self, id):
        if id >= self.first_draw_item and id <= self.last_draw_item:
            self._draw(self.drawItemRects(id))

    def stopDrawing(self):
        self.got_stop = TRUE

    def timerDriven(self):
        self.timer_driven = TRUE
        self.options.setItemChecked(self.td_id, TRUE)
        self.options.setItemChecked(self.ld_id, FALSE)

    def loopDriven(self):
        self.timer_driven = FALSE
        self.options.setItemChecked(self.ld_id, TRUE)
        self.options.setItemChecked(self.td_id, FALSE)

    def defaultLabel(self):
        self.default_label = TRUE
        self.options.setItemChecked(self.dl_id, TRUE)
        self.options.setItemChecked(self.cl_id, FALSE)

    def customLabel(self):
        self.default_label = FALSE
        self.options.setItemChecked(self.dl_id, FALSE)
        self.options.setItemChecked(self.cl_id, TRUE)

    def toggleMinimumDuration(self):
        self.options.setItemChecked(self.md_id, not self.options.isItemChecked(self.md_id))

    def timerEvent(self, e):
        self.pb.setProgress(self.pb.totalSteps() - self.rects)
        self.rects -= 1
        p = QPainter(self)
        ww = self.width()
        wh = self.height()

        if ww > 8 and wh > 8:
            c = QColor(int(random() * 255), int(random() * 255), int(random() * 255))
            x = int(random() * (ww-8))
            y = int(random() * (wh-8))
            w = int(random() * (ww-x))
            h = int(random() * (wh-y))
            p.fillRect(x, y, w, h, QBrush(c))

        if not self.rects or self.got_stop:
            self.pb.setProgress(self.pb.totalSteps())
            p = QPainter(self)
            p.fillRect(0, 0, self.width(), self.height(), QBrush(self.eraseColor()))
            self.enableDrawingItems(TRUE)
            self.killTimers()
            if not self.default_label:
                self.pb.killTimers()
                self.l.killTimers()
            del self.pb
            self.pb = None

    def newProgressDialog(self, label, steps, modal):
        d = QProgressDialog(label, "Cancel", steps, self, "progress", modal)
        if self.options.isItemChecked(self.md_id):
            d.setMinimumDuration(0)
        if not self.default_label:
            self.l = AnimatedThingy(d, label)
            d.setLabel(self.l)
            self.l.startTimer(100)
        return d

    def enableDrawingItems(self, yes):
        for i in range(self.first_draw_item, self.last_draw_item):
            self.menubar.setItemEnabled(i, yes)

    def _draw(self, n):
        if self.timer_driven:
            if self.pb:
                qWarning("This cannot happen!")
                return

            self.rects = n
            self.pb = self.newProgressDialog("Drawing rectangles.\nUsing timer event.", n, FALSE)
            self.pb.setCaption("Please Wait")
            self.connect(self.pb, SIGNAL("cancelled()"), self.stopDrawing)
            self.enableDrawingItems(FALSE)
            self.startTimer(10)
            self.got_stop = FALSE
        else:
            lpb = self.newProgressDialog("Drawing rectangles.\nUsing loop.", n, TRUE)
            lpb.setCaption("Please Wait")

            p = QPainter(self)
            for i in range(n):
                lpb.setProgress(i)
                if lpb.wasCancelled():
                    break
                c = QColor(int(random() * 255), int(random() * 255), int(random() * 255))
                x = int(random() * (self.width()-8))
                y = int(random() * (self.height()-8))
                w = int(random() * (self.width()-x))
                h = int(random() * (self.height()-y))
                p.fillRect(x, y, w, h, QBrush(c))

            lpb.cancel()
            del lpb
            p.fillRect(0, 0, self.width(), self.height(), QBrush(self.eraseColor()))


if __name__ == "__main__":
    app = QApplication(sys.argv)
    try:
        n = int(sys.argv[1])
    except:
        n = 1
    for i in range(n):
        cpuw = CPUWaster()
        if i == 0:
            app.setMainWidget(cpuw)
        cpuw.show()
    app.exec_loop()
