/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;

public class SecureClassLoader
extends ClassLoader {
    protected SecureClassLoader(ClassLoader parent) {
        super(parent);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
    }

    protected SecureClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
    }

    protected final Class defineClass(String name, byte[] b, int off, int len, CodeSource cs) {
        if (cs != null) {
            ProtectionDomain protectionDomain = new ProtectionDomain(cs, this.getPermissions(cs));
            return super.defineClass(name, b, off, len, protectionDomain);
        }
        return super.defineClass(name, b, off, len);
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        Policy policy = Policy.getPolicy();
        return policy.getPermissions(cs);
    }
}

