/*
    $Id: stats.h 212185 2003-03-07 22:11:39Z waba $

    KCalc, a scientific calculator for the X window system using the
    Qt widget libraries, available at no cost at http://www.troll.no
   
    Copyright (C) 1996 Bernd Johannes Wuebben
                       wuebben@math.cornell.edu
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef KSTATS_H
#define KSTATS_H

#include <qvaluevector.h>
#include "kcalctype.h"

class KStats {

public:
	KStats();
	~KStats();

public:
	void clearAll();
	void enterData(CALCAMNT data);
	void clearLast();
	CALCAMNT sum();
	CALCAMNT sum_of_squares();
	CALCAMNT mean();
	CALCAMNT median();
	CALCAMNT std_kernel();
	CALCAMNT std();
	CALCAMNT sample_std();
	int	     count();
	bool     error();

private:
    QValueVector<CALCAMNT> mData;
    bool error_flag;

};


#endif /*KSTATS_H*/

