--TEST--
array_chunk()
--FILE--
<?php
$arrays = array (
	array (),
	array (0),
	array (1),
	array (-1),
	array (0, 2),
	array (1, 2, 3),

	array (1 => 0),
	array (2 => 1),
	array (3 => -1),

	array (1 => 0, 2 => 2),
	array (1 => 1, 2 => 2, 3 => 3),
	array (0 => 0, 3 => 2),
	array (1 => 1, 5 => 2, 8 => 3),

	array (1, 2),
	array (0, 1, 2),
	array (1, 2, 3),
	array (0, 1, 2, 3),
	array (1, 2, 3, 4),
	array (0, 1, 2, 3, 4),
	array (1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
	array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10),

	array ("a" => 1),
	array ("b" => 1, "c" => 2),
	array ("p" => 1, "q" => 2, "r" => 3, "s" => 4, "u" => 5, "v" => 6),

	array ("a" => "A"),
	array ("p" => "A", "q" => "B", "r" => "C", "s" => "D", "u" => "E", "v" => "F"),
);

foreach ($arrays as $item) {
	echo "===========================================\n";
	var_dump ($item);
	echo "-------------------------------------------\n";
	for ($i = 0; $i < (sizeof($item) + 1); $i++) {
		echo "[$i]\n";
		var_dump (@array_chunk ($item, $i));
		var_dump (@array_chunk ($item, $i, TRUE));
		var_dump (@array_chunk ($item, $i, FALSE));
		echo "\n";
	}
	echo "\n";
}
echo "end\n";
?>
--EXPECT--
===========================================
array(0) {
}
-------------------------------------------
[0]
NULL
NULL
NULL


===========================================
array(1) {
  [0]=>
  int(0)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
}


===========================================
array(1) {
  [0]=>
  int(1)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
}


===========================================
array(1) {
  [0]=>
  int(-1)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(-1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(-1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(-1)
  }
}


===========================================
array(2) {
  [0]=>
  int(0)
  [1]=>
  int(2)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [1]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}

[2]
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(2)
  }
}


===========================================
array(3) {
  [0]=>
  int(1)
  [1]=>
  int(2)
  [2]=>
  int(3)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [1]=>
    int(2)
  }
  [2]=>
  array(1) {
    [2]=>
    int(3)
  }
}
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[2]
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [2]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[3]
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}


===========================================
array(1) {
  [1]=>
  int(0)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
}
array(1) {
  [0]=>
  array(1) {
    [1]=>
    int(0)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
}


===========================================
array(1) {
  [2]=>
  int(1)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [2]=>
    int(1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
}


===========================================
array(1) {
  [3]=>
  int(-1)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(-1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [3]=>
    int(-1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(-1)
  }
}


===========================================
array(2) {
  [1]=>
  int(0)
  [2]=>
  int(2)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [1]=>
    int(0)
  }
  [1]=>
  array(1) {
    [2]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}

[2]
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [1]=>
    int(0)
    [2]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(2)
  }
}


===========================================
array(3) {
  [1]=>
  int(1)
  [2]=>
  int(2)
  [3]=>
  int(3)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(3) {
  [0]=>
  array(1) {
    [1]=>
    int(1)
  }
  [1]=>
  array(1) {
    [2]=>
    int(2)
  }
  [2]=>
  array(1) {
    [3]=>
    int(3)
  }
}
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[2]
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(1) {
    [3]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[3]
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(3) {
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}


===========================================
array(2) {
  [0]=>
  int(0)
  [3]=>
  int(2)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [3]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}

[2]
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [3]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(2)
  }
}


===========================================
array(3) {
  [1]=>
  int(1)
  [5]=>
  int(2)
  [8]=>
  int(3)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(3) {
  [0]=>
  array(1) {
    [1]=>
    int(1)
  }
  [1]=>
  array(1) {
    [5]=>
    int(2)
  }
  [2]=>
  array(1) {
    [8]=>
    int(3)
  }
}
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[2]
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [1]=>
    int(1)
    [5]=>
    int(2)
  }
  [1]=>
  array(1) {
    [8]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[3]
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(3) {
    [1]=>
    int(1)
    [5]=>
    int(2)
    [8]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}


===========================================
array(2) {
  [0]=>
  int(1)
  [1]=>
  int(2)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [1]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}

[2]
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
}


===========================================
array(3) {
  [0]=>
  int(0)
  [1]=>
  int(1)
  [2]=>
  int(2)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(1)
  }
  [2]=>
  array(1) {
    [0]=>
    int(2)
  }
}
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [1]=>
    int(1)
  }
  [2]=>
  array(1) {
    [2]=>
    int(2)
  }
}
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(1)
  }
  [2]=>
  array(1) {
    [0]=>
    int(2)
  }
}

[2]
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(1) {
    [2]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}

[3]
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
}


===========================================
array(3) {
  [0]=>
  int(1)
  [1]=>
  int(2)
  [2]=>
  int(3)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [1]=>
    int(2)
  }
  [2]=>
  array(1) {
    [2]=>
    int(3)
  }
}
array(3) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[2]
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [2]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[3]
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
}


===========================================
array(4) {
  [0]=>
  int(0)
  [1]=>
  int(1)
  [2]=>
  int(2)
  [3]=>
  int(3)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(4) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(1)
  }
  [2]=>
  array(1) {
    [0]=>
    int(2)
  }
  [3]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(4) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [1]=>
    int(1)
  }
  [2]=>
  array(1) {
    [2]=>
    int(2)
  }
  [3]=>
  array(1) {
    [3]=>
    int(3)
  }
}
array(4) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(1)
  }
  [2]=>
  array(1) {
    [0]=>
    int(2)
  }
  [3]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[2]
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [0]=>
    int(2)
    [1]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [0]=>
    int(2)
    [1]=>
    int(3)
  }
}

[3]
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(1) {
    [3]=>
    int(3)
  }
}
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(1) {
    [0]=>
    int(3)
  }
}

[4]
array(1) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
}
array(1) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
}


===========================================
array(4) {
  [0]=>
  int(1)
  [1]=>
  int(2)
  [2]=>
  int(3)
  [3]=>
  int(4)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(4) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
  [3]=>
  array(1) {
    [0]=>
    int(4)
  }
}
array(4) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [1]=>
    int(2)
  }
  [2]=>
  array(1) {
    [2]=>
    int(3)
  }
  [3]=>
  array(1) {
    [3]=>
    int(4)
  }
}
array(4) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
  [3]=>
  array(1) {
    [0]=>
    int(4)
  }
}

[2]
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(2) {
    [0]=>
    int(3)
    [1]=>
    int(4)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(2) {
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
}
array(2) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(2) {
    [0]=>
    int(3)
    [1]=>
    int(4)
  }
}

[3]
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
  [1]=>
  array(1) {
    [0]=>
    int(4)
  }
}
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
  [1]=>
  array(1) {
    [3]=>
    int(4)
  }
}
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
  [1]=>
  array(1) {
    [0]=>
    int(4)
  }
}

[4]
array(1) {
  [0]=>
  array(4) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
}
array(1) {
  [0]=>
  array(4) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
}
array(1) {
  [0]=>
  array(4) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
}


===========================================
array(5) {
  [0]=>
  int(0)
  [1]=>
  int(1)
  [2]=>
  int(2)
  [3]=>
  int(3)
  [4]=>
  int(4)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(5) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(1)
  }
  [2]=>
  array(1) {
    [0]=>
    int(2)
  }
  [3]=>
  array(1) {
    [0]=>
    int(3)
  }
  [4]=>
  array(1) {
    [0]=>
    int(4)
  }
}
array(5) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [1]=>
    int(1)
  }
  [2]=>
  array(1) {
    [2]=>
    int(2)
  }
  [3]=>
  array(1) {
    [3]=>
    int(3)
  }
  [4]=>
  array(1) {
    [4]=>
    int(4)
  }
}
array(5) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(1)
  }
  [2]=>
  array(1) {
    [0]=>
    int(2)
  }
  [3]=>
  array(1) {
    [0]=>
    int(3)
  }
  [4]=>
  array(1) {
    [0]=>
    int(4)
  }
}

[2]
array(3) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [0]=>
    int(2)
    [1]=>
    int(3)
  }
  [2]=>
  array(1) {
    [0]=>
    int(4)
  }
}
array(3) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
  [2]=>
  array(1) {
    [4]=>
    int(4)
  }
}
array(3) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [0]=>
    int(2)
    [1]=>
    int(3)
  }
  [2]=>
  array(1) {
    [0]=>
    int(4)
  }
}

[3]
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(2) {
    [0]=>
    int(3)
    [1]=>
    int(4)
  }
}
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(2) {
    [3]=>
    int(3)
    [4]=>
    int(4)
  }
}
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(2) {
    [0]=>
    int(3)
    [1]=>
    int(4)
  }
}

[4]
array(2) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
  [1]=>
  array(1) {
    [0]=>
    int(4)
  }
}
array(2) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
  [1]=>
  array(1) {
    [4]=>
    int(4)
  }
}
array(2) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
  [1]=>
  array(1) {
    [0]=>
    int(4)
  }
}

[5]
array(1) {
  [0]=>
  array(5) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
  }
}
array(1) {
  [0]=>
  array(5) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
  }
}
array(1) {
  [0]=>
  array(5) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
  }
}


===========================================
array(10) {
  [0]=>
  int(1)
  [1]=>
  int(2)
  [2]=>
  int(3)
  [3]=>
  int(4)
  [4]=>
  int(5)
  [5]=>
  int(6)
  [6]=>
  int(7)
  [7]=>
  int(8)
  [8]=>
  int(9)
  [9]=>
  int(10)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(10) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
  [3]=>
  array(1) {
    [0]=>
    int(4)
  }
  [4]=>
  array(1) {
    [0]=>
    int(5)
  }
  [5]=>
  array(1) {
    [0]=>
    int(6)
  }
  [6]=>
  array(1) {
    [0]=>
    int(7)
  }
  [7]=>
  array(1) {
    [0]=>
    int(8)
  }
  [8]=>
  array(1) {
    [0]=>
    int(9)
  }
  [9]=>
  array(1) {
    [0]=>
    int(10)
  }
}
array(10) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [1]=>
    int(2)
  }
  [2]=>
  array(1) {
    [2]=>
    int(3)
  }
  [3]=>
  array(1) {
    [3]=>
    int(4)
  }
  [4]=>
  array(1) {
    [4]=>
    int(5)
  }
  [5]=>
  array(1) {
    [5]=>
    int(6)
  }
  [6]=>
  array(1) {
    [6]=>
    int(7)
  }
  [7]=>
  array(1) {
    [7]=>
    int(8)
  }
  [8]=>
  array(1) {
    [8]=>
    int(9)
  }
  [9]=>
  array(1) {
    [9]=>
    int(10)
  }
}
array(10) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
  [3]=>
  array(1) {
    [0]=>
    int(4)
  }
  [4]=>
  array(1) {
    [0]=>
    int(5)
  }
  [5]=>
  array(1) {
    [0]=>
    int(6)
  }
  [6]=>
  array(1) {
    [0]=>
    int(7)
  }
  [7]=>
  array(1) {
    [0]=>
    int(8)
  }
  [8]=>
  array(1) {
    [0]=>
    int(9)
  }
  [9]=>
  array(1) {
    [0]=>
    int(10)
  }
}

[2]
array(5) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(2) {
    [0]=>
    int(3)
    [1]=>
    int(4)
  }
  [2]=>
  array(2) {
    [0]=>
    int(5)
    [1]=>
    int(6)
  }
  [3]=>
  array(2) {
    [0]=>
    int(7)
    [1]=>
    int(8)
  }
  [4]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}
array(5) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(2) {
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
  [2]=>
  array(2) {
    [4]=>
    int(5)
    [5]=>
    int(6)
  }
  [3]=>
  array(2) {
    [6]=>
    int(7)
    [7]=>
    int(8)
  }
  [4]=>
  array(2) {
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}
array(5) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(2) {
    [0]=>
    int(3)
    [1]=>
    int(4)
  }
  [2]=>
  array(2) {
    [0]=>
    int(5)
    [1]=>
    int(6)
  }
  [3]=>
  array(2) {
    [0]=>
    int(7)
    [1]=>
    int(8)
  }
  [4]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}

[3]
array(4) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
  [1]=>
  array(3) {
    [0]=>
    int(4)
    [1]=>
    int(5)
    [2]=>
    int(6)
  }
  [2]=>
  array(3) {
    [0]=>
    int(7)
    [1]=>
    int(8)
    [2]=>
    int(9)
  }
  [3]=>
  array(1) {
    [0]=>
    int(10)
  }
}
array(4) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
  [1]=>
  array(3) {
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
  }
  [2]=>
  array(3) {
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
  }
  [3]=>
  array(1) {
    [9]=>
    int(10)
  }
}
array(4) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
  [1]=>
  array(3) {
    [0]=>
    int(4)
    [1]=>
    int(5)
    [2]=>
    int(6)
  }
  [2]=>
  array(3) {
    [0]=>
    int(7)
    [1]=>
    int(8)
    [2]=>
    int(9)
  }
  [3]=>
  array(1) {
    [0]=>
    int(10)
  }
}

[4]
array(3) {
  [0]=>
  array(4) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
  [1]=>
  array(4) {
    [0]=>
    int(5)
    [1]=>
    int(6)
    [2]=>
    int(7)
    [3]=>
    int(8)
  }
  [2]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}
array(3) {
  [0]=>
  array(4) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
  [1]=>
  array(4) {
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
  }
  [2]=>
  array(2) {
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}
array(3) {
  [0]=>
  array(4) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
  [1]=>
  array(4) {
    [0]=>
    int(5)
    [1]=>
    int(6)
    [2]=>
    int(7)
    [3]=>
    int(8)
  }
  [2]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}

[5]
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
  }
  [1]=>
  array(5) {
    [0]=>
    int(6)
    [1]=>
    int(7)
    [2]=>
    int(8)
    [3]=>
    int(9)
    [4]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
  }
  [1]=>
  array(5) {
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
  }
  [1]=>
  array(5) {
    [0]=>
    int(6)
    [1]=>
    int(7)
    [2]=>
    int(8)
    [3]=>
    int(9)
    [4]=>
    int(10)
  }
}

[6]
array(2) {
  [0]=>
  array(6) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
  }
  [1]=>
  array(4) {
    [0]=>
    int(7)
    [1]=>
    int(8)
    [2]=>
    int(9)
    [3]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(6) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
  }
  [1]=>
  array(4) {
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(6) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
  }
  [1]=>
  array(4) {
    [0]=>
    int(7)
    [1]=>
    int(8)
    [2]=>
    int(9)
    [3]=>
    int(10)
  }
}

[7]
array(2) {
  [0]=>
  array(7) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
  }
  [1]=>
  array(3) {
    [0]=>
    int(8)
    [1]=>
    int(9)
    [2]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(7) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
  }
  [1]=>
  array(3) {
    [7]=>
    int(8)
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(7) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
  }
  [1]=>
  array(3) {
    [0]=>
    int(8)
    [1]=>
    int(9)
    [2]=>
    int(10)
  }
}

[8]
array(2) {
  [0]=>
  array(8) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
  }
  [1]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(8) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
  }
  [1]=>
  array(2) {
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(8) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
  }
  [1]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}

[9]
array(2) {
  [0]=>
  array(9) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
  }
  [1]=>
  array(1) {
    [0]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(9) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
  }
  [1]=>
  array(1) {
    [9]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(9) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
  }
  [1]=>
  array(1) {
    [0]=>
    int(10)
  }
}

[10]
array(1) {
  [0]=>
  array(10) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}
array(1) {
  [0]=>
  array(10) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}
array(1) {
  [0]=>
  array(10) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
    [6]=>
    int(7)
    [7]=>
    int(8)
    [8]=>
    int(9)
    [9]=>
    int(10)
  }
}


===========================================
array(11) {
  [0]=>
  int(0)
  [1]=>
  int(1)
  [2]=>
  int(2)
  [3]=>
  int(3)
  [4]=>
  int(4)
  [5]=>
  int(5)
  [6]=>
  int(6)
  [7]=>
  int(7)
  [8]=>
  int(8)
  [9]=>
  int(9)
  [10]=>
  int(10)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(11) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(1)
  }
  [2]=>
  array(1) {
    [0]=>
    int(2)
  }
  [3]=>
  array(1) {
    [0]=>
    int(3)
  }
  [4]=>
  array(1) {
    [0]=>
    int(4)
  }
  [5]=>
  array(1) {
    [0]=>
    int(5)
  }
  [6]=>
  array(1) {
    [0]=>
    int(6)
  }
  [7]=>
  array(1) {
    [0]=>
    int(7)
  }
  [8]=>
  array(1) {
    [0]=>
    int(8)
  }
  [9]=>
  array(1) {
    [0]=>
    int(9)
  }
  [10]=>
  array(1) {
    [0]=>
    int(10)
  }
}
array(11) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [1]=>
    int(1)
  }
  [2]=>
  array(1) {
    [2]=>
    int(2)
  }
  [3]=>
  array(1) {
    [3]=>
    int(3)
  }
  [4]=>
  array(1) {
    [4]=>
    int(4)
  }
  [5]=>
  array(1) {
    [5]=>
    int(5)
  }
  [6]=>
  array(1) {
    [6]=>
    int(6)
  }
  [7]=>
  array(1) {
    [7]=>
    int(7)
  }
  [8]=>
  array(1) {
    [8]=>
    int(8)
  }
  [9]=>
  array(1) {
    [9]=>
    int(9)
  }
  [10]=>
  array(1) {
    [10]=>
    int(10)
  }
}
array(11) {
  [0]=>
  array(1) {
    [0]=>
    int(0)
  }
  [1]=>
  array(1) {
    [0]=>
    int(1)
  }
  [2]=>
  array(1) {
    [0]=>
    int(2)
  }
  [3]=>
  array(1) {
    [0]=>
    int(3)
  }
  [4]=>
  array(1) {
    [0]=>
    int(4)
  }
  [5]=>
  array(1) {
    [0]=>
    int(5)
  }
  [6]=>
  array(1) {
    [0]=>
    int(6)
  }
  [7]=>
  array(1) {
    [0]=>
    int(7)
  }
  [8]=>
  array(1) {
    [0]=>
    int(8)
  }
  [9]=>
  array(1) {
    [0]=>
    int(9)
  }
  [10]=>
  array(1) {
    [0]=>
    int(10)
  }
}

[2]
array(6) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [0]=>
    int(2)
    [1]=>
    int(3)
  }
  [2]=>
  array(2) {
    [0]=>
    int(4)
    [1]=>
    int(5)
  }
  [3]=>
  array(2) {
    [0]=>
    int(6)
    [1]=>
    int(7)
  }
  [4]=>
  array(2) {
    [0]=>
    int(8)
    [1]=>
    int(9)
  }
  [5]=>
  array(1) {
    [0]=>
    int(10)
  }
}
array(6) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
  [2]=>
  array(2) {
    [4]=>
    int(4)
    [5]=>
    int(5)
  }
  [3]=>
  array(2) {
    [6]=>
    int(6)
    [7]=>
    int(7)
  }
  [4]=>
  array(2) {
    [8]=>
    int(8)
    [9]=>
    int(9)
  }
  [5]=>
  array(1) {
    [10]=>
    int(10)
  }
}
array(6) {
  [0]=>
  array(2) {
    [0]=>
    int(0)
    [1]=>
    int(1)
  }
  [1]=>
  array(2) {
    [0]=>
    int(2)
    [1]=>
    int(3)
  }
  [2]=>
  array(2) {
    [0]=>
    int(4)
    [1]=>
    int(5)
  }
  [3]=>
  array(2) {
    [0]=>
    int(6)
    [1]=>
    int(7)
  }
  [4]=>
  array(2) {
    [0]=>
    int(8)
    [1]=>
    int(9)
  }
  [5]=>
  array(1) {
    [0]=>
    int(10)
  }
}

[3]
array(4) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(3) {
    [0]=>
    int(3)
    [1]=>
    int(4)
    [2]=>
    int(5)
  }
  [2]=>
  array(3) {
    [0]=>
    int(6)
    [1]=>
    int(7)
    [2]=>
    int(8)
  }
  [3]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}
array(4) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(3) {
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
  }
  [2]=>
  array(3) {
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
  }
  [3]=>
  array(2) {
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}
array(4) {
  [0]=>
  array(3) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
  }
  [1]=>
  array(3) {
    [0]=>
    int(3)
    [1]=>
    int(4)
    [2]=>
    int(5)
  }
  [2]=>
  array(3) {
    [0]=>
    int(6)
    [1]=>
    int(7)
    [2]=>
    int(8)
  }
  [3]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}

[4]
array(3) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
  [1]=>
  array(4) {
    [0]=>
    int(4)
    [1]=>
    int(5)
    [2]=>
    int(6)
    [3]=>
    int(7)
  }
  [2]=>
  array(3) {
    [0]=>
    int(8)
    [1]=>
    int(9)
    [2]=>
    int(10)
  }
}
array(3) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
  [1]=>
  array(4) {
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
  }
  [2]=>
  array(3) {
    [8]=>
    int(8)
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}
array(3) {
  [0]=>
  array(4) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
  }
  [1]=>
  array(4) {
    [0]=>
    int(4)
    [1]=>
    int(5)
    [2]=>
    int(6)
    [3]=>
    int(7)
  }
  [2]=>
  array(3) {
    [0]=>
    int(8)
    [1]=>
    int(9)
    [2]=>
    int(10)
  }
}

[5]
array(3) {
  [0]=>
  array(5) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
  }
  [1]=>
  array(5) {
    [0]=>
    int(5)
    [1]=>
    int(6)
    [2]=>
    int(7)
    [3]=>
    int(8)
    [4]=>
    int(9)
  }
  [2]=>
  array(1) {
    [0]=>
    int(10)
  }
}
array(3) {
  [0]=>
  array(5) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
  }
  [1]=>
  array(5) {
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
  }
  [2]=>
  array(1) {
    [10]=>
    int(10)
  }
}
array(3) {
  [0]=>
  array(5) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
  }
  [1]=>
  array(5) {
    [0]=>
    int(5)
    [1]=>
    int(6)
    [2]=>
    int(7)
    [3]=>
    int(8)
    [4]=>
    int(9)
  }
  [2]=>
  array(1) {
    [0]=>
    int(10)
  }
}

[6]
array(2) {
  [0]=>
  array(6) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
  }
  [1]=>
  array(5) {
    [0]=>
    int(6)
    [1]=>
    int(7)
    [2]=>
    int(8)
    [3]=>
    int(9)
    [4]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(6) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
  }
  [1]=>
  array(5) {
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(6) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
  }
  [1]=>
  array(5) {
    [0]=>
    int(6)
    [1]=>
    int(7)
    [2]=>
    int(8)
    [3]=>
    int(9)
    [4]=>
    int(10)
  }
}

[7]
array(2) {
  [0]=>
  array(7) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
  }
  [1]=>
  array(4) {
    [0]=>
    int(7)
    [1]=>
    int(8)
    [2]=>
    int(9)
    [3]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(7) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
  }
  [1]=>
  array(4) {
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(7) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
  }
  [1]=>
  array(4) {
    [0]=>
    int(7)
    [1]=>
    int(8)
    [2]=>
    int(9)
    [3]=>
    int(10)
  }
}

[8]
array(2) {
  [0]=>
  array(8) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
  }
  [1]=>
  array(3) {
    [0]=>
    int(8)
    [1]=>
    int(9)
    [2]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(8) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
  }
  [1]=>
  array(3) {
    [8]=>
    int(8)
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(8) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
  }
  [1]=>
  array(3) {
    [0]=>
    int(8)
    [1]=>
    int(9)
    [2]=>
    int(10)
  }
}

[9]
array(2) {
  [0]=>
  array(9) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
  }
  [1]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(9) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
  }
  [1]=>
  array(2) {
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(9) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
  }
  [1]=>
  array(2) {
    [0]=>
    int(9)
    [1]=>
    int(10)
  }
}

[10]
array(2) {
  [0]=>
  array(10) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
  }
  [1]=>
  array(1) {
    [0]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(10) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
  }
  [1]=>
  array(1) {
    [10]=>
    int(10)
  }
}
array(2) {
  [0]=>
  array(10) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
  }
  [1]=>
  array(1) {
    [0]=>
    int(10)
  }
}

[11]
array(1) {
  [0]=>
  array(11) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}
array(1) {
  [0]=>
  array(11) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}
array(1) {
  [0]=>
  array(11) {
    [0]=>
    int(0)
    [1]=>
    int(1)
    [2]=>
    int(2)
    [3]=>
    int(3)
    [4]=>
    int(4)
    [5]=>
    int(5)
    [6]=>
    int(6)
    [7]=>
    int(7)
    [8]=>
    int(8)
    [9]=>
    int(9)
    [10]=>
    int(10)
  }
}


===========================================
array(1) {
  ["a"]=>
  int(1)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
}
array(1) {
  [0]=>
  array(1) {
    ["a"]=>
    int(1)
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
}


===========================================
array(2) {
  ["b"]=>
  int(1)
  ["c"]=>
  int(2)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    ["b"]=>
    int(1)
  }
  [1]=>
  array(1) {
    ["c"]=>
    int(2)
  }
}
array(2) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
}

[2]
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    ["b"]=>
    int(1)
    ["c"]=>
    int(2)
  }
}
array(1) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
}


===========================================
array(6) {
  ["p"]=>
  int(1)
  ["q"]=>
  int(2)
  ["r"]=>
  int(3)
  ["s"]=>
  int(4)
  ["u"]=>
  int(5)
  ["v"]=>
  int(6)
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(6) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
  [3]=>
  array(1) {
    [0]=>
    int(4)
  }
  [4]=>
  array(1) {
    [0]=>
    int(5)
  }
  [5]=>
  array(1) {
    [0]=>
    int(6)
  }
}
array(6) {
  [0]=>
  array(1) {
    ["p"]=>
    int(1)
  }
  [1]=>
  array(1) {
    ["q"]=>
    int(2)
  }
  [2]=>
  array(1) {
    ["r"]=>
    int(3)
  }
  [3]=>
  array(1) {
    ["s"]=>
    int(4)
  }
  [4]=>
  array(1) {
    ["u"]=>
    int(5)
  }
  [5]=>
  array(1) {
    ["v"]=>
    int(6)
  }
}
array(6) {
  [0]=>
  array(1) {
    [0]=>
    int(1)
  }
  [1]=>
  array(1) {
    [0]=>
    int(2)
  }
  [2]=>
  array(1) {
    [0]=>
    int(3)
  }
  [3]=>
  array(1) {
    [0]=>
    int(4)
  }
  [4]=>
  array(1) {
    [0]=>
    int(5)
  }
  [5]=>
  array(1) {
    [0]=>
    int(6)
  }
}

[2]
array(3) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(2) {
    [0]=>
    int(3)
    [1]=>
    int(4)
  }
  [2]=>
  array(2) {
    [0]=>
    int(5)
    [1]=>
    int(6)
  }
}
array(3) {
  [0]=>
  array(2) {
    ["p"]=>
    int(1)
    ["q"]=>
    int(2)
  }
  [1]=>
  array(2) {
    ["r"]=>
    int(3)
    ["s"]=>
    int(4)
  }
  [2]=>
  array(2) {
    ["u"]=>
    int(5)
    ["v"]=>
    int(6)
  }
}
array(3) {
  [0]=>
  array(2) {
    [0]=>
    int(1)
    [1]=>
    int(2)
  }
  [1]=>
  array(2) {
    [0]=>
    int(3)
    [1]=>
    int(4)
  }
  [2]=>
  array(2) {
    [0]=>
    int(5)
    [1]=>
    int(6)
  }
}

[3]
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
  [1]=>
  array(3) {
    [0]=>
    int(4)
    [1]=>
    int(5)
    [2]=>
    int(6)
  }
}
array(2) {
  [0]=>
  array(3) {
    ["p"]=>
    int(1)
    ["q"]=>
    int(2)
    ["r"]=>
    int(3)
  }
  [1]=>
  array(3) {
    ["s"]=>
    int(4)
    ["u"]=>
    int(5)
    ["v"]=>
    int(6)
  }
}
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
  }
  [1]=>
  array(3) {
    [0]=>
    int(4)
    [1]=>
    int(5)
    [2]=>
    int(6)
  }
}

[4]
array(2) {
  [0]=>
  array(4) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
  [1]=>
  array(2) {
    [0]=>
    int(5)
    [1]=>
    int(6)
  }
}
array(2) {
  [0]=>
  array(4) {
    ["p"]=>
    int(1)
    ["q"]=>
    int(2)
    ["r"]=>
    int(3)
    ["s"]=>
    int(4)
  }
  [1]=>
  array(2) {
    ["u"]=>
    int(5)
    ["v"]=>
    int(6)
  }
}
array(2) {
  [0]=>
  array(4) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
  }
  [1]=>
  array(2) {
    [0]=>
    int(5)
    [1]=>
    int(6)
  }
}

[5]
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
  }
  [1]=>
  array(1) {
    [0]=>
    int(6)
  }
}
array(2) {
  [0]=>
  array(5) {
    ["p"]=>
    int(1)
    ["q"]=>
    int(2)
    ["r"]=>
    int(3)
    ["s"]=>
    int(4)
    ["u"]=>
    int(5)
  }
  [1]=>
  array(1) {
    ["v"]=>
    int(6)
  }
}
array(2) {
  [0]=>
  array(5) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
  }
  [1]=>
  array(1) {
    [0]=>
    int(6)
  }
}

[6]
array(1) {
  [0]=>
  array(6) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
  }
}
array(1) {
  [0]=>
  array(6) {
    ["p"]=>
    int(1)
    ["q"]=>
    int(2)
    ["r"]=>
    int(3)
    ["s"]=>
    int(4)
    ["u"]=>
    int(5)
    ["v"]=>
    int(6)
  }
}
array(1) {
  [0]=>
  array(6) {
    [0]=>
    int(1)
    [1]=>
    int(2)
    [2]=>
    int(3)
    [3]=>
    int(4)
    [4]=>
    int(5)
    [5]=>
    int(6)
  }
}


===========================================
array(1) {
  ["a"]=>
  string(1) "A"
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(1) {
  [0]=>
  array(1) {
    [0]=>
    string(1) "A"
  }
}
array(1) {
  [0]=>
  array(1) {
    ["a"]=>
    string(1) "A"
  }
}
array(1) {
  [0]=>
  array(1) {
    [0]=>
    string(1) "A"
  }
}


===========================================
array(6) {
  ["p"]=>
  string(1) "A"
  ["q"]=>
  string(1) "B"
  ["r"]=>
  string(1) "C"
  ["s"]=>
  string(1) "D"
  ["u"]=>
  string(1) "E"
  ["v"]=>
  string(1) "F"
}
-------------------------------------------
[0]
NULL
NULL
NULL

[1]
array(6) {
  [0]=>
  array(1) {
    [0]=>
    string(1) "A"
  }
  [1]=>
  array(1) {
    [0]=>
    string(1) "B"
  }
  [2]=>
  array(1) {
    [0]=>
    string(1) "C"
  }
  [3]=>
  array(1) {
    [0]=>
    string(1) "D"
  }
  [4]=>
  array(1) {
    [0]=>
    string(1) "E"
  }
  [5]=>
  array(1) {
    [0]=>
    string(1) "F"
  }
}
array(6) {
  [0]=>
  array(1) {
    ["p"]=>
    string(1) "A"
  }
  [1]=>
  array(1) {
    ["q"]=>
    string(1) "B"
  }
  [2]=>
  array(1) {
    ["r"]=>
    string(1) "C"
  }
  [3]=>
  array(1) {
    ["s"]=>
    string(1) "D"
  }
  [4]=>
  array(1) {
    ["u"]=>
    string(1) "E"
  }
  [5]=>
  array(1) {
    ["v"]=>
    string(1) "F"
  }
}
array(6) {
  [0]=>
  array(1) {
    [0]=>
    string(1) "A"
  }
  [1]=>
  array(1) {
    [0]=>
    string(1) "B"
  }
  [2]=>
  array(1) {
    [0]=>
    string(1) "C"
  }
  [3]=>
  array(1) {
    [0]=>
    string(1) "D"
  }
  [4]=>
  array(1) {
    [0]=>
    string(1) "E"
  }
  [5]=>
  array(1) {
    [0]=>
    string(1) "F"
  }
}

[2]
array(3) {
  [0]=>
  array(2) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
  }
  [1]=>
  array(2) {
    [0]=>
    string(1) "C"
    [1]=>
    string(1) "D"
  }
  [2]=>
  array(2) {
    [0]=>
    string(1) "E"
    [1]=>
    string(1) "F"
  }
}
array(3) {
  [0]=>
  array(2) {
    ["p"]=>
    string(1) "A"
    ["q"]=>
    string(1) "B"
  }
  [1]=>
  array(2) {
    ["r"]=>
    string(1) "C"
    ["s"]=>
    string(1) "D"
  }
  [2]=>
  array(2) {
    ["u"]=>
    string(1) "E"
    ["v"]=>
    string(1) "F"
  }
}
array(3) {
  [0]=>
  array(2) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
  }
  [1]=>
  array(2) {
    [0]=>
    string(1) "C"
    [1]=>
    string(1) "D"
  }
  [2]=>
  array(2) {
    [0]=>
    string(1) "E"
    [1]=>
    string(1) "F"
  }
}

[3]
array(2) {
  [0]=>
  array(3) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
    [2]=>
    string(1) "C"
  }
  [1]=>
  array(3) {
    [0]=>
    string(1) "D"
    [1]=>
    string(1) "E"
    [2]=>
    string(1) "F"
  }
}
array(2) {
  [0]=>
  array(3) {
    ["p"]=>
    string(1) "A"
    ["q"]=>
    string(1) "B"
    ["r"]=>
    string(1) "C"
  }
  [1]=>
  array(3) {
    ["s"]=>
    string(1) "D"
    ["u"]=>
    string(1) "E"
    ["v"]=>
    string(1) "F"
  }
}
array(2) {
  [0]=>
  array(3) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
    [2]=>
    string(1) "C"
  }
  [1]=>
  array(3) {
    [0]=>
    string(1) "D"
    [1]=>
    string(1) "E"
    [2]=>
    string(1) "F"
  }
}

[4]
array(2) {
  [0]=>
  array(4) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
    [2]=>
    string(1) "C"
    [3]=>
    string(1) "D"
  }
  [1]=>
  array(2) {
    [0]=>
    string(1) "E"
    [1]=>
    string(1) "F"
  }
}
array(2) {
  [0]=>
  array(4) {
    ["p"]=>
    string(1) "A"
    ["q"]=>
    string(1) "B"
    ["r"]=>
    string(1) "C"
    ["s"]=>
    string(1) "D"
  }
  [1]=>
  array(2) {
    ["u"]=>
    string(1) "E"
    ["v"]=>
    string(1) "F"
  }
}
array(2) {
  [0]=>
  array(4) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
    [2]=>
    string(1) "C"
    [3]=>
    string(1) "D"
  }
  [1]=>
  array(2) {
    [0]=>
    string(1) "E"
    [1]=>
    string(1) "F"
  }
}

[5]
array(2) {
  [0]=>
  array(5) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
    [2]=>
    string(1) "C"
    [3]=>
    string(1) "D"
    [4]=>
    string(1) "E"
  }
  [1]=>
  array(1) {
    [0]=>
    string(1) "F"
  }
}
array(2) {
  [0]=>
  array(5) {
    ["p"]=>
    string(1) "A"
    ["q"]=>
    string(1) "B"
    ["r"]=>
    string(1) "C"
    ["s"]=>
    string(1) "D"
    ["u"]=>
    string(1) "E"
  }
  [1]=>
  array(1) {
    ["v"]=>
    string(1) "F"
  }
}
array(2) {
  [0]=>
  array(5) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
    [2]=>
    string(1) "C"
    [3]=>
    string(1) "D"
    [4]=>
    string(1) "E"
  }
  [1]=>
  array(1) {
    [0]=>
    string(1) "F"
  }
}

[6]
array(1) {
  [0]=>
  array(6) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
    [2]=>
    string(1) "C"
    [3]=>
    string(1) "D"
    [4]=>
    string(1) "E"
    [5]=>
    string(1) "F"
  }
}
array(1) {
  [0]=>
  array(6) {
    ["p"]=>
    string(1) "A"
    ["q"]=>
    string(1) "B"
    ["r"]=>
    string(1) "C"
    ["s"]=>
    string(1) "D"
    ["u"]=>
    string(1) "E"
    ["v"]=>
    string(1) "F"
  }
}
array(1) {
  [0]=>
  array(6) {
    [0]=>
    string(1) "A"
    [1]=>
    string(1) "B"
    [2]=>
    string(1) "C"
    [3]=>
    string(1) "D"
    [4]=>
    string(1) "E"
    [5]=>
    string(1) "F"
  }
}


end
