/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;

public abstract class ControlFactory {
    protected ControlFactory() {
    }

    public abstract Control getControlInstance(Control var1) throws NamingException;

    public static Control getControlInstance(Control control, Context ctx, Hashtable env) throws NamingException {
        String path = (String)env.get("java.naming.factory.control");
        String path2 = null;
        if (ctx != null) {
            path2 = (String)ctx.getEnvironment().get("java.naming.factory.control");
        }
        if (path == null) {
            path = path2;
        } else if (path2 != null) {
            path = path + new StringBuffer(":").append(path2);
        }
        StringTokenizer tokens = new StringTokenizer(path, ":");
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            try {
                Class k = Class.forName(name);
                ControlFactory cf = (ControlFactory)k.newInstance();
                Control ctrl = cf.getControlInstance(control);
                if (ctrl == null) continue;
                return ctrl;
            }
            catch (ClassNotFoundException _1) {
            }
            catch (ClassCastException _2) {
            }
            catch (InstantiationException _3) {
            }
            catch (IllegalAccessException _4) {
            }
        }
        return control;
    }
}

