/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Timestamp
extends Date {
    static final long serialVersionUID = 2745179027874758501L;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int nanos;

    public static Timestamp valueOf(String str) {
        int nanos = 0;
        int dot = str.indexOf(46);
        if (dot != -1) {
            if (str.lastIndexOf(46) != dot) {
                throw new IllegalArgumentException(str);
            }
            int len = str.length() - dot - 1;
            if (len < 1 || len > 9) {
                throw new IllegalArgumentException(str);
            }
            nanos = Integer.parseInt(str.substring(dot + 1));
            for (int i = len; i < 9; ++i) {
                nanos *= 10;
            }
            str = str.substring(0, dot);
        }
        try {
            Date d = (Date)sdf.parseObject(str);
            if (d == null) {
                throw new IllegalArgumentException(str);
            }
            Timestamp ts = new Timestamp(d.getTime() + (long)(nanos / 1000000));
            ts.nanos = nanos;
            return ts;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(str);
        }
    }

    public Timestamp(int year, int month, int day, int hour, int minute, int second, int nanos) {
        super(year, month, day, hour, minute, second);
        this.nanos = nanos;
    }

    public Timestamp(long date) {
        super(date);
    }

    public String toString() {
        return sdf.format(this) + "." + this.getNanos();
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int nanos) {
        this.nanos = nanos;
    }

    public boolean before(Timestamp ts) {
        if (ts.getTime() > this.getTime()) {
            return true;
        }
        return ts.getNanos() > this.getNanos();
    }

    public boolean after(Timestamp ts) {
        if (ts.getTime() < this.getTime()) {
            return true;
        }
        return ts.getNanos() < this.getNanos();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Timestamp)) {
            return false;
        }
        return this.equals((Timestamp)obj);
    }

    public boolean equals(Timestamp ts) {
        if (ts == null) {
            return false;
        }
        if (ts.getTime() != this.getTime()) {
            return false;
        }
        return ts.getNanos() == this.getNanos();
    }

    public int compareTo(Timestamp ts) {
        int s = super.compareTo(ts);
        if (s != 0) {
            return s;
        }
        return this.nanos - ts.nanos;
    }

    public int compareTo(Object obj) {
        return this.compareTo((Timestamp)obj);
    }
}

