/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.lang.reflect.TypeSignature;

public class ObjectStreamField
implements Comparable {
    private String name;
    private Class type;
    private String typename;
    private int offset;
    private boolean unshared;
    private boolean persistent;
    private boolean toset;

    private /* synthetic */ void finit$() {
        this.offset = -1;
        this.persistent = false;
        this.toset = true;
    }

    public ObjectStreamField(String name, Class type) {
        this(name, type, false);
    }

    public ObjectStreamField(String name, Class type, boolean unshared) {
        this.finit$();
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.type = type;
        this.typename = TypeSignature.getEncodingOfClass(type);
        this.unshared = unshared;
    }

    ObjectStreamField(String name, String typename) {
        this.finit$();
        this.name = name;
        this.typename = typename;
        try {
            this.type = TypeSignature.getClassForEncoding(typename);
        }
        catch (ClassNotFoundException e) {
            this.type = ObjectStreamField.class$("java.lang.Object");
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    ObjectStreamField(String name, String typename, ClassLoader loader) {
        this.finit$();
        this.name = name;
        this.typename = typename;
        try {
            this.type = TypeSignature.getClassForEncoding(typename, true, loader);
        }
        catch (ClassNotFoundException e) {
            this.type = ObjectStreamField.class$("java.lang.Object");
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public char getTypeCode() {
        return this.typename.charAt(0);
    }

    public String getTypeString() {
        if (this.type.isPrimitive()) {
            return null;
        }
        return this.typename.intern();
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int off) {
        this.offset = off;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    public int compareTo(Object o) {
        ObjectStreamField f = (ObjectStreamField)o;
        boolean this_is_primitive = this.isPrimitive();
        boolean f_is_primitive = f.isPrimitive();
        if (this_is_primitive && !f_is_primitive) {
            return -1;
        }
        if (!this_is_primitive && f_is_primitive) {
            return 1;
        }
        return this.getName().compareTo(f.getName());
    }

    void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    boolean isPersistent() {
        return this.persistent;
    }

    void setToSet(boolean toset) {
        this.toset = toset;
    }

    boolean isToSet() {
        return this.toset;
    }

    public String toString() {
        return "ObjectStreamField< " + this.type + " " + this.name + " >";
    }
}

