/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;

class LightweightDispatcher
implements Serializable {
    private static final long serialVersionUID = 5184291520170872969L;
    private Container nativeContainer;
    private Component focus;
    private Cursor nativeCursor;
    private long eventMask;
    private transient Component mouseEventTarget;

    LightweightDispatcher(Container c) {
        this.nativeContainer = c;
    }

    void dispose() {
    }

    void enableEvents(long l) {
        this.eventMask |= l;
    }

    void mouseExit(MouseEvent me, int x, int y) {
    }

    void acquireComponentForMouseEvent(MouseEvent me) {
        int ny;
        int nx;
        boolean candidate_does_not_contain_point;
        int x = me.getX();
        int y = me.getY();
        Component candidate = this.mouseEventTarget;
        boolean candidate_is_container_with_children = candidate != null && candidate instanceof Container && ((Container)candidate).getComponentCount() > 0;
        boolean bl = candidate_does_not_contain_point = candidate != null && !candidate.contains(x - candidate.getX(), y - candidate.getY());
        if (candidate == null || candidate_is_container_with_children || candidate_does_not_contain_point) {
            candidate = this.nativeContainer.findComponentAt(x, y);
        }
        if (this.mouseEventTarget != null && this.mouseEventTarget != candidate) {
            nx = x - this.mouseEventTarget.getX();
            ny = y - this.mouseEventTarget.getY();
            MouseEvent exited = new MouseEvent(this.mouseEventTarget, 505, me.getWhen(), me.getModifiers(), nx, ny, me.getClickCount(), me.isPopupTrigger(), me.getButton());
            this.mouseEventTarget.dispatchEvent(exited);
            this.mouseEventTarget = null;
        }
        if (candidate != null && candidate.isLightweight() && candidate != this.nativeContainer && candidate != this.mouseEventTarget) {
            this.mouseEventTarget = candidate;
            nx = x - this.mouseEventTarget.getX();
            ny = y - this.mouseEventTarget.getY();
            MouseEvent entered = new MouseEvent(this.mouseEventTarget, 504, me.getWhen(), me.getModifiers(), nx, ny, me.getClickCount(), me.isPopupTrigger(), me.getButton());
            this.mouseEventTarget.dispatchEvent(entered);
        }
    }

    boolean handleEvent(AWTEvent e) {
        if ((this.eventMask & (long)e.getID()) == 0L) {
            return false;
        }
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            this.acquireComponentForMouseEvent(me);
            if (this.mouseEventTarget != null) {
                Component oldSource = (Component)me.getSource();
                me.setSource(this.mouseEventTarget);
                this.mouseEventTarget.dispatchEvent(me);
                me.setSource(oldSource);
            }
        } else if (e instanceof KeyEvent && this.focus != null) {
            this.focus.processKeyEvent((KeyEvent)e);
        }
        return e.isConsumed();
    }
}

