/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Configuration;
import gnu.java.awt.peer.gtk.GdkClasspathFontPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class GdkGlyphVector
extends GlyphVector {
    private final int native_state;
    private Font font;
    private FontRenderContext ctx;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
    }

    static native void initStaticState();

    private native void initState(GdkClasspathFontPeer var1, FontRenderContext var2);

    private native void setChars(String var1);

    private native void setGlyphCodes(int[] var1);

    private native void dispose();

    private native int glyphCode(int var1);

    private native int numGlyphs();

    private native int glyphCharIndex(int var1);

    private native double[] allLogicalExtents();

    private native double[] allInkExtents();

    private native double[] glyphLogicalExtents(int var1);

    private native double[] glyphInkExtents(int var1);

    private native boolean glyphIsHorizontal(int var1);

    private native boolean isEqual(GdkGlyphVector var1);

    public GdkGlyphVector(Font f, GdkClasspathFontPeer peer, FontRenderContext c, String s) {
        this.finit$();
        this.font = f;
        this.ctx = c;
        this.initState(peer, this.ctx);
        this.setChars(s);
    }

    public GdkGlyphVector(Font f, GdkClasspathFontPeer peer, FontRenderContext c, int[] codes) {
        this.finit$();
        this.font = f;
        this.ctx = c;
        this.initState(peer, this.ctx);
        this.setGlyphCodes(codes);
    }

    protected void finalize() {
        this.dispose();
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.ctx;
    }

    public int getGlyphCharIndex(int glyphIndex) {
        return this.glyphCharIndex(glyphIndex);
    }

    public int[] getGlyphCharIndices(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        int[] ix = codeReturn;
        if (ix == null) {
            ix = new int[numEntries];
        }
        for (int i = 0; i < numEntries; ++i) {
            ix[i] = this.glyphCharIndex(beginGlyphIndex + i);
        }
        return ix;
    }

    public int getGlyphCode(int glyphIndex) {
        return this.glyphCode(glyphIndex);
    }

    public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        int[] ix = codeReturn;
        if (ix == null) {
            ix = new int[numEntries];
        }
        for (int i = 0; i < numEntries; ++i) {
            ix[i] = this.glyphCode(beginGlyphIndex + i);
        }
        return ix;
    }

    public Shape getGlyphLogicalBounds(int glyphIndex) {
        double[] extents = this.glyphLogicalExtents(glyphIndex);
        return new Rectangle2D.Double(extents[0], extents[1], extents[2], extents[3]);
    }

    public GlyphMetrics getGlyphMetrics(int glyphIndex) {
        double[] extents = this.glyphLogicalExtents(glyphIndex);
        Rectangle2D.Double log_bounds = new Rectangle2D.Double(extents[0], extents[1], extents[2], extents[3]);
        extents = this.glyphInkExtents(glyphIndex);
        Rectangle2D.Double ink_bounds = new Rectangle2D.Double(extents[0], extents[1], extents[2], extents[3]);
        boolean is_horizontal = this.glyphIsHorizontal(glyphIndex);
        return new GlyphMetrics(is_horizontal, (float)(((RectangularShape)log_bounds).getWidth() + ((RectangularShape)log_bounds).getX()), (float)(((RectangularShape)log_bounds).getHeight() + ((RectangularShape)log_bounds).getY()), ink_bounds, 0);
    }

    public Shape getGlyphOutline(int glyphIndex) {
        throw new UnsupportedOperationException();
    }

    public Shape getGlyphOutline(int glyphIndex, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public Rectangle getGlyphPixelBounds(int glyphIndex, FontRenderContext renderFRC, float x, float y) {
        double[] extents = this.glyphInkExtents(glyphIndex);
        return new Rectangle((int)x, (int)y, (int)extents[2], (int)extents[3]);
    }

    public Point2D getGlyphPosition(int glyphIndex) {
        float[] ret = new float[2 * (glyphIndex + 1)];
        this.getGlyphPositions(0, glyphIndex + 1, ret);
        return new Point2D.Float(ret[2 * glyphIndex], ret[2 * glyphIndex + 1]);
    }

    public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, float[] positionReturn) {
        float[] fx = positionReturn;
        if (fx == null) {
            fx = new float[numEntries * 2];
        }
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < numEntries; ++i) {
            boolean is_horizontal = this.glyphIsHorizontal(beginGlyphIndex + i);
            double[] log_extents = this.glyphLogicalExtents(beginGlyphIndex + i);
            fx[2 * i] = x + (float)log_extents[0];
            fx[2 * i + 1] = y + (float)log_extents[1];
            if (is_horizontal) {
                x += (float)log_extents[2];
                continue;
            }
            y += (float)log_extents[3];
        }
        return fx;
    }

    public AffineTransform getGlyphTransform(int glyphIndex) {
        return null;
    }

    public Shape getGlyphVisualBounds(int glyphIndex) {
        double[] extents = this.glyphInkExtents(glyphIndex);
        return new Rectangle2D.Double(extents[0], extents[1], extents[2], extents[3]);
    }

    public int getLayoutFlags() {
        return 0;
    }

    public Rectangle2D getLogicalBounds() {
        double[] extents = this.allLogicalExtents();
        return new Rectangle2D.Double(extents[0], extents[1], extents[2], extents[3]);
    }

    public int getNumGlyphs() {
        return this.numGlyphs();
    }

    public Shape getOutline() {
        throw new UnsupportedOperationException();
    }

    public Rectangle getPixelBounds(FontRenderContext renderFRC, float x, float y) {
        double[] extents = this.allInkExtents();
        return new Rectangle((int)x, (int)y, (int)extents[2], (int)extents[3]);
    }

    public Rectangle2D getVisualBounds() {
        double[] extents = this.allInkExtents();
        return new Rectangle2D.Double(extents[0], extents[1], extents[2], extents[3]);
    }

    public void performDefaultLayout() {
    }

    public void setGlyphPosition(int glyphIndex, Point2D newPos) {
        throw new UnsupportedOperationException();
    }

    public void setGlyphTransform(int glyphIndex, AffineTransform newTX) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(GlyphVector gv) {
        if (gv == null) {
            return false;
        }
        if (!(gv instanceof GdkGlyphVector)) {
            return false;
        }
        GdkGlyphVector ggv = (GdkGlyphVector)gv;
        return this.isEqual(ggv);
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int idx) {
        throw new UnsupportedOperationException();
    }

    public Shape getOutline(float x, float y) {
        throw new UnsupportedOperationException();
    }

    static {
        if (Configuration.INIT_LOAD_LIBRARY) {
            System.loadLibrary("gtkpeer");
        }
        GdkGlyphVector.initStaticState();
    }
}

