//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMMEDIAEDIT_H
#define PMMEDIAEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebaseedit.h"

class PMMedia;
class PMIntEdit;
class PMFloatEdit;
class PMColorEdit;
class QCheckBox;
class QLabel;
class QComboBox;

/**
 * Dialog edit class for @ref PMMedia
 */
class PMMediaEdit : public PMTextureBaseEdit
{
   Q_OBJECT
   typedef PMTextureBaseEdit Base;
public:
   /**
    * Creates a PMMediaEdit with parent and name
    */
   PMMediaEdit( QWidget* parent, const char* name = 0 );

   /** */
   virtual void displayObject( PMObject* o );

   /** */
   virtual bool isDataValid( );
protected:
   /** */
   virtual void createTopWidgets( );
   /** */
   virtual void saveContents( );

protected slots:
   void slotIntervalsClicked( );
   void slotSamplesClicked( );
   void slotConfidenceClicked( );
   void slotVarianceClicked( );
   void slotRatioClicked( );
   void slotAbsorptionClicked( );
   void slotEmissionClicked( );
   void slotScatteringClicked( );
   void slotComboChanged( int c );

private:
   PMMedia* m_pDisplayedObject;
   PMIntEdit* m_pIntervalsEdit;
   QLabel* m_pSamplesMinLabel;
   PMIntEdit* m_pSamplesMinEdit;
   QLabel* m_pSamplesMaxLabel;
   PMIntEdit* m_pSamplesMaxEdit;
   PMFloatEdit* m_pConfidenceEdit;
   PMFloatEdit* m_pVarianceEdit;
   PMFloatEdit* m_pRatioEdit;
   
   PMColorEdit* m_pAbsorptionEdit;
   QLabel* m_pAbsorptionLabel;
   PMColorEdit* m_pEmissionEdit;
   QLabel* m_pEmissionLabel;
   QLabel* m_pScatteringTypeLabel;
   QComboBox* m_pScatteringTypeEdit;
   QLabel* m_pScatteringColorLabel;
   PMColorEdit* m_pScatteringColorEdit;
   QLabel* m_pScatteringEccentricityLabel;
   PMFloatEdit* m_pScatteringEccentricityEdit;
   QLabel* m_pScatteringExtinctionLabel;
   PMFloatEdit* m_pScatteringExtinctionEdit;
   QCheckBox* m_pEnableIntervalsEdit;
   QCheckBox* m_pEnableSamplesEdit;
   QCheckBox* m_pEnableConfidenceEdit;
   QCheckBox* m_pEnableVarianceEdit;
   QCheckBox* m_pEnableRatioEdit;
   QCheckBox* m_pEnableAbsorptionEdit;
   QCheckBox* m_pEnableEmissionEdit;
   QCheckBox* m_pEnableScatteringEdit;
};


#endif
