/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	trnmnu.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_trans_menu class header
 *
 *	RCSid = "$Id: trnmnu.H,v 4.4.1.1 1993/06/01 22:57:09 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_trnmnu_H
#define OI_trnmnu_H

#ifndef OI_basmnu_H
#include <OI/basmnu.H>
#endif /* OI_basmnu_H */

	// class forward reference declaration
	class OI_mdl_trans_menu;

	class OI_trans_menu : public OI_basic_menu {
			OI_mdl_trans_menu	*mdl_dep ;
	 public:
		static	OI_class		*clsp ;				/* ptr to class record */

	 private:
			void			construct() ;
			OI_number		sav_btn;	/* Value of the btn saved during the time a pulldown off of this menu is active. */
	 protected:
						OI_trans_menu(OI_class *clsp, const char *usr_namp, OI_orient or=OI_VERTICAL,
							const char *ttl=NULL) ;
						~OI_trans_menu() ;
		virtual	void			init_selections() ;				/* initialize preselected cells */
		virtual	void			new_model(OI_model_type) ;
         public:
	 /* public functions reserved for toolkit use */
		virtual	OI_menu_cell		*abbr_cell() ;
		virtual	OI_menu_cell		*cell_to_fire(OI_menu_cell*,OI_bool=OI_NO) ;
		virtual	void			cell_focus_in(OI_menu_cell*);
		virtual	void			cell_focus_out(OI_menu_cell*);
		virtual	void			cell_focus_paint(OI_menu_cell*);
		static	OI_bool			init(OI_connection*) ;
		virtual	OI_number		num_abbr_cell() ;
		virtual	OI_stat			num_set_abbr_cell(OI_number n) ;
		virtual	OI_bool			popup_focus_frame_width();	/* should popup menu use a focus frame? */
		virtual	OI_stat			set_abbr_cell(const char *np) ;
		virtual	OI_stat			set_trigger(OI_number, OI_number=0) ;
			void			touch(OI_menu_cell*, OI_bool=OI_YES) ;		/* touch a cell as the current selection */

			void			fire_cell(OI_menu_cell *);
			void			set_save_button(OI_number n)		{sav_btn = n;}
			OI_number		save_button()				{return(sav_btn);}
	 /* normal public functions */
		virtual	void			allow_unsel() ;
		virtual	void			disallow_unsel() ;
		virtual	OI_bool			is_unsel() ;
		virtual	void			allow_resel() ;
		virtual	void			disallow_resel() ;
		virtual	OI_bool			is_resel() ;
		virtual	OI_stat			num_set_default_cell(OI_number) ;
		virtual	OI_stat			select_cell(OI_bool, OI_menu_cell*, OI_bool=OI_NO, OI_bool=OI_YES) ;
		virtual	OI_stat			set_default_cell(const char*) ;
	} ;

#endif /* OI_trnmnu_H */
