. ../locations.include
MYPWD=`pwd`
export MYPWD

#clean up old ones
for i in 1 2 3 4 5
do
   if [ -d $RELEASEDIR/$ARCH-disc0-disc$i ] ; then
	rm -r $RELEASEDIR/$ARCH-disc0-disc$i
   fi
done
if [ -d $RELEASEDIR/$ARCH-disc0 ] ; then
	rm -r $RELEASEDIR/$ARCH-disc0
fi
# Make disc0
mkdir -vp $RELEASEDIR/$ARCH-disc0/$DEFAULT
mkdir -v $RELEASEDIR/$ARCH-disc0/$DEFAULT/base
mkdir $RELEASEDIR/$ARCH-disc0/$DEFAULT.documentation
if [ -d $RELEASEDIR/$ARCH/$DEFAULT.documentation ] ; then
  cp -ra $RELEASEDIR/$ARCH/$DEFAULT.documentation/ $RELEASEDIR/$ARCH-disc0/
fi
cp -a $RELEASEDIR/$ARCH/$DEFAULT.releasenote $RELEASEDIR/$ARCH-disc0/
cp -a $RELEASEDIR/$ARCH/README $RELEASEDIR/$ARCH-disc0/
#copy in isolinux and special *.iso config files
mkdir $RELEASEDIR/$ARCH-disc0/isolinux
cp -fa $RELEASEDIR/$ARCH/isolinux/* $RELEASEDIR/$ARCH-disc0/isolinux/
if [ -f $RELEASEDIR/$ARCH/$DEFAULT/build/isolinux/isolinux.cfg.iso ] ; then
 cp -f $RELEASEDIR/$ARCH/$DEFAULT/build/isolinux/isolinux.cfg.iso $RELEASEDIR/$ARCH-disc0/isolinux/isolinux.cfg
fi
if [ -f $RELEASEDIR/$ARCH/$DEFAULT/build/isolinux/boot.msg.iso ] ; then
 cp -f $RELEASEDIR/$ARCH/$DEFAULT/build/isolinux/boot.msg.iso $RELEASEDIR/$ARCH-disc0/isolinux/boot.msg
fi
#make updates.img from original area and copy in
$MYPWD/../make.updates.img.sh 
#Copy over misc things
cp $RELEASEDIR/$ARCH/.discinfo $RELEASEDIR/$ARCH-disc0/
mkdir -p $RELEASEDIR/$ARCH-disc0/$DEFAULT/build
cp -a $RELEASEDIR/$ARCH/$DEFAULT/build $RELEASEDIR/$ARCH-disc0/$DEFAULT/
cp -a $RELEASEDIR/$ARCH/$DEFAULT/base $RELEASEDIR/$ARCH-disc0/$DEFAULT/
cp -a $RELEASEDIR/$ARCH/RPM-GPG-KEYs $RELEASEDIR/$ARCH-disc0/
cp -a $RELEASEDIR/$ARCH/RELEASE-NOTES*.html $RELEASEDIR/$ARCH-disc0/
#copy in $DEFAULT/RPMS which are RPMS 
mkdir $RELEASEDIR/$ARCH-disc0/$DEFAULT/RPMS
ln $RELEASEDIR/$ARCH/$DEFAULT/RPMS/*.rpm $RELEASEDIR/$ARCH-disc0/$DEFAULT/RPMS
#Need to move the big SRPMS/vendor directory out of the way as splittree.py
#cannot handle this, we put it back at the end, this also means that these
#will not be on the cd's
mv $RELEASEDIR/SRPMS/vendor .. 
#
echo "Using $RELEASEDIR/$ARCH/$DEFAULT/base/$FILEORDER as the fileorder file"
echo "and not making a new one"
cp -v $RELEASEDIR/$ARCH/$DEFAULT/base/$FILEORDER $RELEASEDIR/$ARCH-disc0/$DEFAULT/base/
#echo "and making a new one"
#$ANACONDADIR/pkgorder $RELEASEDIR/$ARCH $ARCH $DEFAULT > $RELEASEDIR/$ARCH-disc0/$DEFAULT/base/$FILEORDER
#Run splittree.py to split the $DEFAULT/RPMS onto multiple cd's
echo "Running splittree to decide on how to span the cd images"
$ANACONDADIR/splittree.py --arch=$ARCH --total-discs=4 --bin-discs=3 --src-discs=1 --release-string=$DEFAULT --default=$DEFAULT --pkgorderfile=$RELEASEDIR/$ARCH-disc0/$DEFAULT/base/$FILEORDER --distdir=$RELEASEDIR/$ARCH-disc0 --srcdir=$RELEASEDIR/SRPMS/
mv ../vendor $RELEASEDIR/SRPMS/
#Run genhdlist to create new hdlist's with cd numbers 
echo "Running genhdlist against $RELEASEDIR/`pwd`/$ARCH-disc0-disc[123]"
cd $RELEASEDIR
$ANACONDADIR/genhdlist --withnumbers --fileorder `pwd`/$ARCH-disc0/$DEFAULT/base/$FILEORDER --default $DEFAULT `pwd`/$ARCH-disc0-disc1  `pwd`/$ARCH-disc0-disc2 `pwd`/$ARCH-disc0-disc3 
# comment out the genhdlist below if you have to go to 4 cd's and comment out
# the one above
#$ANACONDADIR/genhdlist --withnumbers --fileorder `pwd`/$ARCH-disc0/$DEFAULT/base/$FILEORDER --default $DEFAULT `pwd`/$ARCH-disc0-disc1  `pwd`/$ARCH-disc0-disc2 `pwd`/$ARCH-disc0-disc3 `pwd`/$ARCH-disc0-disc4
#
#Now make the iso images
#CHECK that $CDISOAREA exists and make if it does not
if [ -d $CDISOAREA ] ; then
  echo "Creating CD iso images in $CDISOAREA"
else
  mkdir -p $CDISOAREA 
fi
# Make disc1
cd $MYPWD/subscripts
$MYPWD/subscripts/makeapt.sl.iso.sh 1
cd $RELEASEDIR/$ARCH-disc0-disc1
$MYPWD/subscripts/mkisoimage.disc1.sh . "$CDISOAREA/$DEFAULT.$VERSION.$DATE.disc1.iso" 
echo "implanting md5sum in disc1 now"
/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$DEFAULT.$VERSION.$DATE.disc1.iso
# Make disc2
cd $MYPWD/subscripts
$MYPWD/subscripts/makeapt.sl.iso.sh 2
cd $RELEASEDIR/$ARCH-disc0-disc2
$MYPWD/subscripts/mkisoimage.disc2.sh . "$CDISOAREA/$DEFAULT.$VERSION.$DATE.disc2.iso" 
echo "implanting md5sum in disc2 now"
/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$DEFAULT.$VERSION.$DATE.disc2.iso
# Make disc3
cd $MYPWD/subscripts
$MYPWD/subscripts/makeapt.sl.iso.sh 3
cd $RELEASEDIR/$ARCH-disc0-disc3
$MYPWD/subscripts/mkisoimage.disc3.sh . "$CDISOAREA/$DEFAULT.$VERSION.$DATE.disc3.iso" 
echo "implanting md5sum in disc3 now"
/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$DEFAULT.$VERSION.$DATE.disc3.iso
# Make disc4
cd $MYPWD/subscripts
$MYPWD/subscripts/makeapt.sl.iso.sh 4
cd $RELEASEDIR/$ARCH-disc0-disc4
$MYPWD/subscripts/mkisoimage.disc4.sh . "$CDISOAREA/$DEFAULT.$VERSION.$DATE.disc4.iso" 
echo "implanting md5sum in disc4 now"
/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$DEFAULT.$VERSION.$DATE.disc4.iso
# Make disc5
#cd $MYPWD/subscripts
#$MYPWD/subscripts/makeapt.sl.iso.sh 5
cd $RELEASEDIR/$ARCH-disc0-disc5
#$MYPWD/subscripts/mkisoimage.disc5.sh . "$CDISOAREA/$DEFAULT.$VERSION.$DATE.disc5.iso"
#echo "implanting md5sum in disc5 now"
#/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$DEFAULT.$VERSION.$DATE.disc5.iso
cd $CDISOAREA
echo "Making md5sums now, this will take a while"
md5sum $DEFAULT.$VERSION.$DATE.disc?.iso > $DEFAULT.$VERSION.$DATE.md5sum
