/* A test for smblib ... */

#include <sys/types.h>
#include <unistd.h>

#include "smblib.h"

char data[65536] = "Now is the time for all birds to roost.";
char slosh[2] = "\\";

int verbose = FALSE;
int use_slosh = FALSE; /* Use a leading slash on addresses ... */

void usage()

{

  fprintf(stderr, "test_smblib [-b <slosh> -u <user> -s <file-service>] [-w <write-size] -v server [password]\n");

}

/* Copy a string with a slosh on the front */

void smb_strncpy(char *dest, char *source, int destlen)

{
  if (use_slosh == TRUE)
    strncpy(dest, slosh, destlen);
  else
    strncpy(dest, "", destlen);

  strncat(dest, source, destlen - strlen(dest));
}

char *SMB_Prots[] = {"PC NETWORK PROGRAM 1.0", 
			    "MICROSOFT NETWORKS 1.03",
			    "MICROSOFT NETWORKS 3.0",
			    "LANMAN1.0",
			    "LM1.2X002",
		            "LANMAN2.1",
			    "NT LM 0.12",
			    "NT LANMAN 1.0",
			    NULL};

main(int argc, char *argv[])

{ void *con, *tree, *tree2, *file;
  extern char *optarg;
  extern int optind;
  int opt, actual_size, i, written, error, SMB_Error, err_class, err_code;
  char server[80], service[80], service_name[160], password[80], username[80];
  char file_name[80], error_message[1024], err_string[1024];
  char file_name2[80];
  int lotc = FALSE, count;
  SMB_CP_dirent dir_list[10];

  actual_size = 8192;
  strcpy(service, "msfax");
  strcpy(username, "fred");

  while ((opt = getopt(argc, argv, "b:s:w:u:lv")) != EOF) {

    switch (opt) {
    case 's':

      strcpy(service, optarg);
      break;

    case 'w':

      actual_size = atoi(optarg) * 1024;
      break;

    case 'b':     /* set the slosh character */
      strncpy(slosh, optarg, sizeof(slosh) - 1);
      break;

    case 'u':     /* Pick up the user name */

      strncpy(username, optarg, sizeof(username) - 1);
      break;

    case 'l':     /* do a logon and tree connect ... */
      lotc = TRUE;
      break;

    case 'v':     /* Verbose? */
      verbose = TRUE;
      break;

    default:

      usage();
      exit(1);
      break;
    }

  }

  if (actual_size < 1024)
    actual_size = 1024;

  if (actual_size > sizeof(data))
    actual_size = sizeof(data);

  if (optind < argc) { /* Some more parameters, assume is the server */
    strncpy(server, argv[optind], sizeof(server) - 1);
    optind++;

    if (optind < argc) { /* Pick up password ... */
      strncpy(password, argv[optind], sizeof(password) -1);
    }
    else {
      strcpy(password, "nurk");
    }
  }
  else {
    strcpy(server, "nemesis");
  }

  SMB_Init();          /* Initialize things ... */

  sprintf(service_name, "%s%s%s%s%s", slosh, slosh, server, slosh, service);

  fprintf(stderr, "Connecting to %s ...\n", service_name);

  if (lotc == TRUE) { /* Then do the combined crap, else ... */

    /* We must do a connect server and a negotiate first */

    con = SMB_Connect_Server(NULL, server);

    if (con == NULL) {  /* Error processing */

      fprintf(stderr, "Unable to connect to server %s ...\n", server);

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }

      printf("  %s\n", err_string);
      exit(1);

    }

    /* We need to negotiate a protocol better than PC NetWork Program */

    if (SMB_Negotiate(con, SMB_Prots) < 0) {

      fprintf(stderr, "Unable to negotiate a protocol with server %s ...\n",
	      server);

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }

      printf("  %s\n", err_string);
      exit(1);

    }

    /* Should check the protocol level ... */

    if (SMB_Get_Protocol(con) == SMB_P_NT1) { /* Then do it this way */

      if ((tree = SMB_Logon_And_TCon(con, 
				     NULL, 
				     username, 
				     password, 
				     service_name, "A:")) == NULL) {

	fprintf(stderr, "Unable to logon and tree connect to server %s ...\n",
		server);

	if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	  SMB_Error = SMB_Get_Last_SMB_Err();
	  SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
				SMBlib_Error_Code(SMB_Error),
				err_string,
				sizeof(err_string) - 1);

	}
	else {
	  SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
	}

	printf("  %s\n", err_string);

	exit(1);       /* Too bad ... */
      }

    }
    else { /* Try with a logon and then a TCON */

      if ((tree = SMB_Logon_And_TCon(con, 
				     NULL,
				     username, 
				     password, 
				     service_name, "A:")) == NULL) {/**/

/*      if (SMB_Logon_Server(con, username, password) < 0) { /* Handle the err */

	fprintf(stderr, "Unable to logon to server %s ...\n",
		server);

	if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	  SMB_Error = SMB_Get_Last_SMB_Err();
	  SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
				SMBlib_Error_Code(SMB_Error),
				err_string,
				sizeof(err_string) - 1);

	}
	else {
	  SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
	}

	printf("  %s\n", err_string);

	exit(1);       /* Too bad ... */

      }

      fprintf(stderr, "Logged on and connected ...\n");
    }

  }
  else {

    con = SMB_Connect(NULL, &tree, service_name, "Guest", password);

    if (con == NULL) { /* Error ... */

      fprintf(stderr, "Unable to connect ... \n");

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);

      }

      fprintf(stderr, "  %s\n", err_string);

      exit(1);  /* Can't proceed ... */

    }
  }

  fprintf(stderr, "Now we check to see if we can connect to the same file service.\n");

  tree2 = SMB_TreeConnect(con, NULL, service_name, password, "A:");

  if (tree2 == NULL) {

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);

    }

    fprintf(stderr, "Could not connect to tree: %s again.\n  %s\n",
	    service_name, err_string);

  }
  else {

    fprintf(stderr, "Connected again to tree: %s.\n", service_name);

  }

  strcpy(file_name, "netfax.q");

  fprintf(stderr, "Attempting to open \'%s\' ...\n", file_name);

  file = SMB_Open(tree, NULL, file_name, SMB_AMODE_OPENRW, SMB_FA_ORD);

  if (file == NULL) { /* We failed, so try again, but print an error mess */

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);

    }

    fprintf(stderr, "Error opening file:\n  %s\n", err_string);

    fprintf(stderr, "Perhaps we need a \\ on the front. Trying again...\n");

    /* not put a slosh at the front and try again */

    use_slosh = TRUE;
    smb_strncpy(file_name2, file_name, sizeof(file_name2) - 1);
    use_slosh = FALSE;

    fprintf(stderr, "Attempting to open file \'%s\'.\n", file_name2); 

    file = SMB_Open(tree, NULL, file_name2, SMB_AMODE_OPENRW, SMB_FA_ORD);

    if (file != NULL) { /* Tell the world ... */

      use_slosh = TRUE;
      fprintf(stderr, "--> Server needs %s in front of file names\n",
	      slosh);

    }

  }

  /* Check how we did, maybe we need to try again with a slosh on the front */

  if (file != NULL) { /* Now close the file ... */

    /* Now write and close the file ... */

    for (i=0; i< actual_size; i++)
      data[i] = (char)(i & 0xFF);

    strncpy(data + actual_size - 20, "abcdefghijklmnopqrs", 19);

    fprintf(stderr, "Attempting to write %i bytes to the file ... \n",
	    actual_size);

    written = SMB_Write(file, data, actual_size);

    fprintf(stderr, "Bytes written = %i\n", written);

    fprintf(stderr, "Now setting file pos to 512 and writing again ...\n");

    SMB_Lseek(file, 512, SEEK_SET);

    written = SMB_Write(file, data, actual_size);

    fprintf(stderr, "Bytes written = %i\n", written);

    fprintf(stderr, "Now read from start for 1024 bytes ...\n");

    SMB_Lseek(file, 0, SEEK_SET);

    for (i = 0; i < sizeof(data); i++)
      data[i] = 0xff;

    SMB_Read(file, data, 1024); 

    fprintf(stderr, "Attempting to close the file just opened ...\n");
    SMB_Close(file);

  }
  else { /* Error opening the file */

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);

      }

      fprintf(stderr, "Error opening file:\n  %s\n", err_string);

  }

  smb_strncpy(file_name, "xyzwertyaaa.dfgty", sizeof(file_name) - 1);

  fprintf(stderr, "Attempting to create file %s ...\n", file_name);

  file = SMB_Create(tree, NULL, file_name, SMB_FA_ORD);

  if (file != NULL) { /* Do something with the file ... */

    /* Now attempt to write the file ... */

    fprintf(stderr, "The file was opened OK. So now write it ...\n");

    written = SMB_Write(file, data, actual_size);

    fprintf(stderr, "Now close the file just created ...\n");

    SMB_Close(file);

  }
  else { /* Report the error ... */

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      
    }

    fprintf(stderr, "Error creating file:\n  %s\n", err_string);

  }

  strcpy(file_name, "delete.txt");

  fprintf(stderr, "Attempting to delete the file '%s' ...\n", file_name);

  if (SMB_Delete(tree, file_name, SMB_FA_ORD) < 0) {

    fprintf(stderr, "The file could not be deleted ... \n");

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      
    }

    fprintf(stderr, "  %s\n", err_string);


    fprintf(stderr, "Perhaps we are talking to PW4Ultrix ..., try again ...\n");
    fprintf(stderr, "Trying to delete %s%s ... \n", slosh, file_name);

    strcpy(file_name2, slosh);
    strncat(file_name2, file_name, sizeof(file_name2) - strlen(file_name));

    if (SMB_Delete(tree, file_name2, SMB_FA_ORD) < 0) {
      fprintf(stderr, "Still could not be deleted ...\n");
      
      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      
      }

      fprintf(stderr, "  %s\n", err_string);

    }
    else {
      fprintf(stderr, "Deleted now ...\n");
    }
  }
  else {

    fprintf(stderr, "The file was deleted ... \n");

  }


  smb_strncpy(file_name, "alongnamehurts.txt", sizeof(file_name) - 1);

  fprintf(stderr, "Attempting to create '%s' ...\n", file_name);

  file = SMB_Create(tree, NULL, file_name, 0);

  if (file == NULL) { /* It failed ... why? */

    fprintf(stderr, "Creating file '%s' failed ...\n", file_name);

  }
  else
    fprintf(stderr, "  File created successfully.\n");

  smb_strncpy(file_name, "another-dir-name", sizeof(file_name) - 1);

  fprintf(stderr, "Attempting to create directory \'%s\' ...\n", file_name);

  if (SMB_Create_Dir(tree, file_name) < 0) {

    fprintf(stderr, "Creating directory \'%s\' failed ...\n", file_name);

  }
  else
    fprintf(stderr, "  Directory created successfully.\n");

  fprintf(stderr, "Attempting to check the directory \'%s\' ...\n", file_name);

  if (SMB_Check_Dir(tree, file_name) < 0) {

    fprintf(stderr, "Directory \'%s\' does not exist or is inaccessible ...\n",
	    file_name);

  }
  else
    fprintf(stderr, "  Directory checked successfully.\n");

  fprintf(stderr, "Attempting to delete directory \'%s\' ... \n", file_name);

  if (SMB_Delete_Dir(tree, file_name) < 0) {

    fprintf(stderr, "Deleting directory \'%s\' failed ...\n", file_name);

  }
  else
    fprintf(stderr, "  Directory deleted successfully.\n");
  
  /* Now do a directory listing ... */

  strcpy(file_name, "\\*.*");

  if ((count = SMB_Search(tree, file_name, 0, dir_list, 10, "", 0)) < 0){

    fprintf(stderr, "Directory listing failed ...\n");
    
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      
    }

    fprintf(stderr, "  %s\n", err_string);
 

  }
  else { /* List the directory entries ... */

    if (count == 0) {

      fprintf(stderr, "\n  No files found.\n\n");

    }
    else {

      fprintf(stderr, "  File Name            Size        Attribs  Date\n");
      fprintf(stderr, "  ---------            ----------  -------  ----\n");

      for (i = 0; i < count; i++) {

	fprintf(stderr, "  %-20s %-10i  %-7s  %s\n", dir_list[i].filename, 
		dir_list[i].size, 
		SMB_AtrToStr(dir_list[i].file_attributes, FALSE),
		SMB_DOSTimToStr(dir_list[i].date_time));

      }

      fprintf(stderr, "\n");

    }
  }

  /* Should clean up here ... */

  fprintf(stderr,"Done\n");

}
