/* Test out the RFCNB routines ...

   Version 1.0

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "rfcnb.h"
#include <stdio.h>
#include <errno.h>

/* Input name is 1234567890123456                              */
char *name1 =   "A name          ";
/* Output name   12345678901234567890123456789012              */
char *name2 =   "                                ";

void usage() 

{

  fprintf(stderr, "Usage: test_rfcnb <called-name> [<calling_name>] -acalled-address\n");
  fprintf(stderr, "\tIf <calling_name> is not specified, then current");
  fprintf(stderr, " hostname is used.\n");
  fprintf(stderr, "\tIf there are problems getting current hostname, 'unknown' is used\n");
  fprintf(stderr, "\tCalled-address allows you to specify an ip address or DNS name\n");
  fprintf(stderr, "\tto connect to.\n");
  fprintf(stderr, "\n");

}


int main(int argc, char *argv[])

{ void *con;
  char err_string[200];
  char called[80] = "", calling[80] = "", address[1024] = "";
  extern char *optarg;
  int opt, i;
  int case_names = 0, add_sys = 0;

  if (argc == 1) {

    usage();

    exit(1);

  }

  if (*argv[1] != '-') {

    strncpy(called, argv[1], sizeof(called));

    argc--;      /* Bloody awful hack ... */
    argv++;

    if ((argc > 1) && (*argv[1] != '-')){ /* Set calling name to called name */

      /* Of course the hacks above change argv and argc ... */

      strncpy(calling, argv[1], sizeof(calling));

      argc--;
      argv++;

      
    }
    else {

      if (gethostname(calling, sizeof(calling)) < 0) { /* no name? */

	strncpy(calling, "unknown", sizeof(calling));

      }
    }
  }

  while ((opt = getopt (argc, argv, "usa:")) != EOF) {

    switch (opt) {
    case 'a':
      strcpy(address, optarg);
      break;

    case 's':  /* Add sys flag 0x01 on end of name */
      add_sys = 1;
      break;

    case 'u':  /* Upper case names */
      case_names = 1;
      break;

    default:
      usage();
      break;
    }

  }

  if (strcmp(called, "") == 0) {

    usage();

    exit(1);

  }

  fprintf(stderr, "Calling %s from %s", called, calling);
  if (strcmp(address,"") == 0) {

    fprintf(stderr, ".\n");

  }
  else {

    fprintf(stderr, " at address: %s.\n", address);

  }

  /* Now, we use address to overcome problems below */

  if (strcmp(address, "") == 0)
    strcpy(address, called);

  if (case_names == 1) {
    for (i=0; i<strlen(called); i++)
      called[i] = toupper(called[i]);
    for (i=0; i<strlen(calling); i++)
      calling[i] = toupper(calling[i]);
  }

  if ((con = RFCNB_Call(called, calling, address, 0)) == NULL) {

    RFCNB_Get_Error(err_string, sizeof(err_string));
    printf("Error in calling: %s ...\n", err_string);
    exit(1);

  }

  printf("The end ...\n");
}
