/* UNIX SMBlib NetBIOS implementation

   Version 1.0
   SMBlib Routines

   Copyright (C) Richard Sharpe 1996

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "smblib-priv.h"

#include "rfcnb/rfcnb.h"

/* Initialize the SMBlib package     */

int SMB_Init()

{

  SMBlib_State = SMB_State_Started;

  return 0;

}

int SMB_Term()

{

  return 0;

}

/* SMB_Create: Create a connection structure and return for later use */
/* We have other helper routines to set variables                     */

SMB_Handle_Type SMB_Create()

{

}

/* SMB_Connect: Connect to the indicated server                       */
/* If Con_Handle == NULL then create a handle and connect, otherwise  */
/* use the handle passed                                              */

SMB_Handle_Type SMB_Connect(SMB_Handle_Type Con_Handle,
			    char *service, 
			    char *username, 
			    char *password)

{
  SMB_Handle_Type con;
  char *host;
  char temp[80];

  /* Get a connection structure if one does not exist */

  con = Con_Handle;

  if (Con_Handle == NULL) {

    if ((con = (struct SMB_Connect_Def *)malloc(sizeof(struct SMB_Connect_Def))) == NULL) {

      /* Some debugging output and a response somewhere? */

      return NULL;
    }

  }

  /* Init some things ... */

  strcpy(con -> service, service);
  strcpy(con -> username, username);
  strcpy(con -> password, password);
  strcpy(con -> sock_options, "");

  SMB_Get_My_Name(con -> myname, sizeof(con -> myname));

  con -> port = 0;                    /* No port selected */

  /* Get some things we need for the SMB Header */

  con -> pid = getpid();
  con -> mid = con -> pid;      /* This will do for now ... */
  con -> uid = getuid();    
  con -> gid = getgid();

  /* Now figure out the host portion of the service */

  strcpy(temp, service);
  host = strtok(temp, "/\\");     /* Separate host name portion */
  strcpy(con -> desthost, host);

  /* Now connect to the remote end */

  con -> Trans_Connect = RFCNB_Call(con -> desthost,
				    con -> myname,
				    con -> port);

  /* Did we get one? */

  if (con -> Trans_Connect == NULL) {

    /* We should pick up the error here ... and deallocate the con */

    return NULL;

  }

  /* Now, negotiate the protocol */

  if (SMB_Negotiate(con, SMB_Prots, &(con -> protocol)) < 0) {

    return NULL;

  }

  /* Now connect to the service ... */

  if (SMB_TreeConnect(con, service, password, "C:") < 0) {

    return NULL;

  }


  return(con);

}

/* Open a file with file_name using desired mode and search attr  */
/* If File_Handle is null, then create and populate a file handle */

SMB_File *SMB_Open(SMB_Handle_Type Con_Handle,
		   SMB_File *File_Handle, 
		   char *file_name, 
		   WORD mode, 
		   WORD search)

{ struct SMB_Open_Prot_Def *prot_pkt;
  struct SMB_Open_Resp_Def *resp_pkt;
  struct RFCNB_Pkt *pkt;
  int pkt_len, param_len; char *p;
  struct SMB_File_Def *file_tmp;

  /* We allocate a file object and copy some things ... */

  if (File_Handle == NULL) {

    if ((file_tmp = (SMB_File *)malloc(sizeof(SMB_File))) == NULL){

      fprintf(stderr, "Could not allocate file handle space ...");
      return(NULL);

    }

    File_Handle = file_tmp;

  }

  strncpy(File_Handle -> filename, file_name, sizeof(File_Handle -> filename));
  File_Handle -> con = Con_Handle;
  File_Handle -> fid = 0xFFFF;  /* Is this an invalid FID? */

  param_len = strlen(file_name) + 2; /* 1 for null, 1 for ASCII marker */

  pkt_len = sizeof(struct SMB_Open_Prot_Def) - 1 + param_len;

  pkt = (struct RFCNB_Pkt *)RFCNB_Alloc_Pkt(pkt_len);

  if (pkt == NULL) { /* Really should do some error handling */

  }

  prot_pkt = (struct SMB_Open_Prot_Def *)(pkt -> data);

  /* Now plug in the bits we need */

  bzero(prot_pkt, sizeof(struct SMB_Open_Prot_Def));
  prot_pkt -> smb_hdr.smb_idf = SMB_DEF_IDF;
  prot_pkt -> smb_hdr.smb_com = SMBopen;
  prot_pkt -> smb_hdr.smb_pid = Con_Handle -> pid;
  prot_pkt -> smb_hdr.smb_tid = Con_Handle -> tid;
  prot_pkt -> smb_hdr.smb_mid = Con_Handle -> mid;

  prot_pkt -> smb_hdr.smb_wct = 2;
  prot_pkt -> smb_mode = mode;
  prot_pkt -> smb_attr = search;
  prot_pkt -> smb_bcc = param_len;

  /* Now plug in the file name ... */

  p = (char *)(prot_pkt -> smb_buf);
  *p = SMBasciiID;
  strcpy(p+1, file_name);
  p = p + strlen(file_name);
  *(p+1) = 0;                     /* plug in a null ... */

  /* Now send the packet and get the response ... */

  if (RFCNB_Send(Con_Handle -> Trans_Connect, pkt, pkt_len) < 0){

    fprintf(stderr, "Error sending Open request\n");
    
    return(NULL);

  }

  /* Now get the response ... */

  if (RFCNB_Recv(Con_Handle -> Trans_Connect, pkt, pkt_len) < 0) {

    fprintf(stderr, "Error receiving response to open request\n");
    return(NULL);

  }

  resp_pkt = (struct SMB_Open_Resp_Def *)(pkt -> data);

  /* Now parse the response and pass back any error ... */

  if (resp_pkt -> smb_hdr.smb_rcls != SMBC_SUCCESS) {  /* Process error */

    fprintf(stderr, "SMB_Open failed with errorclass = %i, Error Code = %i\n",
	    resp_pkt -> smb_hdr.smb_rcls, resp_pkt -> smb_hdr.smb_err);

    return(NULL);      /* Should clean up ... */

  }

  File_Handle -> fid     = resp_pkt -> smb_fhndl;
  File_Handle -> lastmod = resp_pkt -> smb_time;
  File_Handle -> size    = resp_pkt -> smb_size;
  File_Handle -> access  = resp_pkt -> smb_access;

  fprintf(stderr, "SMB_Open succeeded, FID = %i\n", File_Handle -> fid);

  return(File_Handle);

}

/* Close the file referred to in File_Handle */

int SMB_Close(SMB_File *File_Handle)

{ struct SMB_Close_Prot_Def *prot_pkt;
  struct SMB_Hdr_Def_LM12 *resp_pkt;
  struct RFCNB_Pkt *pkt;
  int pkt_len;

  if (File_Handle == NULL) { /* Error */

    /*SMBLIB_errno = SMBLIBE_BadHandle; */
    return(-1);

  }

  pkt_len = sizeof(struct SMB_Close_Prot_Def);

  pkt = (struct RFCNB_Pkt *)RFCNB_Alloc_Pkt(pkt_len);

  if (pkt == NULL) { /* Really should do some error handling */

  }

  prot_pkt = (struct SMB_Close_Prot_Def *)(pkt -> data);

  /* Now plug in the bits we need */

  bzero(prot_pkt, sizeof(struct SMB_Close_Prot_Def));
  prot_pkt -> smb_hdr.smb_idf = SMB_DEF_IDF;
  prot_pkt -> smb_hdr.smb_com = SMBclose;
  prot_pkt -> smb_hdr.smb_pid = File_Handle -> con -> pid;
  prot_pkt -> smb_hdr.smb_tid = File_Handle -> con -> tid;
  prot_pkt -> smb_hdr.smb_mid = File_Handle -> con -> mid;

  prot_pkt -> smb_hdr.smb_wct = 3;
  prot_pkt -> smb_fhndl = File_Handle -> fid;
  prot_pkt -> smb_time  = 0;
  prot_pkt -> smb_bcc   = 0;

  /* Now send the packet and get the response ... */

  if (RFCNB_Send(File_Handle -> con -> Trans_Connect, pkt, pkt_len) < 0){

    fprintf(stderr, "Error sending Open request\n");
    
    return(NULL);

  }

  /* Now get the response ... */

  if (RFCNB_Recv(File_Handle -> con ->  Trans_Connect, pkt, pkt_len) < 0) {

    fprintf(stderr, "Error receiving response to open request\n");
    return(NULL);

  }

  resp_pkt = (struct SMB_Hdr_Def_LM12 *)(pkt -> data);

  /* Now parse the response and pass back any error ... */

  if (resp_pkt -> smb_rcls != SMBC_SUCCESS) {  /* Process error */

    fprintf(stderr, "SMB_Open failed with errorclass = %i, Error Code = %i\n",
	    resp_pkt -> smb_rcls, resp_pkt -> smb_err);

    return(NULL);      /* Should clean up ... */

  }

#ifdef DEBUG
  fprintf(stderr, "File %s closed successfully.\n", File_Handle -> filename);
#endif DEBUG

  /* We should deallocate the File_Handle now ... */

  File_Handle -> con = NULL;
  File_Handle -> filename[0] = 0;
  File_Handle -> fid = 0xFFFF;
  
  return(0);
}

int SMB_Read(SMB_File *File_Handle, int bytes, int offset, char *data)

{

}


/* Disconnect from the server, and disconnect all tree connects */

int SMB_Discon(SMB_Handle_Type Con_Handle)

{

}

