#ifndef _OBJHANDLE_H_
#define _OBJHANDLE_H_

/*
    Windows NT Security functions library.
    Copyright (C) 1995  Jeremy R. Allison

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Log:	objhandle.h,v $
 * Revision 1.2  95/10/17  18:15:40  18:15:40  jra (Jeremy Allison)
 * Added lsa code.
 * 
 * Revision 1.1  1995/06/30  18:32:55  jra
 * Initial revision
 *^M
*/

#include <windows.h>
#include <tchar.h>

// Virtual base class for the Object security classes.

class obj_handle {
public:

	virtual BOOL GetObjectSecurity(	 SECURITY_INFORMATION, SECURITY_DESCRIPTOR *, DWORD, DWORD *) = 0;
	virtual BOOL SetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *) = 0;
};

// File object security handle.

class file_obj_handle : public obj_handle {
private:
	const TCHAR *file_;
public:
	file_obj_handle( const TCHAR *f) :file_(f) {;}
	BOOL GetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *, DWORD, DWORD *);
	BOOL SetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *);
};

// Kernel object security handle.

class kernel_obj_handle : public obj_handle {
private:
	HANDLE hand_;
public:
	kernel_obj_handle( HANDLE h) :hand_(h) {;}
	BOOL GetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *, DWORD, DWORD *);
	BOOL SetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *);
};

// User object security handle.

class user_obj_handle : public obj_handle {
private:
	HANDLE hand_;
public:
	user_obj_handle( HANDLE h) :hand_(h) {;}
	BOOL GetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *, DWORD, DWORD *);
	BOOL SetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *);
};

// Registry object security handle.

class reg_obj_handle : public obj_handle {
private:
	HKEY hand_;
public:
	reg_obj_handle( HKEY h) :hand_(h) {;}
	BOOL GetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *, DWORD, DWORD *);
	BOOL SetObjectSecurity( SECURITY_INFORMATION, SECURITY_DESCRIPTOR *);
};

#endif
