#ifndef _UNISTRING_H_
#define _UNISTRING_H_

#include <windows.h>
#include <wchar.h>
#include <string.h>
#include <mbstring.h>
#include <stdlib.h>

//
// Reference counted Unicode string class
//

class UniStringRef {
private:

	wchar_t *ustr_;
	int refCount_;
	BOOL weown_;

	// No copying refcounted class
	UniStringRef(const UniStringRef&);
	UniStringRef& operator=(const UniStringRef&);

public:

	// Create from a char * - convert the string.
	UniStringRef(const char *str) { 
		if(str == 0) {
			ustr_ = 0;
			return;
		}
		size_t size = _mbslen((const unsigned char *)str) + 1;
		ustr_ = new wchar_t [ size ];
		if(ustr_ == 0)
			throw (DWORD(ERROR_NOT_ENOUGH_MEMORY));
		mbstowcs(ustr_, str, size);
		weown_ = TRUE;
		refCount_ = 1;
	}
	// If it's already Unicode just copy the pointer.
	UniStringRef(wchar_t *wstr) { ustr_ = wstr; refCount_ = 1; weown_ = FALSE;}
	~UniStringRef() { delRef(); }

	operator const wchar_t *() const { return ustr_; }
	operator const wchar_t *() { return ustr_; }
	operator wchar_t *() const { return ustr_; }
	operator wchar_t *() { return ustr_; }

	void addRef() { refCount_++; };
	void delRef() { if((--refCount_ == 0) && (weown_)) delete [] ustr_; }
};

//
// Class to generate unicode strings from multibyte
// strings on the fly.
// Used so char * strings can be passed to functions
// that only take Unicode.
//

class UniString {
private:

	UniStringRef *usp_;

public:

	UniString(const char *str) {
		usp_ = new UniStringRef(str);
	}
	UniString(wchar_t *wstr) {
		usp_ = new UniStringRef(wstr);
	}
	UniString(const UniString& us) {
		usp_ = us.usp_;
		usp_->addRef();
	}
	UniString& operator=(const UniString& us) {
		if(&us == this)
			return *this;
		usp_->delRef();
		usp_ = us.usp_;
		usp_->addRef();
		return *this;
	}
	~UniString() { usp_->delRef(); }

	operator const wchar_t *() const { return (wchar_t *)*usp_; }
	operator const wchar_t *() { return (const wchar_t *)*usp_; }
	operator wchar_t *() const { return (wchar_t *)*usp_; }
	operator wchar_t *() { return (wchar_t *)*usp_; }
};

#endif
